/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorContext;
import akka.actor.ActorIdentity;
import akka.actor.ActorIdentity$;
import akka.actor.ActorNotFound$;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefWithCell;
import akka.actor.ActorSelection$;
import akka.actor.ActorSelectionMessage;
import akka.actor.ActorSelectionMessage$;
import akka.actor.Identify;
import akka.actor.Identify$;
import akka.actor.InternalActorRef;
import akka.actor.ScalaActorSelection;
import akka.actor.SelectionPathElement;
import akka.dispatch.ExecutionContexts$;
import akka.pattern.AskableActorSelection$;
import akka.pattern.package$;
import akka.routing.MurmurHash$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import akka.util.Timeout;
import akka.util.Timeout$;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.util.Success;
import scala.util.Try;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ActorSelection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(ActorSelection.class, "0bitmap$1");
    public long 0bitmap$1;
    public int hashCode$lzy1;

    public static ActorSelection apply(ActorRef actorRef, Iterable<String> iterable) {
        return ActorSelection$.MODULE$.apply(actorRef, iterable);
    }

    public static ActorSelection apply(ActorRef actorRef, String string) {
        return ActorSelection$.MODULE$.apply(actorRef, string);
    }

    public static void deliverSelection(InternalActorRef internalActorRef, ActorRef actorRef, ActorSelectionMessage actorSelectionMessage) {
        ActorSelection$.MODULE$.deliverSelection(internalActorRef, actorRef, actorSelectionMessage);
    }

    public static ScalaActorSelection toScala(ActorSelection actorSelection) {
        return ActorSelection$.MODULE$.toScala(actorSelection);
    }

    public abstract ActorRef anchor();

    public abstract IndexedSeq<SelectionPathElement> path();

    public void tell(Object msg, ActorRef sender) {
        ActorSelection$.MODULE$.deliverSelection((InternalActorRef)this.anchor(), sender, ActorSelectionMessage$.MODULE$.apply(msg, (scala.collection.immutable.Iterable<SelectionPathElement>)this.path(), false));
    }

    public void forward(Object message, ActorContext context) {
        this.tell(message, context.sender());
    }

    public Future<ActorRef> resolveOne(Timeout timeout) {
        ExecutionContext ec = ExecutionContexts$.MODULE$.parasitic();
        Promise p = Promise$.MODULE$.apply();
        ActorSelection actorSelection = package$.MODULE$.ask(this);
        Identify identify = Identify$.MODULE$.apply(None$.MODULE$);
        AskableActorSelection$.MODULE$.ask$extension(actorSelection, identify, timeout, AskableActorSelection$.MODULE$.ask$default$3$extension(actorSelection, identify)).onComplete((Function1 & Serializable)x$1 -> {
            Promise promise;
            Object object;
            Try try_ = x$1;
            if (try_ instanceof Success && (object = ((Success)try_).value()) instanceof ActorIdentity) {
                ActorIdentity actorIdentity = ActorIdentity$.MODULE$.unapply((ActorIdentity)object);
                Object object2 = actorIdentity._1();
                Option<ActorRef> option = actorIdentity._2();
                if (option instanceof Some) {
                    ActorRef ref = (ActorRef)((Some)option).value();
                    promise = p.success((Object)ref);
                    return promise;
                }
            }
            promise = p.failure((Throwable)ActorNotFound$.MODULE$.apply(this));
            return promise;
        }, ec);
        return p.future();
    }

    public Future<ActorRef> resolveOne(FiniteDuration timeout) {
        return this.resolveOne(Timeout$.MODULE$.durationToTimeout(timeout));
    }

    public CompletionStage<ActorRef> resolveOneCS(FiniteDuration timeout) {
        return FutureConverters$.MODULE$.toJava(this.resolveOne(timeout));
    }

    public CompletionStage<ActorRef> resolveOneCS(Duration timeout) {
        return this.resolveOne(timeout);
    }

    public CompletionStage<ActorRef> resolveOne(Duration timeout) {
        return FutureConverters$.MODULE$.toJava(this.resolveOne(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout))));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ActorSelection[Anchor(").append(this.anchor().path());
        if (this.anchor().path().uid() != 0) {
            builder.append("#").append(this.anchor().path().uid());
        }
        builder.append("), Path(").append(this.path().mkString("/", "/", "")).append(")]");
        return builder.toString();
    }

    public ActorPath anchorPath() {
        return this.anchor().path();
    }

    public String pathString() {
        return this.path().mkString("/", "/", "");
    }

    public String toSerializationFormat() {
        Object object;
        String string;
        ActorRef actorRef = this.anchor();
        if (actorRef instanceof ActorRefWithCell) {
            ActorRefWithCell a = (ActorRefWithCell)actorRef;
            string = this.anchor().path().toStringWithAddress(a.provider().getDefaultAddress());
        } else {
            string = this.anchor().path().toString();
        }
        String anchorPath = string;
        StringBuilder builder = new StringBuilder();
        builder.append(anchorPath);
        char lastChar = builder.charAt(builder.length() - 1);
        if (this.path().nonEmpty() && lastChar != '/') {
            object = builder.append(this.path().mkString("/", "/", ""));
        } else if (this.path().nonEmpty()) {
            builder.append(this.path().mkString("/"));
            object = BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof ActorSelection)) return false;
        ActorSelection s = (ActorSelection)object;
        ActorRef actorRef = this.anchor();
        ActorRef actorRef2 = s.anchor();
        if (actorRef == null) {
            if (actorRef2 != null) {
                return false;
            }
        } else if (!((Object)actorRef).equals(actorRef2)) return false;
        IndexedSeq<SelectionPathElement> indexedSeq = this.path();
        IndexedSeq<SelectionPathElement> indexedSeq2 = s.path();
        if (indexedSeq == null) {
            if (indexedSeq2 == null) return true;
            return false;
        } else {
            if (!indexedSeq.equals(indexedSeq2)) return false;
            return true;
        }
    }

    public int hashCode() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    int n;
                    int h = MurmurHash$.MODULE$.startHash(Statics.anyHash((Object)this.anchor()));
                    h = MurmurHash$.MODULE$.extendHash(h, Statics.anyHash(this.path()), MurmurHash$.MODULE$.startMagicA(), MurmurHash$.MODULE$.startMagicB());
                    this.hashCode$lzy1 = n = MurmurHash$.MODULE$.finalizeHash(h);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return n;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.hashCode$lzy1;
    }
}

