/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.Done;
import akka.Version$;
import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorRefWithCell;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$Settings$;
import akka.actor.Cell;
import akka.actor.ChildStats;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$;
import akka.actor.CoordinatedShutdown$ActorSystemTerminateReason$;
import akka.actor.DynamicAccess;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.actor.ExtensionIdProvider;
import akka.actor.InternalActorRef;
import akka.actor.LocalActorRef;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.ReflectiveDynamicAccess;
import akka.actor.Scheduler;
import akka.actor.StopChild;
import akka.actor.StopChild$;
import akka.actor.Terminated;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.ChildrenContainer$EmptyChildrenContainer$;
import akka.actor.dungeon.ChildrenContainer$TerminatedChildrenContainer$;
import akka.actor.dungeon.ChildrenContainer$TerminatingChildrenContainer$;
import akka.actor.setup.ActorSystemSetup;
import akka.annotation.InternalApi;
import akka.dispatch.DefaultDispatcherPrerequisites$;
import akka.dispatch.Dispatchers;
import akka.dispatch.Mailboxes;
import akka.dispatch.MonitorableThreadFactory;
import akka.dispatch.MonitorableThreadFactory$;
import akka.event.DeadLetterListener;
import akka.event.EventStream;
import akka.event.LogMarker$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.LoggingFilter;
import akka.event.MarkerLoggingAdapter;
import akka.japi.Util$;
import akka.serialization.SerializationExtension$;
import akka.util.ManifestInfo;
import akka.util.ManifestInfo$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.Vector;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalApi
public class ActorSystemImpl
extends ExtendedActorSystem {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(ActorSystemImpl.class, "0bitmap$1");
    public long 0bitmap$1;
    private final String name;
    private final ClassLoader classLoader;
    private final Option guardianProps;
    private volatile Option<ActorRef> logDeadLetterListener;
    private final DynamicAccess _dynamicAccess;
    private final ActorSystem.Settings settings;
    private final MonitorableThreadFactory threadFactory;
    private final EventStream eventStream;
    private final LoggingFilter logFilter;
    public final MarkerLoggingAdapter akka$actor$ActorSystemImpl$$markerLogging;
    private final LoggingAdapter log;
    private final Scheduler scheduler;
    private final ActorRefProvider provider;
    private final Mailboxes mailboxes;
    private final Dispatchers dispatchers;
    private final ExecutionContextExecutor dispatcher;
    private final TerminationCallbacks<Terminated> terminationCallbacks;
    private volatile boolean _initialized;
    private ActorSystemImpl _start$lzy1;
    private volatile boolean terminating;
    private volatile boolean aborting;
    private final ConcurrentHashMap<ExtensionId<?>, Object> extensions;

    public ActorSystemImpl(String name, Config applicationConfig, ClassLoader classLoader, Option<ExecutionContext> defaultExecutionContext, Option<Props> guardianProps, ActorSystemSetup setup) {
        this.name = name;
        this.classLoader = classLoader;
        this.guardianProps = guardianProps;
        if (!name.matches("^[a-zA-Z0-9][a-zA-Z0-9-_]*$")) {
            throw new IllegalArgumentException(new StringBuilder(109).append("invalid ActorSystem name [").append(name).append("], must contain only word characters (i.e. [a-zA-Z0-9] plus non-leading '-' or '_')").toString());
        }
        this.logDeadLetterListener = None$.MODULE$;
        this._dynamicAccess = this.createDynamicAccess();
        Config config = ActorSystem$Settings$.MODULE$.amendSlf4jConfig(applicationConfig.withFallback((ConfigMergeable)ConfigFactory.defaultReference((ClassLoader)classLoader)), this._dynamicAccess);
        this.settings = new ActorSystem.Settings(classLoader, config, name, setup);
        this.threadFactory = MonitorableThreadFactory$.MODULE$.apply(name, this.settings().Daemonicity(), (Option<ClassLoader>)Option$.MODULE$.apply((Object)classLoader), this.uncaughtExceptionHandler(), MonitorableThreadFactory$.MODULE$.$lessinit$greater$default$5());
        this.eventStream = new EventStream(this, this.settings().DebugEventStream());
        this.eventStream().startStdoutLogger(this.settings());
        Object[] objectArray = new Tuple2[2];
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(ActorSystem.Settings.class);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.settings());
        Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(EventStream.class);
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)this.eventStream());
        Vector arguments = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.logFilter = (LoggingFilter)this.dynamicAccess().createInstanceFor(this.settings().LoggingFilter(), (Seq<Tuple2<Class<?>, Object>>)arguments, ClassTag$.MODULE$.apply(LoggingFilter.class)).get();
        this.akka$actor$ActorSystemImpl$$markerLogging = new MarkerLoggingAdapter(this.eventStream(), new StringBuilder(2).append(this.getClass().getName()).append("(").append(name).append(")").toString(), this.getClass(), this.logFilter());
        this.log = this.akka$actor$ActorSystemImpl$$markerLogging;
        this.scheduler = this.createScheduler();
        this.provider = this.liftedTree1$1(name);
        this.mailboxes = new Mailboxes(this.settings(), this.eventStream(), this.dynamicAccess(), this.deadLetters());
        this.dispatchers = new Dispatchers(this.settings(), DefaultDispatcherPrerequisites$.MODULE$.apply(this.threadFactory(), this.eventStream(), this.scheduler(), this.dynamicAccess(), this.settings(), this.mailboxes(), defaultExecutionContext), this.log());
        this.dispatcher = this.dispatchers().defaultGlobalDispatcher();
        this.terminationCallbacks = new TerminationCallbacks<Terminated>(this, this.provider().terminationFuture(), (ExecutionContext)this.dispatcher());
        this._initialized = false;
        this.terminating = false;
        this.aborting = false;
        this.extensions = new ConcurrentHashMap();
    }

    @Override
    public String name() {
        return this.name;
    }

    public Option<Props> guardianProps() {
        return this.guardianProps;
    }

    @Override
    public final ActorSystem.Settings settings() {
        return this.settings;
    }

    public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return new Thread.UncaughtExceptionHandler(this){
            private final ActorSystemImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void uncaughtException(Thread thread, Throwable cause) {
                block12: {
                    block11: {
                        Throwable throwable;
                        block10: {
                            Option option;
                            throwable = cause;
                            if (throwable == null || (option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) break block10;
                            Throwable throwable2 = (Throwable)option.get();
                            break block11;
                        }
                        if (!(throwable instanceof InterruptedException) && !(throwable instanceof NotImplementedError) && !(throwable instanceof ControlThrowable)) break block12;
                    }
                    this.$outer.log().error(cause, "Uncaught error from thread [{}]", (Object)thread.getName());
                    return;
                }
                if (cause instanceof IncompatibleClassChangeError && cause.getMessage().startsWith("akka")) {
                    System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(569).append("Detected ").append(cause.getClass().getName()).append(" error, which MAY be caused by incompatible Akka versions on the classpath.\n                  | Please note that a given Akka version MUST be the same across all modules of Akka that you are using,\n                  | e.g. if you use akka-actor [").append(Version$.MODULE$.current()).append(" (resolved from current classpath)] all other core\n                  | Akka modules MUST be of the same version. External projects like Alpakka, Persistence plugins or Akka\n                  | HTTP etc. have their own version numbers - please make sure you're using a compatible set of libraries.\n                 ").toString())).replaceAll("[\r\n]", ""));
                }
                if (this.$outer.settings().JvmExitOnFatalError()) {
                    try {
                        this.logFatalError("shutting down JVM since 'akka.jvm-exit-on-fatal-error' is enabled for", cause, thread);
                        return;
                    }
                    finally {
                        System.exit(-1);
                    }
                }
                try {
                    this.logFatalError("shutting down", cause, thread);
                    return;
                }
                finally {
                    this.$outer.terminate();
                }
            }

            private void logFatalError(String message, Throwable cause, Thread thread) {
                System.err.print("Uncaught error from thread [");
                System.err.print(thread.getName());
                System.err.print("]: ");
                System.err.print(cause.getMessage());
                System.err.print(", ");
                System.err.print(message);
                System.err.print(" ActorSystem[");
                System.err.print(this.$outer.name());
                System.err.println("]");
                System.err.flush();
                cause.printStackTrace(System.err);
                System.err.flush();
                this.$outer.akka$actor$ActorSystemImpl$$markerLogging.error(LogMarker$.MODULE$.Security(), cause, new StringBuilder(51).append("Uncaught error from thread [{}]: ").append(cause.getMessage()).append(", ").append(message).append(" ActorSystem[{}]").toString(), (Object)thread.getName(), (Object)this.$outer.name());
            }
        };
    }

    @Override
    public final MonitorableThreadFactory threadFactory() {
        return this.threadFactory;
    }

    public DynamicAccess createDynamicAccess() {
        return new ReflectiveDynamicAccess(this.classLoader);
    }

    @Override
    public DynamicAccess dynamicAccess() {
        return this._dynamicAccess;
    }

    @Override
    public void logConfiguration() {
        this.log().info(this.settings().toString());
    }

    @Override
    public ActorSystemImpl systemImpl() {
        return this;
    }

    @Override
    public ActorRef systemActorOf(Props props, String name) {
        return this.systemGuardian().underlying().attachChild(props, name, true);
    }

    @Override
    public ActorRef actorOf(Props props, String name) {
        if (!this.guardianProps().isEmpty()) {
            throw new UnsupportedOperationException(new StringBuilder(90).append("cannot create top-level actor [").append(name).append("] from the outside on ActorSystem with custom user guardian").toString());
        }
        return this.guardian().underlying().attachChild(props, name, false);
    }

    @Override
    public ActorRef actorOf(Props props) {
        if (!this.guardianProps().isEmpty()) {
            throw new UnsupportedOperationException("cannot create top-level actor from the outside on ActorSystem with custom user guardian");
        }
        return this.guardian().underlying().attachChild(props, false);
    }

    @Override
    public void stop(ActorRef actor) {
        ActorPath path = actor.path();
        ActorPath guard = this.guardian().path();
        ActorPath sys = this.systemGuardian().path();
        ActorPath actorPath = path.parent();
        ActorPath actorPath2 = guard;
        ActorPath actorPath3 = actorPath;
        if (!(actorPath2 != null ? !actorPath2.equals(actorPath3) : actorPath3 != null)) {
            LocalActorRef localActorRef = this.guardian();
            StopChild stopChild = StopChild$.MODULE$.apply(actor);
            localActorRef.$bang(stopChild, localActorRef.$bang$default$2(stopChild));
        } else {
            ActorPath actorPath4 = sys;
            ActorPath actorPath5 = actorPath;
            if (!(actorPath4 != null ? !actorPath4.equals(actorPath5) : actorPath5 != null)) {
                LocalActorRef localActorRef = this.systemGuardian();
                StopChild stopChild = StopChild$.MODULE$.apply(actor);
                localActorRef.$bang(stopChild, localActorRef.$bang$default$2(stopChild));
            } else {
                ((InternalActorRef)actor).stop();
            }
        }
    }

    @Override
    public EventStream eventStream() {
        return this.eventStream;
    }

    @Override
    public LoggingFilter logFilter() {
        return this.logFilter;
    }

    @Override
    public LoggingAdapter log() {
        return this.log;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public ActorRefProvider provider() {
        return this.provider;
    }

    @Override
    public ActorRef deadLetters() {
        return this.provider().deadLetters();
    }

    @Override
    public Mailboxes mailboxes() {
        return this.mailboxes;
    }

    @Override
    public Dispatchers dispatchers() {
        return this.dispatchers;
    }

    @Override
    public ExecutionContextExecutor dispatcher() {
        return this.dispatcher;
    }

    @Override
    public Future<Terminated> whenTerminated() {
        return this.terminationCallbacks.terminationFuture();
    }

    @Override
    public CompletionStage<Terminated> getWhenTerminated() {
        return FutureConverters$.MODULE$.toJava(this.whenTerminated());
    }

    @Override
    public InternalActorRef lookupRoot() {
        return this.provider().rootGuardian();
    }

    @Override
    public LocalActorRef guardian() {
        return this.provider().guardian();
    }

    @Override
    public LocalActorRef systemGuardian() {
        return this.provider().systemGuardian();
    }

    @Override
    public ActorPath $div(String actorName) {
        return this.guardian().path().$div(actorName);
    }

    @Override
    public ActorPath $div(Iterable<String> path) {
        return this.guardian().path().$div(path);
    }

    @Override
    public ActorSystem classicSystem() {
        return this;
    }

    private List<String> allModules() {
        return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"akka-actor", "akka-actor-testkit-typed", "akka-actor-typed", "akka-cluster", "akka-cluster-metrics", "akka-cluster-sharding", "akka-cluster-sharding-typed", "akka-cluster-tools", "akka-cluster-typed", "akka-coordination", "akka-discovery", "akka-distributed-data", "akka-testkit", "akka-multi-node-testkit", "akka-osgi", "akka-persistence", "akka-persistence-query", "akka-persistence-shared", "akka-persistence-testkit", "akka-persistence-typed", "akka-pki", "akka-protobuf", "akka-protobuf-v3", "akka-remote", "akka-serialization-jackson", "akka-slf4j", "akka-stream", "akka-stream-testkit", "akka-stream-typed", "akka-stream-testkit"}));
    }

    public void assertInitialized() {
        if (!this._initialized) {
            throw new IllegalStateException("The calling code expected that the ActorSystem was initialized but it wasn't yet. This is probably a bug in the ActorSystem initialization sequence often related to initialization of extensions. Please report at https://github.com/akka/akka/issues.");
        }
    }

    private ActorSystemImpl _start() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    ActorSystemImpl actorSystemImpl;
                    this._start$lzy1 = actorSystemImpl = this.liftedTree3$1();
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return actorSystemImpl;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this._start$lzy1;
    }

    public ActorSystemImpl start() {
        return this._start();
    }

    @Override
    public <T> void registerOnTermination(Function0<T> code) {
        this.registerOnTermination(new Runnable(code){
            private final Function0 code$1;
            {
                this.code$1 = code$2;
            }

            public void run() {
                this.code$1.apply();
            }
        });
    }

    @Override
    public void registerOnTermination(Runnable code) {
        this.terminationCallbacks.add(code);
    }

    @Override
    public Future<Terminated> terminate() {
        Future<Done> future;
        this.terminating = true;
        if (this.settings().CoordinatedShutdownRunByActorSystemTerminate() && !this.aborting()) {
            future = ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this)).run(CoordinatedShutdown$ActorSystemTerminateReason$.MODULE$);
        } else {
            this.finalTerminate();
            future = BoxedUnit.UNIT;
        }
        return this.whenTerminated();
    }

    @Override
    public void finalTerminate() {
        this.terminating = true;
        if (!this.settings().LogDeadLettersDuringShutdown()) {
            this.logDeadLetterListener.foreach((Function1)(JProcedure1 & Serializable)actor -> this.stop((ActorRef)actor));
        }
        this.guardian().stop();
    }

    @Override
    public boolean isTerminating() {
        return this.terminating || this.aborting() || ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this)).shutdownReason().isDefined();
    }

    public boolean aborting() {
        return this.aborting;
    }

    public void aborting_$eq(boolean x$1) {
        this.aborting = x$1;
    }

    public void abort() {
        this.aborting_$eq(true);
        this.terminate();
    }

    public Scheduler createScheduler() {
        Object[] objectArray = new Tuple2[3];
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(Config.class);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.settings().config());
        Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class);
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)this.log());
        Class clazz3 = (Class)Predef$.MODULE$.ArrowAssoc(ThreadFactory.class);
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz3, (Object)this.threadFactory().withName(new StringBuilder(10).append(this.threadFactory().name()).append("-scheduler").toString()));
        return (Scheduler)this.dynamicAccess().createInstanceFor(this.settings().SchedulerClass(), (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), ClassTag$.MODULE$.apply(Scheduler.class)).get();
    }

    public void stopScheduler() {
        block0: {
            Scheduler scheduler = this.scheduler();
            if (!(scheduler instanceof Closeable)) break block0;
            Scheduler x = (Scheduler)((Object)((Closeable)((Object)scheduler)));
            ((Closeable)((Object)x)).close();
        }
    }

    private <T extends Extension> T findExtension(ExtensionId<T> ext) {
        Object object;
        ActorSystemImpl actorSystemImpl = this;
        while ((object = actorSystemImpl.extensions.get(ext)) instanceof CountDownLatch) {
            CountDownLatch c = (CountDownLatch)object;
            package$.MODULE$.blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> ActorSystemImpl.findExtension$$anonfun$1(ext, c, actorSystemImpl)));
        }
        if (object instanceof Throwable) {
            Throwable t = (Throwable)object;
            throw t;
        }
        Object other = object;
        return (T)((Extension)other);
    }

    @Override
    public final <T extends Extension> T registerExtension(ExtensionId<T> ext) {
        T t;
        block8: {
            T existing;
            T t2;
            ActorSystemImpl actorSystemImpl = this;
            while ((t2 = actorSystemImpl.findExtension(ext)) == null) {
                CountDownLatch inProcessOfRegistration = new CountDownLatch(1);
                Object object = actorSystemImpl.extensions.putIfAbsent(ext, inProcessOfRegistration);
                if (object != null) continue;
                try {
                    T t3 = ext.createExtension(actorSystemImpl);
                    if (t3 == null) {
                        throw new IllegalStateException(new StringBuilder(53).append("Extension instance created as 'null' for extension [").append(ext).append("]").toString());
                    }
                    try {
                        T instance = t3;
                        actorSystemImpl.extensions.replace(ext, inProcessOfRegistration, instance);
                        t = instance;
                        break block8;
                    }
                    catch (Throwable t4) {
                        actorSystemImpl.extensions.replace(ext, inProcessOfRegistration, t4);
                        throw t4;
                    }
                }
                finally {
                    inProcessOfRegistration.countDown();
                }
            }
            t = existing = t2;
        }
        return t;
    }

    @Override
    public <T extends Extension> T extension(ExtensionId<T> ext) {
        T t = this.findExtension(ext);
        if (t == null) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Trying to get non-registered extension [").append(ext).append("]").toString());
        }
        T some = t;
        return some;
    }

    @Override
    public boolean hasExtension(ExtensionId<? extends Extension> ext) {
        return this.findExtension(ext) != null;
    }

    private void loadExtensions() {
        this.loadExtensions$1("akka.library-extensions", true);
        this.loadExtensions$1("akka.extensions", false);
    }

    public String toString() {
        return this.lookupRoot().path().root().address().toString();
    }

    @Override
    public String printTree() {
        return ActorSystemImpl.printNode$1(this.lookupRoot(), "");
    }

    private final void liftedTree1$1$$anonfun$1() {
        this.stopScheduler();
    }

    private final ActorRefProvider liftedTree1$1(String name$1) {
        ActorRefProvider actorRefProvider;
        try {
            Object[] objectArray = new Tuple2[4];
            Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(String.class);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)name$1);
            Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(ActorSystem.Settings.class);
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)this.settings());
            Class clazz3 = (Class)Predef$.MODULE$.ArrowAssoc(EventStream.class);
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz3, (Object)this.eventStream());
            Class clazz4 = (Class)Predef$.MODULE$.ArrowAssoc(DynamicAccess.class);
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz4, (Object)this.dynamicAccess());
            Vector arguments = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            actorRefProvider = (ActorRefProvider)this.dynamicAccess().createInstanceFor(this.settings().ProviderClass(), (Seq<Tuple2<Class<?>, Object>>)arguments, ClassTag$.MODULE$.apply(ActorRefProvider.class)).get();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                Try$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)this::liftedTree1$1$$anonfun$1));
                throw e;
            }
            throw throwable;
        }
        return actorRefProvider;
    }

    private final void liftedTree3$1$$anonfun$1() {
        this.stopScheduler();
    }

    private final void liftedTree2$1$$anonfun$1() {
        this.stopScheduler();
    }

    private final Object liftedTree2$1() {
        Try try_;
        try {
            try_ = this.terminate();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                try_ = Try$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)this::liftedTree2$1$$anonfun$1));
            }
            throw throwable;
        }
        return try_;
    }

    private final ActorSystemImpl liftedTree3$1() {
        ActorSystemImpl actorSystemImpl;
        try {
            this.registerOnTermination((Function0)((JFunction0.mcV.sp & Serializable)this::liftedTree3$1$$anonfun$1));
            this.provider().init(this);
            this._initialized = true;
            if (this.settings().LogDeadLetters() > 0) {
                this.logDeadLetterListener = Some$.MODULE$.apply((Object)this.systemActorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(DeadLetterListener.class)), "deadLetterListener"));
            }
            this.eventStream().startUnsubscriber();
            ((ManifestInfo)ManifestInfo$.MODULE$.apply(this)).checkSameVersion("Akka", (Seq<String>)this.allModules(), true);
            if (!this.terminating) {
                this.loadExtensions();
            }
            if (this.settings().LogConfigOnStart()) {
                this.logConfiguration();
            }
            actorSystemImpl = this;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.liftedTree2$1();
                throw e;
            }
            throw throwable;
        }
        return actorSystemImpl;
    }

    private static final void findExtension$$anonfun$1(ExtensionId ext$1, CountDownLatch c$1, ActorSystemImpl $this$1) {
        long awaitMillis = $this$1.settings().CreationTimeout().duration().toMillis();
        if (!c$1.await(awaitMillis, TimeUnit.MILLISECONDS)) {
            ExtensionId extensionId = ext$1;
            SerializationExtension$ serializationExtension$ = SerializationExtension$.MODULE$;
            throw new IllegalStateException(new StringBuilder(43).append("Initialization of [").append(ext$1).append("] took more than [").append(awaitMillis).append(" ms]. ").append(!(extensionId != null ? !((Object)extensionId).equals(serializationExtension$) : serializationExtension$ != null) ? "A serializer must not access the SerializationExtension from its constructor. Use lazy init." : "Could be deadlock due to cyclic initialization of extensions.").toString());
        }
    }

    private final void loadExtensions$1(String key, boolean throwOnLoadFail) {
        Util$.MODULE$.immutableSeq(this.settings().config().getStringList(key)).foreach((Function1 & Serializable)fqcn -> {
            Extension extension;
            Try try_ = this.dynamicAccess().getObjectFor((String)fqcn, ClassTag$.MODULE$.apply(Object.class)).recoverWith((PartialFunction)new Serializable((String)fqcn, this){
                private final String fqcn$1;
                private final ActorSystemImpl $outer;
                {
                    this.fqcn$1 = fqcn$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable firstProblem = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable firstProblem = throwable = x;
                    return this.$outer.dynamicAccess().createInstanceFor(this.fqcn$1, (Seq<Tuple2<Class<?>, Object>>)scala.package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(Object.class)).recoverWith((PartialFunction)new Serializable(firstProblem){
                        private final Throwable firstProblem$1;
                        {
                            this.firstProblem$1 = firstProblem$2;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable = x;
                            return true;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable = x;
                            return Failure$.MODULE$.apply(this.firstProblem$1);
                        }
                    });
                }
            });
            if (try_ instanceof Success) {
                Object object = ((Success)try_).value();
                if (object instanceof ExtensionIdProvider) {
                    ExtensionIdProvider p = (ExtensionIdProvider)object;
                    extension = this.registerExtension(p.lookup());
                    return extension;
                } else if (object instanceof ExtensionId) {
                    ExtensionId p = (ExtensionId)object;
                    extension = this.registerExtension(p);
                    return extension;
                } else {
                    if (throwOnLoadFail) throw new RuntimeException(new StringBuilder(51).append("[").append((String)fqcn).append("] is not an 'ExtensionIdProvider' or 'ExtensionId'").toString());
                    this.log().error("[{}] is not an 'ExtensionIdProvider' or 'ExtensionId', skipping...", fqcn);
                    extension = BoxedUnit.UNIT;
                }
                return extension;
            } else {
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Throwable problem = ((Failure)try_).exception();
                if (throwOnLoadFail) throw new RuntimeException(new StringBuilder(33).append("While trying to load extension [").append((String)fqcn).append("]").toString(), problem);
                this.log().error(problem, "While trying to load extension [{}], skipping...", fqcn);
                extension = BoxedUnit.UNIT;
            }
            return extension;
        });
    }

    private static final String printNode$1(ActorRef node, String indent) {
        String string;
        ActorRef actorRef = node;
        if (actorRef instanceof ActorRefWithCell) {
            String string2;
            String string3;
            ActorCell real;
            Actor realActor;
            Cell cell;
            ActorRefWithCell wc = (ActorRefWithCell)actorRef;
            Cell cell2 = wc.underlying();
            StringBuilder stringBuilder = new StringBuilder(3).append(indent.isEmpty() ? "-> " : new StringBuilder(4).append(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(indent), 1)).append("\u230a-> ").toString()).append(node.path().name()).append(" ").append(Logging$.MODULE$.simpleName(node)).append(" ").append((cell = cell2) instanceof ActorCell ? ((realActor = (real = (ActorCell)cell).actor()) != null ? realActor.getClass() : "null") : Logging$.MODULE$.simpleName(cell2));
            Cell cell3 = cell2;
            if (cell3 instanceof ActorCell) {
                ActorCell real2 = (ActorCell)cell3;
                string3 = new StringBuilder(8).append(" status=").append(real2.mailbox().currentStatus()).toString();
            } else {
                string3 = "";
            }
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" ");
            ChildrenContainer childrenContainer = cell2.childrenRefs();
            if (childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer) {
                ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer = ChildrenContainer$TerminatingChildrenContainer$.MODULE$.unapply((ChildrenContainer.TerminatingChildrenContainer)childrenContainer);
                TreeMap<String, ChildStats> treeMap = terminatingChildrenContainer._1();
                Set<ActorRef> set = terminatingChildrenContainer._2();
                ChildrenContainer.SuspendReason suspendReason = terminatingChildrenContainer._3();
                Set<ActorRef> toDie = set;
                ChildrenContainer.SuspendReason reason = suspendReason;
                string2 = new StringBuilder(13).append("Terminating(").append(reason).append(")").append(((IterableOnceOps)toDie.toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).mkString(new StringBuilder(16).append("\n").append(indent).append("   |    toDie: ").toString(), new StringBuilder(16).append("\n").append(indent).append("   |           ").toString(), "")).toString();
            } else if (ChildrenContainer$TerminatedChildrenContainer$.MODULE$.equals(childrenContainer) || ChildrenContainer$EmptyChildrenContainer$.MODULE$.equals(childrenContainer)) {
                ChildrenContainer.EmptyChildrenContainer x = (ChildrenContainer.EmptyChildrenContainer)childrenContainer;
                string2 = x.toString();
            } else if (childrenContainer instanceof ChildrenContainer.NormalChildrenContainer) {
                ChildrenContainer.NormalChildrenContainer n = (ChildrenContainer.NormalChildrenContainer)childrenContainer;
                string2 = new StringBuilder(9).append(BoxesRunTime.boxToInteger((int)n.c().size()).toString()).append(" children").toString();
            } else {
                ChildrenContainer x = childrenContainer;
                string2 = Logging$.MODULE$.simpleName(x);
            }
            Seq children = (Seq)cell2.childrenRefs().children().toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            Seq bulk = (Seq)((IterableOps)children.dropRight(1)).map((Function1 & Serializable)_$7 -> ActorSystemImpl.printNode$1(_$7, new StringBuilder(4).append(indent).append("   |").toString()));
            string = stringBuilder2.append(string2).append(cell2.childrenRefs().children().isEmpty() ? "" : "\n").append(((IterableOnceOps)bulk.$plus$plus((IterableOnce)children.lastOption().map((Function1 & Serializable)_$8 -> ActorSystemImpl.printNode$1(_$8, new StringBuilder(4).append(indent).append("    ").toString())))).mkString("\n")).toString();
        } else {
            string = new StringBuilder(1).append(indent).append(node.path().name()).append(" ").append(Logging$.MODULE$.simpleName(node)).toString();
        }
        return string;
    }

    public final class TerminationCallbacks<T> {
        private final ExecutionContext ec;
        private final Promise<T> done;
        private final AtomicReference<Promise<T>> ref;
        private final ActorSystemImpl $outer;

        public TerminationCallbacks(ActorSystemImpl $outer, Future<T> upStreamTerminated, ExecutionContext ec) {
            this.ec = ec;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.done = Promise$.MODULE$.apply();
            this.ref = new AtomicReference<Promise<T>>(this.done);
            upStreamTerminated.onComplete((Function1 & Serializable)t -> ((Promise)this.ref.getAndSet(null)).complete(t), ec);
        }

        public final void add(Runnable r) {
            this.addRec$1(r, Promise$.MODULE$.apply());
        }

        public Future<T> terminationFuture() {
            return this.done.future();
        }

        public final ActorSystemImpl akka$actor$ActorSystemImpl$TerminationCallbacks$$$outer() {
            return this.$outer;
        }

        private final void addRec$1(Runnable r, Promise p) {
            Promise<T> promise;
            Promise<T> some;
            do {
                if ((promise = this.ref.get()) != null) continue;
                throw new RejectedExecutionException("ActorSystem already terminated.");
            } while (!this.ref.compareAndSet(some = promise, p));
            some.completeWith(p.future().andThen((PartialFunction)new Serializable(r){
                private final Runnable r$1;
                {
                    this.r$1 = r$2;
                }

                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    return true;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Try try_ = x;
                    this.r$1.run();
                    return BoxedUnit.UNIT;
                }
            }, this.ec));
        }
    }
}

