/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorCell$;
import akka.actor.ActorPath;
import akka.actor.Address;
import akka.actor.IgnoreActorRef$;
import akka.actor.RootActorPath;
import akka.routing.MurmurHash$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ChildActorPath
implements ActorPath {
    private static final long serialVersionUID = 1L;
    private final ActorPath parent;
    private final String name;
    private final int uid;
    private final int toStringOffset;

    public ChildActorPath(ActorPath parent, String name, int uid) {
        int n;
        this.parent = parent;
        this.name = name;
        this.uid = uid;
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("/ is a path separator and is not legal in ActorPath names: [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        if (name.indexOf(35) != -1) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("# is a fragment separator and is not legal in ActorPath names: [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        ActorPath actorPath = parent;
        if (actorPath instanceof RootActorPath) {
            RootActorPath r = (RootActorPath)actorPath;
            n = r.address().toString().length() + r.name().length();
        } else if (actorPath instanceof ChildActorPath) {
            ChildActorPath c = (ChildActorPath)actorPath;
            n = c.toStringLength() + 1;
        } else {
            throw new MatchError((Object)actorPath);
        }
        this.toStringOffset = n;
    }

    @Override
    public ActorPath parent() {
        return this.parent;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int uid() {
        return this.uid;
    }

    @Override
    public Address address() {
        return this.root().address();
    }

    @Override
    public ActorPath $div(String child) {
        Tuple2<String, Object> tuple2 = ActorCell$.MODULE$.splitNameAndUid(child);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String childName = (String)tuple2._1();
        int uid = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)childName, (Object)BoxesRunTime.boxToInteger((int)uid));
        String childName2 = (String)tuple22._1();
        int uid2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        return new ChildActorPath(this, childName2, uid2);
    }

    @Override
    public Iterable<String> elements() {
        return ChildActorPath.rec$1(this, (List)package$.MODULE$.Nil());
    }

    @Override
    public RootActorPath root() {
        return ChildActorPath.rec$2(this);
    }

    @Override
    public ActorPath withUid(int uid) {
        return uid == this.uid() ? this : new ChildActorPath(this.parent(), this.name(), uid);
    }

    public String toString() {
        int length = this.toStringLength();
        return this.buildToString(new StringBuilder(length), length, 0, (Function1<RootActorPath, String>)(Function1 & Serializable)_$1 -> _$1.toString()).toString();
    }

    @Override
    public String toSerializationFormat() {
        int length = this.toStringLength();
        StringBuilder sb = this.buildToString(new StringBuilder(length + 12), length, 0, (Function1<RootActorPath, String>)(Function1 & Serializable)_$2 -> _$2.toString());
        return this.appendUidFragment(sb).toString();
    }

    private int toStringLength() {
        return this.toStringOffset() + this.name().length();
    }

    private int toStringOffset() {
        return this.toStringOffset;
    }

    @Override
    public String toStringWithAddress(Address addr) {
        String string;
        if (IgnoreActorRef$.MODULE$.isIgnoreRefPath(this)) {
            string = this.toString();
        } else {
            int diff = this.addressStringLengthDiff(addr);
            int length = this.toStringLength() + diff;
            string = this.buildToString(new StringBuilder(length), length, diff, (Function1<RootActorPath, String>)(Function1 & Serializable)_$3 -> _$3.toStringWithAddress(addr)).toString();
        }
        return string;
    }

    @Override
    public String toSerializationFormatWithAddress(Address addr) {
        String string;
        if (IgnoreActorRef$.MODULE$.isIgnoreRefPath(this)) {
            string = this.toString();
        } else {
            int diff = this.addressStringLengthDiff(addr);
            int length = this.toStringLength() + diff;
            StringBuilder sb = this.buildToString(new StringBuilder(length + 12), length, diff, (Function1<RootActorPath, String>)(Function1 & Serializable)_$4 -> _$4.toStringWithAddress(addr));
            string = this.appendUidFragment(sb).toString();
        }
        return string;
    }

    private int addressStringLengthDiff(Address address) {
        RootActorPath r = this.root();
        return r.address().host().isDefined() ? 0 : address.toString().length() - r.address().toString().length();
    }

    private StringBuilder buildToString(StringBuilder sb, int length, int diff, Function1<RootActorPath, String> rootString) {
        sb.setLength(length);
        return this.rec$3(sb, diff, rootString, this);
    }

    private StringBuilder appendUidFragment(StringBuilder sb) {
        return this.uid() == 0 ? sb : sb.append("#").append(this.uid());
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof ActorPath) {
            ActorPath p = (ActorPath)object;
            bl = ChildActorPath.rec$4(this, p);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return MurmurHash$.MODULE$.finalizeHash(this.rec$5(this, MurmurHash$.MODULE$.startHash(42), MurmurHash$.MODULE$.startMagicA(), MurmurHash$.MODULE$.startMagicB()));
    }

    @Override
    public int compareTo(ActorPath other) {
        return ChildActorPath.rec$6(this, other);
    }

    private static final Iterable rec$1(ActorPath p, List acc) {
        ActorPath actorPath;
        List list = acc;
        ActorPath actorPath2 = p;
        while (!((actorPath = actorPath2) instanceof RootActorPath)) {
            ActorPath actorPath3 = actorPath2.parent();
            String string = actorPath2.name();
            List list2 = list.$colon$colon((Object)string);
            actorPath2 = actorPath3;
            list = list2;
        }
        return list;
    }

    private static final RootActorPath rec$2(ActorPath p) {
        ActorPath actorPath;
        ActorPath actorPath2 = p;
        while (true) {
            if ((actorPath = actorPath2) instanceof RootActorPath) break;
            actorPath2 = actorPath2.parent();
        }
        RootActorPath r = (RootActorPath)actorPath;
        return r;
    }

    private final StringBuilder rec$3(StringBuilder sb$1, int diff$1, Function1 rootString$1, ActorPath p) {
        ActorPath actorPath;
        block2: {
            ActorPath actorPath2 = p;
            while (true) {
                if ((actorPath = actorPath2) instanceof RootActorPath) break block2;
                if (!(actorPath instanceof ChildActorPath)) break;
                ChildActorPath c = (ChildActorPath)actorPath;
                int start = c.toStringOffset() + diff$1;
                int end = start + c.name().length();
                sb$1.replace(start, end, c.name());
                if (c != this) {
                    sb$1.replace(end, end + 1, "/");
                }
                actorPath2 = c.parent();
            }
            throw new MatchError((Object)actorPath);
        }
        RootActorPath r = (RootActorPath)actorPath;
        String rootStr = (String)rootString$1.apply((Object)r);
        return sb$1.replace(0, rootStr.length(), rootStr);
    }

    private static final boolean rec$4(ActorPath left, ActorPath right) {
        boolean bl;
        block4: {
            ActorPath actorPath = right;
            ActorPath actorPath2 = left;
            while (true) {
                if (actorPath2 == actorPath) {
                    bl = true;
                    break block4;
                }
                if (actorPath2 instanceof RootActorPath) {
                    bl = actorPath2.equals(actorPath);
                    break block4;
                }
                if (actorPath instanceof RootActorPath) {
                    bl = actorPath.equals(actorPath2);
                    break block4;
                }
                String string = actorPath2.name();
                String string2 = actorPath.name();
                if (string != null ? !string.equals(string2) : string2 != null) break;
                ActorPath actorPath3 = actorPath2.parent();
                ActorPath actorPath4 = actorPath.parent();
                actorPath2 = actorPath3;
                actorPath = actorPath4;
            }
            bl = false;
        }
        return bl;
    }

    private final int rec$5(ActorPath p, int h, int c, int k) {
        ActorPath actorPath;
        int n = k;
        int n2 = c;
        int n3 = h;
        ActorPath actorPath2 = p;
        while (true) {
            if ((actorPath = actorPath2) instanceof RootActorPath) break;
            ActorPath actorPath3 = actorPath2.parent();
            int n4 = MurmurHash$.MODULE$.extendHash(n3, MurmurHash$.MODULE$.stringHash(this.name()), n2, n);
            int n5 = MurmurHash$.MODULE$.nextMagicA(n2);
            int n6 = MurmurHash$.MODULE$.nextMagicB(n);
            actorPath2 = actorPath3;
            n3 = n4;
            n2 = n5;
            n = n6;
        }
        RootActorPath r = (RootActorPath)actorPath;
        return MurmurHash$.MODULE$.extendHash(n3, Statics.anyHash((Object)r), n2, n);
    }

    private static final int rec$6(ActorPath left, ActorPath right) {
        int n;
        block4: {
            int x;
            ActorPath actorPath = right;
            ActorPath actorPath2 = left;
            while (true) {
                if (actorPath2 == actorPath) {
                    n = 0;
                    break block4;
                }
                if (actorPath2 instanceof RootActorPath) {
                    n = actorPath2.compareTo(actorPath);
                    break block4;
                }
                if (actorPath instanceof RootActorPath) {
                    n = -actorPath.compareTo(actorPath2);
                    break block4;
                }
                x = actorPath2.name().compareTo(actorPath.name());
                if (x != 0) break;
                ActorPath actorPath3 = actorPath2.parent();
                ActorPath actorPath4 = actorPath.parent();
                actorPath2 = actorPath3;
                actorPath = actorPath4;
            }
            n = x;
        }
        return n;
    }
}

