/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.Done;
import akka.Done$;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$ActorSystemTerminateReason$;
import akka.actor.CoordinatedShutdown$ClusterDowningReason$;
import akka.actor.CoordinatedShutdown$ClusterJoinUnsuccessfulReason$;
import akka.actor.CoordinatedShutdown$ClusterLeavingReason$;
import akka.actor.CoordinatedShutdown$IncompatibleConfigurationDetectedReason$;
import akka.actor.CoordinatedShutdown$JvmExitReason$;
import akka.actor.CoordinatedShutdown$Phase$;
import akka.actor.CoordinatedShutdown$UnknownReason$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.actor.ExtensionIdProvider;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts$;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class CoordinatedShutdown$
implements ExtensionId<CoordinatedShutdown>,
ExtensionIdProvider {
    private static final String PhaseBeforeServiceUnbind;
    private static final String PhaseServiceUnbind;
    private static final String PhaseServiceRequestsDone;
    private static final String PhaseServiceStop;
    private static final String PhaseBeforeClusterShutdown;
    private static final String PhaseClusterShardingShutdownRegion;
    private static final String PhaseClusterLeave;
    private static final String PhaseClusterExiting;
    private static final String PhaseClusterExitingDone;
    private static final String PhaseClusterShutdown;
    private static final String PhaseBeforeActorSystemTerminate;
    private static final String PhaseActorSystemTerminate;
    public static final CoordinatedShutdown$UnknownReason$ UnknownReason;
    public static final CoordinatedShutdown$ActorSystemTerminateReason$ ActorSystemTerminateReason;
    public static final CoordinatedShutdown$JvmExitReason$ JvmExitReason;
    public static final CoordinatedShutdown$ClusterDowningReason$ ClusterDowningReason;
    public static final CoordinatedShutdown$ClusterJoinUnsuccessfulReason$ ClusterJoinUnsuccessfulReason;
    public static final CoordinatedShutdown$IncompatibleConfigurationDetectedReason$ IncompatibleConfigurationDetectedReason;
    public static final CoordinatedShutdown$ClusterLeavingReason$ ClusterLeavingReason;
    public static volatile boolean akka$actor$CoordinatedShutdown$$$runningJvmHook;
    public static final CoordinatedShutdown$Phase$ Phase;
    public static final CoordinatedShutdown$ MODULE$;

    private CoordinatedShutdown$() {
    }

    static {
        MODULE$ = new CoordinatedShutdown$();
        PhaseBeforeServiceUnbind = "before-service-unbind";
        PhaseServiceUnbind = "service-unbind";
        PhaseServiceRequestsDone = "service-requests-done";
        PhaseServiceStop = "service-stop";
        PhaseBeforeClusterShutdown = "before-cluster-shutdown";
        PhaseClusterShardingShutdownRegion = "cluster-sharding-shutdown-region";
        PhaseClusterLeave = "cluster-leave";
        PhaseClusterExiting = "cluster-exiting";
        PhaseClusterExitingDone = "cluster-exiting-done";
        PhaseClusterShutdown = "cluster-shutdown";
        PhaseBeforeActorSystemTerminate = "before-actor-system-terminate";
        PhaseActorSystemTerminate = "actor-system-terminate";
        akka$actor$CoordinatedShutdown$$$runningJvmHook = false;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CoordinatedShutdown$.class);
    }

    public String PhaseBeforeServiceUnbind() {
        return PhaseBeforeServiceUnbind;
    }

    public String PhaseServiceUnbind() {
        return PhaseServiceUnbind;
    }

    public String PhaseServiceRequestsDone() {
        return PhaseServiceRequestsDone;
    }

    public String PhaseServiceStop() {
        return PhaseServiceStop;
    }

    public String PhaseBeforeClusterShutdown() {
        return PhaseBeforeClusterShutdown;
    }

    public String PhaseClusterShardingShutdownRegion() {
        return PhaseClusterShardingShutdownRegion;
    }

    public String PhaseClusterLeave() {
        return PhaseClusterLeave;
    }

    public String PhaseClusterExiting() {
        return PhaseClusterExiting;
    }

    public String PhaseClusterExitingDone() {
        return PhaseClusterExitingDone;
    }

    public String PhaseClusterShutdown() {
        return PhaseClusterShutdown;
    }

    public String PhaseBeforeActorSystemTerminate() {
        return PhaseBeforeActorSystemTerminate;
    }

    public String PhaseActorSystemTerminate() {
        return PhaseActorSystemTerminate;
    }

    public CoordinatedShutdown.Reason unknownReason() {
        return CoordinatedShutdown$UnknownReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason actorSystemTerminateReason() {
        return CoordinatedShutdown$ActorSystemTerminateReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason jvmExitReason() {
        return CoordinatedShutdown$JvmExitReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterDowningReason() {
        return CoordinatedShutdown$ClusterDowningReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterJoinUnsuccessfulReason() {
        return CoordinatedShutdown$ClusterJoinUnsuccessfulReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason incompatibleConfigurationDetectedReason() {
        return CoordinatedShutdown$IncompatibleConfigurationDetectedReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterLeavingReason() {
        return CoordinatedShutdown$ClusterLeavingReason$.MODULE$;
    }

    @Override
    public CoordinatedShutdown get(ActorSystem system) {
        return (CoordinatedShutdown)ExtensionId.get$((ExtensionId)this, system);
    }

    @Override
    public CoordinatedShutdown get(ClassicActorSystemProvider system) {
        return (CoordinatedShutdown)ExtensionId.get$((ExtensionId)this, system);
    }

    @Override
    public ExtensionId<? extends Extension> lookup() {
        return this;
    }

    @Override
    public CoordinatedShutdown createExtension(ExtendedActorSystem system) {
        Config conf = system.settings().config().getConfig("akka.coordinated-shutdown");
        scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phases = this.phasesFromConfig(conf);
        CoordinatedShutdown coord = new CoordinatedShutdown(system, phases);
        this.initPhaseActorSystemTerminate(system, conf, coord);
        this.initJvmHook(system, conf, coord);
        try {
            system.registerOnTermination(() -> this.createExtension$$anonfun$1(coord));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.cleanupActorSystemJvmHook$1(coord);
        }
        return coord;
    }

    @InternalApi
    public Config confWithOverrides(Config conf, Option<CoordinatedShutdown.Reason> reason) {
        return (Config)reason.flatMap((Function1 & Serializable)r -> {
            String basePath = new StringBuilder(19).append("reason-overrides.\"").append(r.getClass().getName()).append("\"").toString();
            return conf.hasPath(basePath) ? Some$.MODULE$.apply((Object)conf.getConfig(basePath).withFallback((ConfigMergeable)conf)) : None$.MODULE$;
        }).getOrElse(() -> this.confWithOverrides$$anonfun$2(conf));
    }

    private void initPhaseActorSystemTerminate(ExtendedActorSystem system, Config conf, CoordinatedShutdown coord) {
        coord.addTask(this.PhaseActorSystemTerminate(), "terminate-system", (Function0<Future<Done>>)(Function0 & Serializable)() -> {
            Future future;
            Config confForReason = this.confWithOverrides(conf, coord.shutdownReason());
            boolean terminateActorSystem = confForReason.getBoolean("terminate-actor-system");
            boolean exitJvm = confForReason.getBoolean("exit-jvm");
            int exitCode = confForReason.getInt("exit-code");
            if (exitJvm && terminateActorSystem) {
                FiniteDuration timeout = coord.timeout(this.PhaseActorSystemTerminate());
                Thread t = new Thread(system, exitCode, timeout){
                    private final ExtendedActorSystem system$2;
                    private final int exitCode$1;
                    private final FiniteDuration timeout$3;
                    {
                        this.system$2 = system$4;
                        this.exitCode$1 = exitCode$3;
                        this.timeout$3 = timeout$4;
                    }

                    public void run() {
                        if (Try$.MODULE$.apply(this::run$$anonfun$3).isFailure() && !CoordinatedShutdown$.akka$actor$CoordinatedShutdown$$$runningJvmHook) {
                            System.exit(this.exitCode$1);
                        }
                    }

                    private final Future run$$anonfun$3() {
                        return (Future)Await$.MODULE$.ready(this.system$2.whenTerminated(), (Duration)this.timeout$3);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$3()}, serializedLambda);
                    }
                };
                t.setName("CoordinatedShutdown-exit");
                t.start();
            }
            if (terminateActorSystem) {
                system.finalTerminate();
                future = system.whenTerminated().map((Function1 & Serializable)_$1 -> {
                    if (exitJvm && !akka$actor$CoordinatedShutdown$$$runningJvmHook) {
                        System.exit(exitCode);
                    }
                    return Done$.MODULE$;
                }, ExecutionContexts$.MODULE$.parasitic());
            } else if (exitJvm) {
                System.exit(exitCode);
                future = Future$.MODULE$.successful((Object)Done$.MODULE$);
            } else {
                future = Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            return future;
        });
    }

    private void initJvmHook(ActorSystem system, Config conf, CoordinatedShutdown coord) {
        boolean runByJvmShutdownHook;
        boolean bl = runByJvmShutdownHook = system.settings().JvmShutdownHooks() && conf.getBoolean("run-by-jvm-shutdown-hook");
        if (runByJvmShutdownHook) {
            coord.akka$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq((Cancellable)OptionVal$Some$.MODULE$.apply(coord.addCancellableJvmShutdownHook(() -> this.initJvmHook$$anonfun$1(system, coord))));
        }
    }

    public scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phasesFromConfig(Config conf) {
        String defaultPhaseTimeout = conf.getString("default-phase-timeout");
        Config phasesConf = conf.getConfig("phases");
        Config defaultPhaseConfig = ConfigFactory.parseString((String)new StringBuilder(86).append("\n      timeout = ").append(defaultPhaseTimeout).append("\n      recover = true\n      enabled = true\n      depends-on = []\n    ").toString());
        return (scala.collection.immutable.Map)package$JavaConverters$.MODULE$.MapHasAsScala(phasesConf.root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
            String k;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                Object object = tuple2._2();
                k = string;
                if (!(object instanceof Map)) {
                    String k2 = string;
                    Object v = object;
                    throw new IllegalArgumentException(new StringBuilder(36).append("Expected object value for [").append(k2).append("], got [").append(v).append("]").toString());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Config c = phasesConf.getConfig(k).withFallback((ConfigMergeable)defaultPhaseConfig);
            Set dependsOn = package$JavaConverters$.MODULE$.ListHasAsScala(c.getStringList("depends-on")).asScala().toSet();
            FiniteDuration timeout = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(c.getDuration("timeout", TimeUnit.MILLISECONDS))).millis();
            boolean recover = c.getBoolean("recover");
            boolean enabled = c.getBoolean("enabled");
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)CoordinatedShutdown$Phase$.MODULE$.apply((Set<String>)dependsOn, timeout, recover, enabled));
        });
    }

    public List<String> topologicalSort(scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phases) {
        ObjectRef result = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef unmarked = ObjectRef.create((Object)((Set)phases.keySet().$plus$plus((IterableOnce)phases.values().flatMap((Function1 & Serializable)_$2 -> _$2.dependsOn()))));
        ObjectRef tempMark = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        while (((Set)unmarked.elem).nonEmpty()) {
            this.depthFirstSearch$1(phases, result, unmarked, tempMark, (String)((Set)unmarked.elem).head());
        }
        return ((List)result.elem).reverse();
    }

    private final void cleanupActorSystemJvmHook$1(CoordinatedShutdown coord$1) {
        block1: {
            Cancellable cancellable;
            Cancellable cancellable2 = coord$1.akka$actor$CoordinatedShutdown$$actorSystemJvmHook();
            Cancellable cancellable3 = (Cancellable)OptionVal$Some$.MODULE$.unapply(cancellable2);
            if (OptionVal$.MODULE$.isEmpty$extension(cancellable3)) break block1;
            Cancellable cancellable4 = cancellable = (Cancellable)OptionVal$.MODULE$.get$extension(cancellable3);
            if (!akka$actor$CoordinatedShutdown$$$runningJvmHook && !cancellable4.isCancelled()) {
                cancellable4.cancel();
                OptionVal$.MODULE$.None();
                coord$1.akka$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq(null);
            }
        }
    }

    private final void createExtension$$anonfun$1(CoordinatedShutdown coord$5) {
        this.cleanupActorSystemJvmHook$1(coord$5);
    }

    private final Config confWithOverrides$$anonfun$2(Config conf$2) {
        return conf$2;
    }

    private final void liftedTree3$1(CoordinatedShutdown coord$4) {
        try {
            FiniteDuration totalTimeout = coord$4.totalTimeout().max(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds());
            Await$.MODULE$.ready(coord$4.run(CoordinatedShutdown$JvmExitReason$.MODULE$), (Duration)totalTimeout);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                coord$4.log().warning("CoordinatedShutdown from JVM shutdown failed: {}", e.getMessage());
            }
            throw throwable;
        }
    }

    private final void initJvmHook$$anonfun$1(ActorSystem system$3, CoordinatedShutdown coord$3) {
        akka$actor$CoordinatedShutdown$$$runningJvmHook = true;
        if (!system$3.whenTerminated().isCompleted()) {
            coord$3.log().debug("Starting coordinated shutdown from JVM shutdown hook");
            this.liftedTree3$1(coord$3);
        }
    }

    private final void depthFirstSearch$1(scala.collection.immutable.Map phases$1, ObjectRef result$3, ObjectRef unmarked$1, ObjectRef tempMark$1, String u2) {
        if (((Set)tempMark$1.elem).apply((Object)u2)) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Cycle detected in graph of phases. It must be a DAG. ").append(new StringBuilder(59).append("phase [").append(u2).append("] depends transitively on itself. All dependencies: ").append(phases$1).toString()).toString());
        }
        if (((Set)unmarked$1.elem).apply((Object)u2)) {
            Set set = (Set)((Set)tempMark$1.elem).$plus((Object)u2);
            tempMark$1.elem = set;
            Option option = phases$1.get((Object)u2);
            if (option instanceof Some) {
                CoordinatedShutdown.Phase p = (CoordinatedShutdown.Phase)((Some)option).value();
                p.dependsOn().foreach((Function1)(JProcedure1 & Serializable)u -> this.depthFirstSearch$1(phases$1, result$3, unmarked$1, tempMark$1, (String)u));
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
            Set set2 = (Set)((Set)unmarked$1.elem).$minus((Object)u2);
            unmarked$1.elem = set2;
            Set set3 = (Set)((Set)tempMark$1.elem).$minus((Object)u2);
            tempMark$1.elem = set3;
            List list = ((List)result$3.elem).$colon$colon((Object)u2);
            result$3.elem = list;
        }
    }
}

