/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.AbstractActorRef;
import akka.actor.Actor$;
import akka.actor.ActorCell;
import akka.actor.ActorCell$;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorRefWithCell;
import akka.actor.ActorSystemImpl;
import akka.actor.Cell;
import akka.actor.ChildRestartStats;
import akka.actor.ChildStats;
import akka.actor.InternalActorRef;
import akka.actor.Nobody$;
import akka.actor.Props;
import akka.actor.RepointableRef;
import akka.actor.SerializedActorRef$;
import akka.actor.UnstartedCell;
import akka.dispatch.MailboxType;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.sysmsg.Supervise$;
import akka.dispatch.sysmsg.SystemMessage;
import akka.util.Unsafe;
import java.io.ObjectStreamException;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public class RepointableActorRef
extends ActorRefWithCell
implements RepointableRef {
    private final ActorSystemImpl system;
    private final Props props;
    private final MessageDispatcher dispatcher;
    private final MailboxType mailboxType;
    private final InternalActorRef supervisor;
    private final ActorPath path;
    private volatile Cell _cellDoNotCallMeDirectly;
    private volatile Cell _lookupDoNotCallMeDirectly;

    public RepointableActorRef(ActorSystemImpl system, Props props, MessageDispatcher dispatcher, MailboxType mailboxType, InternalActorRef supervisor, ActorPath path) {
        this.system = system;
        this.props = props;
        this.dispatcher = dispatcher;
        this.mailboxType = mailboxType;
        this.supervisor = supervisor;
        this.path = path;
    }

    public ActorSystemImpl system() {
        return this.system;
    }

    public Props props() {
        return this.props;
    }

    public MessageDispatcher dispatcher() {
        return this.dispatcher;
    }

    public MailboxType mailboxType() {
        return this.mailboxType;
    }

    public InternalActorRef supervisor() {
        return this.supervisor;
    }

    @Override
    public ActorPath path() {
        return this.path;
    }

    private Cell _preventPrivateUnusedErasure() {
        return this._lookupDoNotCallMeDirectly;
    }

    @Override
    public Cell underlying() {
        return (Cell)Unsafe.instance.getObjectVolatile(this, AbstractActorRef.cellOffset);
    }

    public Cell lookup() {
        return (Cell)Unsafe.instance.getObjectVolatile(this, AbstractActorRef.lookupOffset);
    }

    public final Cell swapCell(Cell next) {
        Cell old;
        RepointableActorRef repointableActorRef = this;
        while (!Unsafe.instance.compareAndSwapObject(repointableActorRef, AbstractActorRef.cellOffset, old = repointableActorRef.underlying(), next)) {
        }
        return old;
    }

    public final Cell swapLookup(Cell next) {
        Cell old;
        RepointableActorRef repointableActorRef = this;
        while (!Unsafe.instance.compareAndSwapObject(repointableActorRef, AbstractActorRef.lookupOffset, old = repointableActorRef.lookup(), next)) {
        }
        return old;
    }

    public RepointableActorRef initialize(boolean async) {
        Cell cell = this.underlying();
        if (cell == null) {
            this.swapCell(new UnstartedCell(this.system(), this, this.props(), this.supervisor()));
            this.swapLookup(this.underlying());
            this.supervisor().sendSystemMessage(Supervise$.MODULE$.apply(this, async));
            if (!async) {
                this.point(false);
            }
        } else {
            throw new IllegalStateException("initialize called more than once!");
        }
        return this;
    }

    public RepointableActorRef point(boolean catchFailures) {
        RepointableActorRef repointableActorRef;
        Cell cell = this.underlying();
        if (cell instanceof UnstartedCell) {
            Cell cell2;
            UnstartedCell u = (UnstartedCell)cell;
            try {
                cell2 = this.newCell(u);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    if (catchFailures) {
                        MessageDispatcher safeDispatcher = this.system().dispatchers().defaultGlobalDispatcher();
                        cell2 = new ActorCell(this.system(), this, this.props(), safeDispatcher, this.supervisor()).initWithFailure(ex);
                    }
                }
                throw throwable;
            }
            Cell cell3 = cell2;
            this.swapLookup(cell3);
            cell3.start();
            u.replaceWith(cell3);
            repointableActorRef = this;
        } else {
            if (cell == null) {
                throw new IllegalStateException("underlying cell is null");
            }
            repointableActorRef = this;
        }
        return repointableActorRef;
    }

    public Cell newCell(UnstartedCell old) {
        return new ActorCell(this.system(), this, this.props(), this.dispatcher(), this.supervisor()).init(false, this.mailboxType());
    }

    @Override
    public void start() {
    }

    @Override
    public void suspend() {
        this.underlying().suspend();
    }

    @Override
    public void resume(Throwable causedByFailure) {
        this.underlying().resume(causedByFailure);
    }

    @Override
    public void stop() {
        this.underlying().stop();
    }

    @Override
    public void restart(Throwable cause) {
        this.underlying().restart(cause);
    }

    @Override
    public boolean isStarted() {
        boolean bl;
        Cell cell = this.underlying();
        if (cell instanceof UnstartedCell) {
            bl = false;
        } else {
            if (cell == null) {
                throw new IllegalStateException("isStarted called before initialized");
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isTerminated() {
        return this.underlying().isTerminated();
    }

    @Override
    public ActorRefProvider provider() {
        return this.system().provider();
    }

    @Override
    public boolean isLocal() {
        return this.underlying().isLocal();
    }

    @Override
    public InternalActorRef getParent() {
        return this.underlying().parent();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InternalActorRef getChild(Iterator<String> name) {
        Cell cell;
        ChildStats childStats;
        InternalActorRef internalActorRef;
        if (!name.hasNext()) {
            internalActorRef = this;
            return internalActorRef;
        }
        String string = (String)name.next();
        if ("..".equals(string)) {
            internalActorRef = this.getParent().getChild(name);
            return internalActorRef;
        }
        if ("".equals(string)) {
            internalActorRef = this.getChild(name);
            return internalActorRef;
        }
        String other = string;
        Tuple2<String, Object> tuple2 = ActorCell$.MODULE$.splitNameAndUid(other);
        if (tuple2 == null) throw new MatchError(tuple2);
        String childName = (String)tuple2._1();
        int uid = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)childName, (Object)BoxesRunTime.boxToInteger((int)uid));
        String childName2 = (String)tuple22._1();
        int uid2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        Option<ChildStats> option = this.lookup().getChildByName(childName2);
        if (option instanceof Some && (childStats = (ChildStats)((Some)option).value()) instanceof ChildRestartStats) {
            ChildRestartStats crs = (ChildRestartStats)childStats;
            if (uid2 == 0 || uid2 == crs.uid()) {
                internalActorRef = ((InternalActorRef)crs.child()).getChild(name);
                return internalActorRef;
            }
        }
        if ((cell = this.lookup()) instanceof ActorCell) {
            ActorCell ac = (ActorCell)cell;
            internalActorRef = ac.getFunctionRefOrNobody(childName2, uid2);
            return internalActorRef;
        }
        internalActorRef = Nobody$.MODULE$;
        return internalActorRef;
    }

    @Override
    public InternalActorRef getSingleChild(String name) {
        return this.lookup().getSingleChild(name);
    }

    @Override
    public Iterable<ActorRef> children() {
        return this.lookup().childrenRefs().children();
    }

    @Override
    public void $bang(Object message, ActorRef sender) {
        this.underlying().sendMessage(message, sender);
    }

    @Override
    public ActorRef $bang$default$2(Object message) {
        return Actor$.MODULE$.noSender();
    }

    @Override
    public void sendSystemMessage(SystemMessage message) {
        this.underlying().sendSystemMessage(message);
    }

    public Object writeReplace() throws ObjectStreamException {
        return SerializedActorRef$.MODULE$.apply(this);
    }
}

