/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorCell;
import akka.actor.ActorContext;
import akka.actor.ActorInitializationException$;
import akka.actor.ActorRef;
import akka.actor.StashOverflowException;
import akka.actor.StashOverflowException$;
import akka.actor.Terminated;
import akka.actor.Terminated$;
import akka.annotation.InternalStableApi;
import akka.dispatch.DequeBasedMessageQueueSemantics;
import akka.dispatch.Envelope;
import akka.dispatch.MessageQueue;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;

public interface StashSupport {
    public static void $init$(StashSupport $this) {
        $this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)package$.MODULE$.Vector().empty());
        $this.akka$actor$StashSupport$_setter_$akka$actor$StashSupport$$capacity_$eq($this.context().system().mailboxes().stashCapacity($this.context().props().dispatcher(), $this.context().props().mailbox()));
        MessageQueue messageQueue = $this.actorCell().mailbox().messageQueue();
        if (!(messageQueue instanceof DequeBasedMessageQueueSemantics)) {
            MessageQueue other = messageQueue;
            throw ActorInitializationException$.MODULE$.apply($this.self(), new StringBuilder(34).append("DequeBasedMailbox required, got: ").append(other.getClass().getName()).append("\n").append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("An (unbounded) deque-based mailbox can be configured as follows:\n          |  my-custom-mailbox {\n          |    mailbox-type = \"akka.dispatch.UnboundedDequeBasedMailbox\"\n          |  }\n          |"))).toString(), ActorInitializationException$.MODULE$.apply$default$3());
        }
        DequeBasedMessageQueueSemantics queue = (DequeBasedMessageQueueSemantics)((Object)messageQueue);
        $this.akka$actor$StashSupport$_setter_$mailbox_$eq(queue);
    }

    public ActorContext context();

    public ActorRef self();

    public Vector<Envelope> akka$actor$StashSupport$$theStash();

    public void akka$actor$StashSupport$$theStash_$eq(Vector<Envelope> var1);

    private ActorCell actorCell() {
        return (ActorCell)this.context();
    }

    public int akka$actor$StashSupport$$capacity();

    public void akka$actor$StashSupport$_setter_$akka$actor$StashSupport$$capacity_$eq(int var1);

    public DequeBasedMessageQueueSemantics mailbox();

    public void akka$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics var1);

    public static void stash$(StashSupport $this) {
        $this.stash();
    }

    default public void stash() {
        Envelope currMsg = this.actorCell().currentMessage();
        if (this.akka$actor$StashSupport$$theStash().nonEmpty() && currMsg == this.akka$actor$StashSupport$$theStash().last()) {
            throw new IllegalStateException(new StringBuilder(44).append("Can't stash the same message ").append(currMsg).append(" more than once").toString());
        }
        if (this.akka$actor$StashSupport$$capacity() > 0 && this.akka$actor$StashSupport$$theStash().size() >= this.akka$actor$StashSupport$$capacity()) {
            throw new StashOverflowException(new StringBuilder(44).append("Couldn't enqueue message ").append(currMsg.message().getClass().getName()).append(" from ").append(currMsg.sender()).append(" to stash of ").append(this.self()).toString(), StashOverflowException$.MODULE$.$lessinit$greater$default$2());
        }
        this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)((Vector)this.akka$actor$StashSupport$$theStash().$colon$plus((Object)currMsg)));
    }

    public static void prepend$(StashSupport $this, Seq others) {
        $this.prepend((Seq<Envelope>)others);
    }

    default public void prepend(Seq<Envelope> others) {
        this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)((Vector)others.foldRight(this.akka$actor$StashSupport$$theStash(), (Function2 & Serializable)(e, s) -> (Vector)s.$plus$colon(e))));
    }

    public static void unstash$(StashSupport $this) {
        $this.unstash();
    }

    default public void unstash() {
        if (this.akka$actor$StashSupport$$theStash().nonEmpty()) {
            try {
                this.enqueueFirst((Envelope)this.akka$actor$StashSupport$$theStash().head());
            }
            finally {
                this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)this.akka$actor$StashSupport$$theStash().tail());
            }
        }
    }

    public static void unstashAll$(StashSupport $this) {
        $this.unstashAll();
    }

    default public void unstashAll() {
        this.unstashAll((Function1<Object, Object>)(Function1 & Serializable)_$1 -> true);
    }

    public static void unstashAll$(StashSupport $this, Function1 filterPredicate) {
        $this.unstashAll((Function1<Object, Object>)filterPredicate);
    }

    @InternalStableApi
    default public void unstashAll(Function1<Object, Object> filterPredicate) {
        try {
            Iterator i = this.akka$actor$StashSupport$$theStash().reverseIterator().filter((Function1 & Serializable)envelope -> BoxesRunTime.unboxToBoolean((Object)filterPredicate.apply(envelope.message())));
            while (i.hasNext()) {
                this.enqueueFirst((Envelope)i.next());
            }
        }
        finally {
            this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)package$.MODULE$.Vector().empty());
        }
    }

    public static Vector clearStash$(StashSupport $this) {
        return $this.clearStash();
    }

    /*
     * WARNING - void declaration
     */
    @InternalStableApi
    default public Vector<Envelope> clearStash() {
        void var1_1;
        Vector<Envelope> stashed = this.akka$actor$StashSupport$$theStash();
        this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)package$.MODULE$.Vector().empty());
        return var1_1;
    }

    private void enqueueFirst(Envelope envelope) {
        block0: {
            ActorRef actorRef;
            this.mailbox().enqueueFirst(this.self(), envelope);
            Object object = envelope.message();
            if (!(object instanceof Terminated)) break block0;
            Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
            ActorRef ref = actorRef = terminated._1();
            this.actorCell().terminatedQueuedFor(ref, (Option)None$.MODULE$);
        }
    }
}

