/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorSystem;
import akka.actor.ActorSystemImpl;
import akka.actor.Cell;
import akka.actor.ChildRestartStats;
import akka.actor.DeadLetter$;
import akka.actor.InternalActorRef;
import akka.actor.Nobody$;
import akka.actor.Props;
import akka.actor.RepointableActorRef;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.ChildrenContainer$EmptyChildrenContainer$;
import akka.dispatch.Envelope;
import akka.dispatch.sysmsg.EarliestFirstSystemMessageList$;
import akka.dispatch.sysmsg.LatestFirstSystemMessageList$;
import akka.dispatch.sysmsg.Recreate$;
import akka.dispatch.sysmsg.Resume$;
import akka.dispatch.sysmsg.Suspend$;
import akka.dispatch.sysmsg.SystemMessage;
import akka.dispatch.sysmsg.SystemMessageList$;
import akka.dispatch.sysmsg.Terminate$;
import akka.event.Logging$Warning$;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public class UnstartedCell
implements Cell {
    private final ActorSystemImpl systemImpl;
    private final RepointableActorRef self;
    private final Props props;
    private final InternalActorRef supervisor;
    private final ReentrantLock lock;
    private final LinkedList<Envelope> queue;
    private SystemMessage sysmsgQueue;

    public UnstartedCell(ActorSystemImpl systemImpl, RepointableActorRef self, Props props, InternalActorRef supervisor) {
        this.systemImpl = systemImpl;
        this.self = self;
        this.props = props;
        this.supervisor = supervisor;
        this.lock = new ReentrantLock();
        this.queue = new LinkedList();
        this.sysmsgQueue = SystemMessageList$.MODULE$.LNil();
    }

    @Override
    public ActorSystemImpl systemImpl() {
        return this.systemImpl;
    }

    @Override
    public RepointableActorRef self() {
        return this.self;
    }

    @Override
    public Props props() {
        return this.props;
    }

    public InternalActorRef supervisor() {
        return this.supervisor;
    }

    public void replaceWith(Cell cell) {
        this.locked((Function0)((JFunction0.mcV.sp & Serializable)() -> this.replaceWith$$anonfun$1(cell)));
    }

    @Override
    public ActorSystem system() {
        return this.systemImpl();
    }

    @Override
    public UnstartedCell start() {
        return this;
    }

    @Override
    public void suspend() {
        this.sendSystemMessage(Suspend$.MODULE$.apply());
    }

    @Override
    public void resume(Throwable causedByFailure) {
        this.sendSystemMessage(Resume$.MODULE$.apply(causedByFailure));
    }

    @Override
    public void restart(Throwable cause) {
        this.sendSystemMessage(Recreate$.MODULE$.apply(cause));
    }

    @Override
    public void stop() {
        this.sendSystemMessage(Terminate$.MODULE$.apply());
    }

    @Override
    public boolean isTerminated() {
        return BoxesRunTime.unboxToBoolean(this.locked(this::isTerminated$$anonfun$1));
    }

    @Override
    public InternalActorRef parent() {
        return this.supervisor();
    }

    @Override
    public ChildrenContainer childrenRefs() {
        return ChildrenContainer$EmptyChildrenContainer$.MODULE$;
    }

    public Option<ChildRestartStats> getChildByName(String name) {
        return None$.MODULE$;
    }

    @Override
    public InternalActorRef getSingleChild(String name) {
        return Nobody$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendMessage(Envelope msg) {
        if (this.lock.tryLock(this.systemImpl().settings().UnstartedPushTimeout().duration().length(), this.systemImpl().settings().UnstartedPushTimeout().duration().unit())) {
            try {
                Cell cell = this.self().underlying();
                if (this.cellIsReady(cell)) {
                    cell.sendMessage(msg);
                    return;
                }
                if (this.queue.offer(msg)) return;
                this.system().eventStream().publish(Logging$Warning$.MODULE$.apply(this.self().path().toString(), this.getClass(), new StringBuilder(48).append("dropping message of type ").append(msg.message().getClass()).append(" due to enqueue failure").toString()));
                this.system().deadLetters().tell(DeadLetter$.MODULE$.apply(msg.message(), msg.sender(), this.self()), msg.sender());
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.system().eventStream().publish(Logging$Warning$.MODULE$.apply(this.self().path().toString(), this.getClass(), new StringBuilder(44).append("dropping message of type").append(msg.message().getClass()).append(" due to lock timeout").toString()));
            this.system().deadLetters().tell(DeadLetter$.MODULE$.apply(msg.message(), msg.sender(), this.self()), msg.sender());
        }
    }

    @Override
    public void sendSystemMessage(SystemMessage msg) {
        this.lock.lock();
        try {
            Cell cell = this.self().underlying();
            if (this.cellIsReady(cell)) {
                cell.sendSystemMessage(msg);
            } else {
                this.sysmsgQueue = LatestFirstSystemMessageList$.MODULE$.$colon$colon$extension(this.sysmsgQueue, msg);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    private final boolean cellIsReady(Cell cell) {
        return cell != this && cell != null;
    }

    @Override
    public boolean hasMessages() {
        return BoxesRunTime.unboxToBoolean(this.locked(this::hasMessages$$anonfun$1));
    }

    @Override
    public int numberOfMessages() {
        return BoxesRunTime.unboxToInt(this.locked(this::numberOfMessages$$anonfun$1));
    }

    private final <T> T locked(Function0<T> body) {
        Object object;
        this.lock.lock();
        try {
            object = body.apply();
        }
        finally {
            this.lock.unlock();
        }
        return (T)object;
    }

    private final void drainSysmsgQueue$1(Cell cell$2) {
        while (LatestFirstSystemMessageList$.MODULE$.nonEmpty$extension(this.sysmsgQueue)) {
            SystemMessage sysQ = LatestFirstSystemMessageList$.MODULE$.reverse$extension(this.sysmsgQueue);
            this.sysmsgQueue = SystemMessageList$.MODULE$.LNil();
            while (EarliestFirstSystemMessageList$.MODULE$.nonEmpty$extension(sysQ)) {
                SystemMessage msg = sysQ;
                sysQ = EarliestFirstSystemMessageList$.MODULE$.tail$extension(sysQ);
                msg.unlink();
                cell$2.sendSystemMessage(msg);
            }
        }
    }

    private final void replaceWith$$anonfun$1(Cell cell$1) {
        try {
            this.drainSysmsgQueue$1(cell$1);
            while (!this.queue.isEmpty()) {
                cell$1.sendMessage(this.queue.poll());
                this.drainSysmsgQueue$1(cell$1);
            }
        }
        finally {
            this.self().swapCell(cell$1);
        }
    }

    private final boolean isTerminated$$anonfun$1() {
        Cell cell = this.self().underlying();
        return this.cellIsReady(cell) ? cell.isTerminated() : false;
    }

    private final boolean hasMessages$$anonfun$1() {
        Cell cell = this.self().underlying();
        return this.cellIsReady(cell) ? cell.hasMessages() : !this.queue.isEmpty();
    }

    private final int numberOfMessages$$anonfun$1() {
        Cell cell = this.self().underlying();
        return this.cellIsReady(cell) ? cell.numberOfMessages() : this.queue.size();
    }
}

