/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.Actor$;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSelectionMessage;
import akka.actor.ActorSelectionMessage$;
import akka.actor.EmptyLocalActorRef;
import akka.actor.InternalActorRef;
import akka.actor.LocalRef;
import akka.actor.MinimalActorRef;
import akka.actor.Nobody$;
import akka.actor.SelectChildName;
import akka.actor.SelectChildName$;
import akka.actor.SelectionPathElement;
import akka.event.MarkerLoggingAdapter;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;

public class VirtualPathContainer
extends InternalActorRef
implements LocalRef,
MinimalActorRef {
    private final ActorRefProvider provider;
    private final ActorPath path;
    private final InternalActorRef getParent;
    private final MarkerLoggingAdapter log;
    private final ConcurrentHashMap<String, InternalActorRef> children;

    public VirtualPathContainer(ActorRefProvider provider, ActorPath path, InternalActorRef getParent, MarkerLoggingAdapter log) {
        this.provider = provider;
        this.path = path;
        this.getParent = getParent;
        this.log = log;
        this.children = new ConcurrentHashMap();
    }

    @Override
    public ActorRefProvider provider() {
        return this.provider;
    }

    @Override
    public ActorPath path() {
        return this.path;
    }

    @Override
    public InternalActorRef getParent() {
        return this.getParent;
    }

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    @Override
    public void $bang(Object message, ActorRef sender) {
        block3: {
            block0: {
                ActorSelectionMessage sel;
                boolean wildcardFanOut;
                Object msg;
                block1: {
                    block4: {
                        InternalActorRef internalActorRef;
                        scala.collection.immutable.Iterable<SelectionPathElement> elements;
                        block2: {
                            Object object = message;
                            if (!(object instanceof ActorSelectionMessage)) break block0;
                            ActorSelectionMessage actorSelectionMessage = (ActorSelectionMessage)object;
                            ActorSelectionMessage actorSelectionMessage2 = ActorSelectionMessage$.MODULE$.unapply(actorSelectionMessage);
                            Object object2 = actorSelectionMessage2._1();
                            scala.collection.immutable.Iterable<SelectionPathElement> iterable = actorSelectionMessage2._2();
                            boolean bl = actorSelectionMessage2._3();
                            msg = object2;
                            elements = iterable;
                            wildcardFanOut = bl;
                            sel = actorSelectionMessage;
                            Predef$.MODULE$.require(elements.nonEmpty());
                            SelectionPathElement selectionPathElement = (SelectionPathElement)elements.head();
                            if (!(selectionPathElement instanceof SelectChildName)) break block1;
                            SelectChildName selectChildName = SelectChildName$.MODULE$.unapply((SelectChildName)selectionPathElement);
                            String string = selectChildName._1();
                            String name = string;
                            internalActorRef = this.getChild(name);
                            if (internalActorRef != null) break block2;
                            if (wildcardFanOut) break block3;
                            this.emptyRef$1(sel).tell(msg, sender);
                            break block3;
                        }
                        InternalActorRef child = internalActorRef;
                        if (!((IterableOnceOps)elements.tail()).isEmpty()) break block4;
                        child.$bang(msg, sender);
                        break block3;
                    }
                    if (wildcardFanOut) break block3;
                    this.emptyRef$1(sel).tell(msg, sender);
                    break block3;
                }
                if (wildcardFanOut) break block3;
                this.emptyRef$1(sel).tell(msg, sender);
                break block3;
            }
            MinimalActorRef.$bang$(this, message, sender);
        }
    }

    @Override
    public ActorRef $bang$default$2(Object message) {
        return Actor$.MODULE$.noSender();
    }

    public void addChild(String name, InternalActorRef ref) {
        block0: {
            InternalActorRef internalActorRef = this.children.put(name, ref);
            if (internalActorRef == null) break block0;
            InternalActorRef old = internalActorRef;
            this.log().debug("{} replacing child {} ({} -> {})", this.path(), (Object)name, (Object)old, (Object)ref);
            old.stop();
        }
    }

    public void removeChild(String name) {
        if (this.children.remove(name) == null) {
            this.log().warning("{} trying to remove non-child {}", this.path(), (Object)name);
        }
    }

    public void removeChild(String name, ActorRef ref) {
        InternalActorRef current = this.getChild(name);
        if (current == null) {
            this.log().warning("{} trying to remove non-child {}", this.path(), (Object)name);
        } else {
            InternalActorRef internalActorRef = current;
            ActorRef actorRef = ref;
            if (!(internalActorRef != null ? !((Object)internalActorRef).equals(actorRef) : actorRef != null)) {
                this.children.remove(name, current);
            }
        }
    }

    public InternalActorRef getChild(String name) {
        return this.children.get(name);
    }

    @Override
    public InternalActorRef getChild(Iterator<String> name) {
        InternalActorRef internalActorRef;
        if (name.isEmpty()) {
            internalActorRef = this;
        } else {
            String n = (String)name.next();
            if (n.isEmpty()) {
                internalActorRef = this;
            } else {
                InternalActorRef internalActorRef2 = this.children.get(n);
                if (internalActorRef2 == null) {
                    internalActorRef = Nobody$.MODULE$;
                } else {
                    InternalActorRef some = internalActorRef2;
                    internalActorRef = name.isEmpty() ? some : some.getChild(name);
                }
            }
        }
        return internalActorRef;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void foreachChild(Function1<ActorRef, BoxedUnit> f) {
        java.util.Iterator<InternalActorRef> iter = this.children.values().iterator();
        while (iter.hasNext()) {
            f.apply((Object)iter.next());
        }
    }

    private final EmptyLocalActorRef emptyRef$1(ActorSelectionMessage sel$1) {
        return new EmptyLocalActorRef(this.provider(), this.path().$div((Iterable<String>)((Iterable)sel$1.elements().map((Function1 & Serializable)_$2 -> _$2.toString()))), this.provider().systemGuardian().underlying().system().eventStream());
    }
}

