/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.ActorCell;
import akka.actor.ActorCell$;
import akka.actor.ActorPath$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ChildActorPath;
import akka.actor.ChildNameReserved$;
import akka.actor.ChildRestartStats;
import akka.actor.ChildRestartStats$;
import akka.actor.ChildStats;
import akka.actor.Deploy;
import akka.actor.FunctionRef;
import akka.actor.InternalActorRef;
import akka.actor.InvalidActorNameException$;
import akka.actor.LocalScope$;
import akka.actor.MinimalActorRef;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.Nobody$;
import akka.actor.Props;
import akka.actor.RepointableRef;
import akka.actor.Scope;
import akka.actor.dungeon.AbstractActorCell;
import akka.actor.dungeon.Children$;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.ChildrenContainer$EmptyChildrenContainer$;
import akka.actor.dungeon.ChildrenContainer$TerminatedChildrenContainer$;
import akka.actor.dungeon.ChildrenContainer$TerminatingChildrenContainer$;
import akka.annotation.InternalStableApi;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import akka.util.Helpers$;
import akka.util.Unsafe;
import java.io.Serializable;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public interface Children {
    public static Function0<Nobody$> GetNobody() {
        return Children$.MODULE$.GetNobody();
    }

    public static void $init$(Children $this) {
        $this.akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly_$eq(ChildrenContainer$EmptyChildrenContainer$.MODULE$);
        $this.akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly_$eq((Map<String, FunctionRef>)Predef$.MODULE$.Map().empty());
        $this.akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly_$eq(0L);
    }

    public ChildrenContainer akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly();

    public void akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly_$eq(ChildrenContainer var1);

    public static ChildrenContainer childrenRefs$(Children $this) {
        return $this.childrenRefs();
    }

    default public ChildrenContainer childrenRefs() {
        return (ChildrenContainer)Unsafe.instance.getObjectVolatile(this, AbstractActorCell.childrenOffset);
    }

    public static Iterable children$(Children $this) {
        return $this.children();
    }

    default public Iterable<ActorRef> children() {
        return this.childrenRefs().children();
    }

    public static java.lang.Iterable getChildren$(Children $this) {
        return $this.getChildren();
    }

    default public java.lang.Iterable<ActorRef> getChildren() {
        return (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(this.children()).asJava();
    }

    public static Option child$(Children $this, String name) {
        return $this.child(name);
    }

    default public Option<ActorRef> child(String name) {
        return Option$.MODULE$.apply((Object)this.getChild(name));
    }

    public static ActorRef getChild$(Children $this, String name) {
        return $this.getChild(name);
    }

    default public ActorRef getChild(String name) {
        ActorRef actorRef;
        ChildStats childStats;
        Option<ChildStats> option = this.childrenRefs().getByName(name);
        if (option instanceof Some && (childStats = (ChildStats)((Some)option).value()) instanceof ChildRestartStats) {
            ChildRestartStats s = (ChildRestartStats)childStats;
            actorRef = s.child();
        } else {
            actorRef = null;
        }
        return actorRef;
    }

    public static Optional findChild$(Children $this, String name) {
        return $this.findChild(name);
    }

    default public Optional<ActorRef> findChild(String name) {
        return Optional.ofNullable(this.getChild(name));
    }

    public static ActorRef actorOf$(Children $this, Props props) {
        return $this.actorOf(props);
    }

    default public ActorRef actorOf(Props props) {
        return this.makeChild((ActorCell)this, props, this.randomName(), false, false);
    }

    public static ActorRef actorOf$(Children $this, Props props, String name) {
        return $this.actorOf(props, name);
    }

    default public ActorRef actorOf(Props props, String name) {
        return this.makeChild((ActorCell)this, props, this.checkName(name), false, false);
    }

    public static ActorRef attachChild$(Children $this, Props props, boolean systemService) {
        return $this.attachChild(props, systemService);
    }

    default public ActorRef attachChild(Props props, boolean systemService) {
        return this.makeChild((ActorCell)this, props, this.randomName(), true, systemService);
    }

    public static ActorRef attachChild$(Children $this, Props props, String name, boolean systemService) {
        return $this.attachChild(props, name, systemService);
    }

    default public ActorRef attachChild(Props props, String name, boolean systemService) {
        return this.makeChild((ActorCell)this, props, this.checkName(name), true, systemService);
    }

    public Map<String, FunctionRef> akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly();

    public void akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly_$eq(Map<String, FunctionRef> var1);

    private Map<String, FunctionRef> functionRefs() {
        return (Map)Unsafe.instance.getObjectVolatile(this, AbstractActorCell.functionRefsOffset);
    }

    public static InternalActorRef getFunctionRefOrNobody$(Children $this, String name, int uid) {
        return $this.getFunctionRefOrNobody(name, uid);
    }

    default public InternalActorRef getFunctionRefOrNobody(String name, int uid) {
        MinimalActorRef minimalActorRef;
        MinimalActorRef minimalActorRef2 = (MinimalActorRef)this.functionRefs().getOrElse((Object)name, Children::getFunctionRefOrNobody$$anonfun$1);
        if (minimalActorRef2 instanceof FunctionRef) {
            FunctionRef f = (FunctionRef)minimalActorRef2;
            minimalActorRef = uid == 0 || f.path().uid() == uid ? f : Nobody$.MODULE$;
        } else {
            MinimalActorRef other;
            minimalActorRef = other = minimalActorRef2;
        }
        return (InternalActorRef)((Object)minimalActorRef);
    }

    public static int getFunctionRefOrNobody$default$2$(Children $this) {
        return $this.getFunctionRefOrNobody$default$2();
    }

    default public int getFunctionRefOrNobody$default$2() {
        return 0;
    }

    public static FunctionRef addFunctionRef$(Children $this, Function2 f, String name) {
        return $this.addFunctionRef((Function2<ActorRef, Object, BoxedUnit>)f, name);
    }

    default public FunctionRef addFunctionRef(Function2<ActorRef, Object, BoxedUnit> f, String name) {
        String r = this.randomName(new StringBuilder("$$"));
        String string = name;
        String string2 = "";
        String n = (string == null ? string2 != null : !string.equals(string2)) ? new StringBuilder(1).append(r).append("-").append(name).toString() : r;
        ChildActorPath childPath = new ChildActorPath(((ActorCell)this).self().path(), n, ActorCell$.MODULE$.newUid());
        FunctionRef ref = new FunctionRef(childPath, ((ActorCell)this).provider(), ((ActorCell)this).system(), f);
        this.rec$1(childPath, ref);
        return ref;
    }

    public static String addFunctionRef$default$2$(Children $this) {
        return $this.addFunctionRef$default$2();
    }

    default public String addFunctionRef$default$2() {
        return "";
    }

    public static boolean removeFunctionRef$(Children $this, FunctionRef ref) {
        return $this.removeFunctionRef(ref);
    }

    default public boolean removeFunctionRef(FunctionRef ref) {
        Predef$.MODULE$.require(ref.path().parent() == ((ActorCell)this).self().path(), Children::removeFunctionRef$$anonfun$1);
        String name = ref.path().name();
        return this.rec$2(ref, name);
    }

    public static void stopFunctionRefs$(Children $this) {
        $this.stopFunctionRefs();
    }

    default public void stopFunctionRefs() {
        Map refs = (Map)Unsafe.instance.getAndSetObject(this, AbstractActorCell.functionRefsOffset, Predef$.MODULE$.Map().empty());
        refs.valuesIterator().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.stop());
    }

    public long akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly();

    public void akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly_$eq(long var1);

    public static String randomName$(Children $this, StringBuilder sb) {
        return $this.randomName(sb);
    }

    default public String randomName(StringBuilder sb) {
        long num = Unsafe.instance.getAndAddLong(this, AbstractActorCell.nextNameOffset, 1L);
        return Helpers$.MODULE$.base64(num, sb);
    }

    public static String randomName$(Children $this) {
        return $this.randomName();
    }

    default public String randomName() {
        long num = Unsafe.instance.getAndAddLong(this, AbstractActorCell.nextNameOffset, 1L);
        return Helpers$.MODULE$.base64(num, Helpers$.MODULE$.base64$default$2());
    }

    public static void stop$(Children $this, ActorRef actor) {
        $this.stop(actor);
    }

    default public void stop(ActorRef actor) {
        if (this.childrenRefs().getByRef(actor).isDefined()) {
            boolean bl;
            ActorRef actorRef = actor;
            if (actorRef instanceof RepointableRef) {
                ActorRef r = (ActorRef)((Object)((RepointableRef)((Object)actorRef)));
                bl = ((RepointableRef)((Object)r)).isStarted();
            } else {
                bl = true;
            }
            if (bl) {
                this.shallDie$1(actor);
            }
        }
        ((InternalActorRef)actor).stop();
    }

    private long _preventPrivateUnusedErasure() {
        this.akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly();
        this.akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly();
        return this.akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly();
    }

    private boolean swapChildrenRefs(ChildrenContainer oldChildren, ChildrenContainer newChildren) {
        return Unsafe.instance.compareAndSwapObject(this, AbstractActorCell.childrenOffset, oldChildren, newChildren);
    }

    public static boolean reserveChild$(Children $this, String name) {
        return $this.reserveChild(name);
    }

    default public boolean reserveChild(String name) {
        ChildrenContainer c;
        Children children = this;
        while (!children.swapChildrenRefs(c = children.childrenRefs(), c.reserve(name))) {
        }
        return true;
    }

    public static boolean unreserveChild$(Children $this, String name) {
        return $this.unreserveChild(name);
    }

    default public boolean unreserveChild(String name) {
        ChildrenContainer c;
        Children children = this;
        while (!children.swapChildrenRefs(c = children.childrenRefs(), c.unreserve(name))) {
        }
        return true;
    }

    public static Option initChild$(Children $this, ActorRef ref) {
        return $this.initChild(ref);
    }

    default public Option<ChildRestartStats> initChild(ActorRef ref) {
        None$ none$;
        block4: {
            ChildrenContainer cc;
            Option<ChildStats> option;
            Children children = this;
            while ((option = (cc = children.childrenRefs()).getByName(ref.path().name())) instanceof Some) {
                Some some = (Some)option;
                ChildStats childStats = (ChildStats)some.value();
                if (childStats instanceof ChildRestartStats) {
                    Some old = some;
                    none$ = (Option)old;
                    break block4;
                }
                if (!ChildNameReserved$.MODULE$.equals(childStats)) break;
                ChildRestartStats crs = ChildRestartStats$.MODULE$.apply(ref, ChildRestartStats$.MODULE$.$lessinit$greater$default$2(), ChildRestartStats$.MODULE$.$lessinit$greater$default$3());
                String name = ref.path().name();
                if (!children.swapChildrenRefs(cc, cc.add(name, crs))) continue;
                none$ = Some$.MODULE$.apply((Object)crs);
                break block4;
            }
            if (None$.MODULE$.equals(option)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
        }
        return none$;
    }

    public static boolean setChildrenTerminationReason$(Children $this, ChildrenContainer.SuspendReason reason) {
        return $this.setChildrenTerminationReason(reason);
    }

    default public boolean setChildrenTerminationReason(ChildrenContainer.SuspendReason reason) {
        boolean bl;
        block1: {
            ChildrenContainer childrenContainer;
            Children children = this;
            while ((childrenContainer = children.childrenRefs()) instanceof ChildrenContainer.TerminatingChildrenContainer) {
                ChildrenContainer.TerminatingChildrenContainer c = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer;
                if (!children.swapChildrenRefs(c, c.copy(c.copy$default$1(), c.copy$default$2(), reason))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static void setTerminated$(Children $this) {
        $this.setTerminated();
    }

    default public void setTerminated() {
        Unsafe.instance.putObjectVolatile(this, AbstractActorCell.childrenOffset, ChildrenContainer$TerminatedChildrenContainer$.MODULE$);
    }

    public static boolean isNormal$(Children $this) {
        return $this.isNormal();
    }

    default public boolean isNormal() {
        return this.childrenRefs().isNormal();
    }

    public static boolean isTerminating$(Children $this) {
        return $this.isTerminating();
    }

    default public boolean isTerminating() {
        return this.childrenRefs().isTerminating();
    }

    public static ChildrenContainer.SuspendReason waitingForChildrenOrNull$(Children $this) {
        return $this.waitingForChildrenOrNull();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public ChildrenContainer.SuspendReason waitingForChildrenOrNull() {
        ChildrenContainer.SuspendReason w;
        ChildrenContainer childrenContainer = this.childrenRefs();
        if (!(childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer)) return null;
        ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer = ChildrenContainer$TerminatingChildrenContainer$.MODULE$.unapply((ChildrenContainer.TerminatingChildrenContainer)childrenContainer);
        TreeMap<String, ChildStats> treeMap = terminatingChildrenContainer._1();
        Set<ActorRef> set = terminatingChildrenContainer._2();
        ChildrenContainer.SuspendReason suspendReason = terminatingChildrenContainer._3();
        if (!(suspendReason instanceof ChildrenContainer.WaitingForChildren)) return null;
        ChildrenContainer.SuspendReason suspendReason2 = w = (ChildrenContainer.SuspendReason)((Object)((ChildrenContainer.WaitingForChildren)((Object)suspendReason)));
        return suspendReason2;
    }

    public static void suspendChildren$(Children $this, Set exceptFor) {
        $this.suspendChildren((Set<ActorRef>)exceptFor);
    }

    @InternalStableApi
    default public void suspendChildren(Set<ActorRef> exceptFor) {
        this.childrenRefs().stats().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            block1: {
                ChildRestartStats childRestartStats = x$1;
                if (childRestartStats == null) break block1;
                ChildRestartStats childRestartStats2 = ChildRestartStats$.MODULE$.unapply(childRestartStats);
                ActorRef actorRef = childRestartStats2._1();
                int n = childRestartStats2._2();
                long l = childRestartStats2._3();
                ActorRef child = actorRef;
                if (!exceptFor.contains((Object)child)) {
                    ((InternalActorRef)child).suspend();
                }
            }
        });
    }

    public static Set suspendChildren$default$1$(Children $this) {
        return $this.suspendChildren$default$1();
    }

    default public Set<ActorRef> suspendChildren$default$1() {
        return Predef$.MODULE$.Set().empty();
    }

    public static void resumeChildren$(Children $this, Throwable causedByFailure, ActorRef perp) {
        $this.resumeChildren(causedByFailure, perp);
    }

    default public void resumeChildren(Throwable causedByFailure, ActorRef perp) {
        this.childrenRefs().stats().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            ActorRef actorRef;
            block3: {
                ChildRestartStats childRestartStats;
                block2: {
                    childRestartStats = x$1;
                    if (childRestartStats == null) break block2;
                    ChildRestartStats childRestartStats2 = ChildRestartStats$.MODULE$.unapply(childRestartStats);
                    actorRef = childRestartStats2._1();
                    int n = childRestartStats2._2();
                    long l = childRestartStats2._3();
                    if (actorRef instanceof InternalActorRef) break block3;
                }
                ChildRestartStats stats = childRestartStats;
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected child ActorRef: ").append(stats.child()).toString());
            }
            InternalActorRef child = (InternalActorRef)actorRef;
            ActorRef actorRef2 = perp;
            InternalActorRef internalActorRef = child;
            child.resume(!(actorRef2 != null ? !((Object)actorRef2).equals(internalActorRef) : internalActorRef != null) ? causedByFailure : null);
        });
    }

    public static Option getChildByName$(Children $this, String name) {
        return $this.getChildByName(name);
    }

    default public Option<ChildStats> getChildByName(String name) {
        return this.childrenRefs().getByName(name);
    }

    public static Option getChildByRef$(Children $this, ActorRef ref) {
        return $this.getChildByRef(ref);
    }

    default public Option<ChildRestartStats> getChildByRef(ActorRef ref) {
        return this.childrenRefs().getByRef(ref);
    }

    public static Iterable getAllChildStats$(Children $this) {
        return $this.getAllChildStats();
    }

    default public Iterable<ChildRestartStats> getAllChildStats() {
        return this.childrenRefs().stats();
    }

    public static InternalActorRef getSingleChild$(Children $this, String name) {
        return $this.getSingleChild(name);
    }

    /*
     * Enabled aggressive block sorting
     */
    default public InternalActorRef getSingleChild(String name) {
        ChildStats childStats;
        InternalActorRef internalActorRef;
        if (name.indexOf(35) == -1) {
            ChildStats childStats2;
            Option<ChildStats> option = this.getChildByName(name);
            if (option instanceof Some && (childStats2 = (ChildStats)((Some)option).value()) instanceof ChildRestartStats) {
                ChildRestartStats crs = (ChildRestartStats)childStats2;
                internalActorRef = (InternalActorRef)crs.child();
                return internalActorRef;
            }
            internalActorRef = this.getFunctionRefOrNobody(name, this.getFunctionRefOrNobody$default$2());
            return internalActorRef;
        }
        Tuple2<String, Object> tuple2 = ActorCell$.MODULE$.splitNameAndUid(name);
        if (tuple2 == null) throw new MatchError(tuple2);
        String childName = (String)tuple2._1();
        int uid = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)childName, (Object)BoxesRunTime.boxToInteger((int)uid));
        String childName2 = (String)tuple22._1();
        int uid2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        Option<ChildStats> option = this.getChildByName(childName2);
        if (option instanceof Some && (childStats = (ChildStats)((Some)option).value()) instanceof ChildRestartStats) {
            ChildRestartStats crs = (ChildRestartStats)childStats;
            if (uid2 == 0 || uid2 == crs.uid()) {
                internalActorRef = (InternalActorRef)crs.child();
                return internalActorRef;
            }
        }
        internalActorRef = this.getFunctionRefOrNobody(childName2, uid2);
        return internalActorRef;
    }

    public static Option removeChildAndGetStateChange$(Children $this, ActorRef child) {
        return $this.removeChildAndGetStateChange(child);
    }

    default public Option<ChildrenContainer.SuspendReason> removeChildAndGetStateChange(ActorRef child) {
        Object object;
        ChildrenContainer childrenContainer = this.childrenRefs();
        if (childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer) {
            ChildrenContainer.SuspendReason suspendReason;
            ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer = ChildrenContainer$TerminatingChildrenContainer$.MODULE$.unapply((ChildrenContainer.TerminatingChildrenContainer)childrenContainer);
            TreeMap<String, ChildStats> treeMap = terminatingChildrenContainer._1();
            Set<ActorRef> set = terminatingChildrenContainer._2();
            ChildrenContainer.SuspendReason reason = suspendReason = terminatingChildrenContainer._3();
            ChildrenContainer childrenContainer2 = this.removeChild$1(child);
            object = childrenContainer2 instanceof ChildrenContainer.TerminatingChildrenContainer ? None$.MODULE$ : Some$.MODULE$.apply((Object)reason);
        } else {
            this.removeChild$1(child);
            object = None$.MODULE$;
        }
        return object;
    }

    private String checkName(String name) {
        String string = name;
        if (string == null) {
            throw InvalidActorNameException$.MODULE$.apply("actor name must not be null");
        }
        if ("".equals(string)) {
            throw InvalidActorNameException$.MODULE$.apply("actor name must not be empty");
        }
        ActorPath$.MODULE$.validatePathElement(name);
        return name;
    }

    private ActorRef makeChild(ActorCell cell, Props props, String name, boolean async, boolean systemService) {
        InternalActorRef internalActorRef;
        ActorSystem.Settings settings = cell.system().settings();
        if (settings.SerializeAllCreators() && !systemService) {
            Scope scope = props.deploy().scope();
            LocalScope$ localScope$ = LocalScope$.MODULE$;
            if (scope == null ? localScope$ != null : !scope.equals(localScope$)) {
                Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
                try {
                    try {
                        Serialization ser = (Serialization)SerializationExtension$.MODULE$.apply(cell.system());
                        if (oldInfo == null) {
                            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)((ActorCell)this).system().provider().serializationInformation());
                        }
                        props.args().forall((Function1 & Serializable)arg -> {
                            if (arg == null) return true;
                            if (arg instanceof NoSerializationVerificationNeeded) return true;
                            String string = arg.getClass().getName();
                            if (settings.NoSerializationVerificationNeededClassPrefix().exists((Function1 & Serializable)x$0 -> string.startsWith((String)x$0))) return true;
                            Object o = arg;
                            Serializer serializer = ser.findSerializerFor(o);
                            byte[] bytes = serializer.toBinary(o);
                            String ms = Serializers$.MODULE$.manifestFor(serializer, o);
                            if (ser.deserialize(bytes, serializer.identifier(), ms).get() == null) return false;
                            return true;
                        });
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e = throwable3 = (Throwable)option.get();
                            throw new IllegalArgumentException(new StringBuilder(46).append("pre-creation serialization check failed at [").append(cell.self().path()).append("/").append(name).append("]").toString(), e);
                        }
                        throw throwable;
                    }
                }
                finally {
                    Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
                }
            }
        }
        if (cell.childrenRefs().isTerminating()) {
            throw new IllegalStateException("cannot create children while terminating or terminated");
        }
        this.reserveChild(name);
        try {
            ChildActorPath childPath = new ChildActorPath(cell.self().path(), name, ActorCell$.MODULE$.newUid());
            internalActorRef = cell.provider().actorOf(cell.systemImpl(), props, cell.self(), childPath, systemService, (Option<Deploy>)None$.MODULE$, true, async);
        }
        catch (InterruptedException e) {
            this.unreserveChild(name);
            Thread.interrupted();
            throw e;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable4 = throwable;
            if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                Throwable throwable5;
                Throwable e = throwable5 = (Throwable)option.get();
                this.unreserveChild(name);
                throw e;
            }
            throw throwable;
        }
        InternalActorRef actor = internalActorRef;
        if (((ActorCell)this).mailbox() != null) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), ((ActorCell)this).mailbox().suspendCount()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                int n = x$1;
                actor.suspend();
            });
        }
        this.initChild(actor);
        actor.start();
        return actor;
    }

    private static Nobody$ getFunctionRefOrNobody$$anonfun$1() {
        return (Nobody$)Children$.MODULE$.GetNobody().apply();
    }

    private void rec$1(ChildActorPath childPath$1, FunctionRef ref$1) {
        Map added;
        Map<String, FunctionRef> old;
        while (!Unsafe.instance.compareAndSwapObject(this, AbstractActorCell.functionRefsOffset, old = this.functionRefs(), added = (Map)old.updated((Object)childPath$1.name(), (Object)ref$1))) {
        }
    }

    private static String removeFunctionRef$$anonfun$1() {
        return "trying to remove FunctionRef from wrong ActorCell";
    }

    private boolean rec$2(FunctionRef ref$2, String name$1) {
        boolean bl;
        block1: {
            Map removed;
            Map<String, FunctionRef> old;
            do {
                if ((old = this.functionRefs()).contains((Object)name$1)) continue;
                bl = false;
                break block1;
            } while (!Unsafe.instance.compareAndSwapObject(this, AbstractActorCell.functionRefsOffset, old, removed = (Map)old.$minus((Object)name$1)));
            ref$2.stop();
            bl = true;
        }
        return bl;
    }

    private boolean shallDie$1(ActorRef ref) {
        ChildrenContainer c;
        while (!this.swapChildrenRefs(c = this.childrenRefs(), c.shallDie(ref))) {
        }
        return true;
    }

    private ChildrenContainer removeChild$1(ActorRef ref) {
        ChildrenContainer n;
        ChildrenContainer c;
        while (!this.swapChildrenRefs(c = this.childrenRefs(), n = c.remove(ref))) {
        }
        return n;
    }
}

