/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorContext;
import akka.actor.ActorInitializationException;
import akka.actor.ActorInterruptedException;
import akka.actor.ActorRef;
import akka.actor.ActorRefScope;
import akka.actor.ChildRestartStats;
import akka.actor.InternalActorRef;
import akka.actor.PostRestartException$;
import akka.actor.PreRestartException;
import akka.actor.PreRestartException$;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.ChildrenContainer$Creation$;
import akka.actor.dungeon.ChildrenContainer$Recreation$;
import akka.actor.dungeon.ChildrenContainer$Termination$;
import akka.actor.dungeon.FaultHandling$FailedFatally$;
import akka.actor.dungeon.FaultHandling$FailedRef$;
import akka.actor.dungeon.FaultHandling$NoFailedInfo$;
import akka.annotation.InternalStableApi;
import akka.dispatch.Envelope$;
import akka.dispatch.sysmsg.DeathWatchNotification$;
import akka.dispatch.sysmsg.Failed;
import akka.dispatch.sysmsg.Failed$;
import akka.event.Logging$;
import akka.event.Logging$Debug$;
import akka.event.Logging$Error$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public interface FaultHandling {
    public static void $init$(FaultHandling $this) {
        $this.akka$actor$dungeon$FaultHandling$$_failed_$eq(FaultHandling$NoFailedInfo$.MODULE$);
    }

    private void suspendNonRecursive() {
        ((ActorCell)this).dispatcher().suspend((ActorCell)this);
    }

    private void resumeNonRecursive() {
        ((ActorCell)this).dispatcher().resume((ActorCell)this);
    }

    public FailedInfo akka$actor$dungeon$FaultHandling$$_failed();

    public void akka$actor$dungeon$FaultHandling$$_failed_$eq(FailedInfo var1);

    private boolean isFailed() {
        return this.akka$actor$dungeon$FaultHandling$$_failed() instanceof FailedRef;
    }

    private boolean isFailedFatally() {
        return this.akka$actor$dungeon$FaultHandling$$_failed() == FaultHandling$FailedFatally$.MODULE$;
    }

    private ActorRef perpetrator() {
        ActorRef actorRef;
        FailedInfo failedInfo = this.akka$actor$dungeon$FaultHandling$$_failed();
        if (failedInfo instanceof FailedRef) {
            ActorRef actorRef2;
            ActorRef ref;
            FailedRef failedRef = FaultHandling$FailedRef$.MODULE$.unapply((FailedRef)failedInfo);
            actorRef = ref = (actorRef2 = failedRef._1());
        } else {
            actorRef = null;
        }
        return actorRef;
    }

    private void setFailed(ActorRef perpetrator) {
        FailedInfo failedInfo = this.akka$actor$dungeon$FaultHandling$$_failed();
        this.akka$actor$dungeon$FaultHandling$$_failed_$eq((FailedInfo)(FaultHandling$FailedFatally$.MODULE$.equals(failedInfo) ? FaultHandling$FailedFatally$.MODULE$ : FaultHandling$FailedRef$.MODULE$.apply(perpetrator)));
    }

    private void clearFailed() {
        FailedInfo failedInfo;
        FailedInfo failedInfo2 = this.akka$actor$dungeon$FaultHandling$$_failed();
        if (failedInfo2 instanceof FailedRef) {
            FailedRef failedRef = FaultHandling$FailedRef$.MODULE$.unapply((FailedRef)failedInfo2);
            ActorRef actorRef = failedRef._1();
            failedInfo = FaultHandling$NoFailedInfo$.MODULE$;
        } else {
            FailedInfo other;
            failedInfo = other = failedInfo2;
        }
        this.akka$actor$dungeon$FaultHandling$$_failed_$eq(failedInfo);
    }

    public static void setFailedFatally$(FaultHandling $this) {
        $this.setFailedFatally();
    }

    default public void setFailedFatally() {
        this.akka$actor$dungeon$FaultHandling$$_failed_$eq(FaultHandling$FailedFatally$.MODULE$);
    }

    public static void faultRecreate$(FaultHandling $this, Throwable cause) {
        $this.faultRecreate(cause);
    }

    default public void faultRecreate(Throwable cause) {
        if (((ActorCell)this).actor() == null) {
            ((ActorCell)this).system().eventStream().publish(Logging$Error$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(36).append("changing Recreate into Create after ").append(cause).toString()));
            this.faultCreate();
        } else if (((ActorCell)this).isNormal()) {
            block15: {
                Actor failedActor = ((ActorCell)this).actor();
                if (((ActorCell)this).system().settings().DebugLifecycle()) {
                    ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(failedActor), "restarting"));
                }
                if (failedActor != null) {
                    None$ optionalMessage = ((ActorCell)this).currentMessage() != null ? Some$.MODULE$.apply(((ActorCell)this).currentMessage().message()) : None$.MODULE$;
                    try {
                        try {
                            if (!this.isFailedFatally()) {
                                failedActor.aroundPreRestart(cause, (Option<Object>)optionalMessage);
                            }
                        }
                        catch (Throwable ex$) {
                            PartialFunction<Throwable, BoxedUnit> $1$ = this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)((JProcedure1 & Serializable)arg_0 -> this.$anonfun$1(cause, failedActor, (Option)optionalMessage, arg_0)));
                            if ($1$.isDefinedAt((Object)ex$)) {
                                $1$.apply((Object)ex$);
                                break block15;
                            }
                            throw ex$;
                        }
                    }
                    finally {
                        ((ActorCell)this).clearActorFields(failedActor, true);
                    }
                }
            }
            if (!((ActorCell)this).mailbox().isSuspended()) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(49).append("mailbox must be suspended during restart, status=").append(((ActorCell)this).mailbox().currentStatus()).toString());
            }
            if (!((ActorCell)this).setChildrenTerminationReason(ChildrenContainer$Recreation$.MODULE$.apply(cause))) {
                this.finishRecreate(cause);
            }
        } else {
            this.faultResume(null);
        }
    }

    public static void faultSuspend$(FaultHandling $this) {
        $this.faultSuspend();
    }

    default public void faultSuspend() {
        this.suspendNonRecursive();
        ((ActorCell)this).suspendChildren(((ActorCell)this).suspendChildren$default$1());
    }

    public static void faultResume$(FaultHandling $this, Throwable causedByFailure) {
        $this.faultResume(causedByFailure);
    }

    default public void faultResume(Throwable causedByFailure) {
        if (((ActorCell)this).actor() == null) {
            ((ActorCell)this).system().eventStream().publish(Logging$Error$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(34).append("changing Resume into Create after ").append(causedByFailure).toString()));
            this.faultCreate();
        } else if (this.isFailedFatally() && causedByFailure != null) {
            ((ActorCell)this).system().eventStream().publish(Logging$Error$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(35).append("changing Resume into Restart after ").append(causedByFailure).toString()));
            this.faultRecreate(causedByFailure);
        } else {
            ActorRef perp = this.perpetrator();
            try {
                this.resumeNonRecursive();
            }
            finally {
                if (causedByFailure != null) {
                    this.clearFailed();
                }
            }
            ((ActorCell)this).resumeChildren(causedByFailure, perp);
        }
    }

    public static void faultCreate$(FaultHandling $this) {
        $this.faultCreate();
    }

    default public void faultCreate() {
        if (!((ActorCell)this).mailbox().isSuspended()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(57).append("mailbox must be suspended during failed creation, status=").append(((ActorCell)this).mailbox().currentStatus()).toString());
        }
        ActorRef actorRef = this.perpetrator();
        InternalActorRef internalActorRef = ((ActorCell)this).self();
        if (actorRef == null ? internalActorRef != null : !((Object)actorRef).equals(internalActorRef)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        ((ActorCell)this).setReceiveTimeout((Duration)Duration$.MODULE$.Undefined());
        ((ActorCell)this).cancelReceiveTimeout();
        ((ActorCell)this).children().foreach((Function1)(JProcedure1 & Serializable)actor -> ((ActorCell)this).stop((ActorRef)actor));
        if (!((ActorCell)this).setChildrenTerminationReason(ChildrenContainer$Creation$.MODULE$.apply())) {
            this.finishCreate();
        }
    }

    private void finishCreate() {
        try {
            this.resumeNonRecursive();
        }
        finally {
            this.clearFailed();
        }
        try {
            ((ActorCell)this).create((Option<ActorInitializationException>)None$.MODULE$);
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $2$ = this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)e -> this.handleInvokeFailure((scala.collection.immutable.Iterable<ActorRef>)package$.MODULE$.Nil(), (Throwable)e));
            if ($2$.isDefinedAt((Object)ex$)) {
                $2$.apply((Object)ex$);
            }
            throw ex$;
        }
    }

    public static void terminate$(FaultHandling $this) {
        $this.terminate();
    }

    default public void terminate() {
        ((ActorCell)this).setReceiveTimeout((Duration)Duration$.MODULE$.Undefined());
        ((ActorCell)this).cancelReceiveTimeout();
        ((ActorCell)this).unwatchWatchedActors(((ActorCell)this).actor());
        ((ActorCell)this).children().foreach((Function1)(JProcedure1 & Serializable)actor -> ((ActorCell)this).stop((ActorRef)actor));
        if (((ActorCell)this).systemImpl().aborting()) {
            ((ActorCell)this).children().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                block0: {
                    ActorRef ref;
                    ActorRef actorRef = x$1;
                    if (!(actorRef instanceof ActorRefScope) || ((ActorRefScope)((Object)(ref = (ActorRef)((Object)((ActorRefScope)((Object)actorRef)))))).isLocal()) break block0;
                    ((ActorCell)this).self().sendSystemMessage(DeathWatchNotification$.MODULE$.apply(ref, true, false));
                }
            });
        }
        boolean wasTerminating = ((ActorCell)this).isTerminating();
        if (((ActorCell)this).setChildrenTerminationReason(ChildrenContainer$Termination$.MODULE$)) {
            if (!wasTerminating) {
                this.suspendNonRecursive();
                this.setFailed(((ActorCell)this).self());
                if (((ActorCell)this).system().settings().DebugLifecycle()) {
                    ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), "stopping"));
                }
            }
        } else {
            ((ActorCell)this).setTerminated();
            this.finishTerminate();
        }
    }

    public static void handleInvokeFailure$(FaultHandling $this, scala.collection.immutable.Iterable childrenNotToSuspend, Throwable t) {
        $this.handleInvokeFailure((scala.collection.immutable.Iterable<ActorRef>)childrenNotToSuspend, t);
    }

    /*
     * Unable to fully structure code
     */
    @InternalStableApi
    default public void handleInvokeFailure(scala.collection.immutable.Iterable<ActorRef> childrenNotToSuspend, Throwable t) {
        block7: {
            if (this.isFailed()) break block7;
            try {
                this.suspendNonRecursive();
                var4_3 = ((ActorCell)this).currentMessage();
                if (var4_3 == null) ** GOTO lbl-1000
                var5_4 = Envelope$.MODULE$.unapply(var4_3);
                var6_5 = var5_4._1();
                var7_6 = var5_4._2();
                if (var6_5 instanceof Failed) {
                    var8_7 = Failed$.MODULE$.unapply((Failed)var6_5);
                    var9_8 = var8_7._1();
                    var10_9 = var8_7._2();
                    var11_10 = var8_7._3();
                    child = var7_6;
                    this.setFailed(child);
                    v0 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[]{child}));
                } else lbl-1000:
                // 2 sources

                {
                    this.setFailed(((ActorCell)this).self());
                    v0 = Predef$.MODULE$.Set().empty();
                }
                skip = v0;
                ((ActorCell)this).suspendChildren((Set)skip.$plus$plus(childrenNotToSuspend));
                var13_13 = t;
                if (var13_13 instanceof InterruptedException) {
                    ((ActorCell)this).parent().sendSystemMessage(Failed$.MODULE$.apply(((ActorCell)this).self(), new ActorInterruptedException(t), ((ActorCell)this).uid()));
                } else {
                    ((ActorCell)this).parent().sendSystemMessage(Failed$.MODULE$.apply(((ActorCell)this).self(), t, ((ActorCell)this).uid()));
                }
            }
            catch (Throwable ex$) {
                $3$ = this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, $anonfun$3(java.lang.Throwable java.lang.Throwable ), (Ljava/lang/Throwable;)V)((FaultHandling)this, (Throwable)t));
                if ($3$.isDefinedAt((Object)ex$)) {
                    $3$.apply((Object)ex$);
                }
                throw ex$;
            }
        }
    }

    private void finishTerminate() {
        block137: {
            Actor a = ((ActorCell)this).actor();
            try {
                try {
                    if (a != null) {
                        a.aroundPostStop();
                    }
                }
                catch (Throwable ex$) {
                    PartialFunction<Throwable, BoxedUnit> $4$ = this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)e -> ((ActorCell)this).publish(Logging$Error$.MODULE$.apply((Throwable)e, ((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(a), e.getMessage())));
                    if ($4$.isDefinedAt((Object)ex$)) {
                        $4$.apply((Object)ex$);
                        break block137;
                    }
                    throw ex$;
                }
            }
            finally {
                try {
                    ((ActorCell)this).dispatcher().detach((ActorCell)this);
                }
                finally {
                    try {
                        ((ActorCell)this).parent().sendSystemMessage(DeathWatchNotification$.MODULE$.apply(((ActorCell)this).self(), true, false));
                    }
                    finally {
                        try {
                            ((ActorCell)this).stopFunctionRefs();
                        }
                        finally {
                            try {
                                ((ActorCell)this).tellWatchersWeDied();
                            }
                            finally {
                                try {
                                    ((ActorCell)this).unwatchWatchedActors(a);
                                }
                                finally {
                                    if (((ActorCell)this).system().settings().DebugLifecycle()) {
                                        ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(a), "stopped"));
                                    }
                                    ((ActorCell)this).clearActorFields(a, false);
                                    ((ActorCell)this).clearFieldsForTermination();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void finishRecreate(Throwable cause) {
        scala.collection.immutable.Iterable survivors = ((ActorCell)this).children();
        try {
            try {
                this.resumeNonRecursive();
            }
            finally {
                this.clearFailed();
            }
            Actor freshActor = ((ActorCell)this).newActor();
            freshActor.aroundPostRestart(cause);
            ((ActorCell)this).checkReceiveTimeout(true);
            if (((ActorCell)this).system().settings().DebugLifecycle()) {
                ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(freshActor), "restarted"));
            }
            survivors.foreach((Function1)(JProcedure1 & Serializable)child -> this.liftedTree1$1(cause, freshActor, (ActorRef)child));
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $5$ = this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)e -> {
                this.setFailedFatally();
                ((ActorCell)this).clearActorFields(((ActorCell)this).actor(), false);
                this.handleInvokeFailure((scala.collection.immutable.Iterable<ActorRef>)survivors, PostRestartException$.MODULE$.apply(((ActorCell)this).self(), (Throwable)e, cause));
            });
            if ($5$.isDefinedAt((Object)ex$)) {
                $5$.apply((Object)ex$);
            }
            throw ex$;
        }
    }

    public static void handleFailure$(FaultHandling $this, Failed f) {
        $this.handleFailure(f);
    }

    default public void handleFailure(Failed f) {
        ((ActorCell)this).currentMessage_$eq(Envelope$.MODULE$.apply(f, f.child(), ((ActorCell)this).system()));
        Option option = ((ActorCell)this).getChildByRef(f.child());
        if (option instanceof Some) {
            ChildRestartStats childRestartStats = (ChildRestartStats)((Some)option).value();
            ChildRestartStats stats = childRestartStats;
            if (stats.uid() == f.uid()) {
                if (!((ActorCell)this).actor().supervisorStrategy().handleFailure((ActorContext)((Object)this), f.child(), f.cause(), stats, (Iterable<ChildRestartStats>)((ActorCell)this).getAllChildStats())) {
                    throw f.cause();
                }
            } else {
                ChildRestartStats stats2 = childRestartStats;
                ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(44).append("dropping Failed(").append(f.cause()).append(") from old child ").append(f.child()).append(" (uid=").append(stats2.uid()).append(" != ").append(f.uid()).append(")").toString()));
            }
        } else if (None$.MODULE$.equals(option)) {
            ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(37).append("dropping Failed(").append(f.cause()).append(") from unknown child ").append(f.child()).toString()));
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static void handleChildTerminated$(FaultHandling $this, ActorRef child) {
        $this.handleChildTerminated(child);
    }

    default public void handleChildTerminated(ActorRef child) {
        block4: {
            ChildrenContainer.SuspendReason suspendReason;
            block6: {
                block5: {
                    Throwable throwable;
                    Option option;
                    Option status = ((ActorCell)this).removeChildAndGetStateChange(child);
                    if (((ActorCell)this).actor() != null) {
                        try {
                            ((ActorCell)this).actor().supervisorStrategy().handleChildTerminated((ActorContext)((Object)this), child, (Iterable<ActorRef>)((ActorCell)this).children());
                        }
                        catch (Throwable ex$) {
                            PartialFunction<Throwable, BoxedUnit> $7$ = this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)e -> {
                                ((ActorCell)this).publish(Logging$Error$.MODULE$.apply((Throwable)e, ((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), "handleChildTerminated failed"));
                                this.handleInvokeFailure((scala.collection.immutable.Iterable<ActorRef>)package$.MODULE$.Nil(), (Throwable)e);
                            });
                            if ($7$.isDefinedAt((Object)ex$)) {
                                $7$.apply((Object)ex$);
                            }
                            throw ex$;
                        }
                    }
                    if (!((option = status) instanceof Some)) break block4;
                    suspendReason = (ChildrenContainer.SuspendReason)((Some)option).value();
                    if (!(suspendReason instanceof ChildrenContainer.Recreation)) break block5;
                    ChildrenContainer.Recreation recreation = ChildrenContainer$Recreation$.MODULE$.unapply((ChildrenContainer.Recreation)suspendReason);
                    Throwable cause = throwable = recreation._1();
                    this.finishRecreate(cause);
                    break block4;
                }
                if (!(suspendReason instanceof ChildrenContainer.Creation) || !ChildrenContainer$Creation$.MODULE$.unapply((ChildrenContainer.Creation)suspendReason)) break block6;
                this.finishCreate();
                break block4;
            }
            if (!ChildrenContainer$Termination$.MODULE$.equals(suspendReason)) break block4;
            this.finishTerminate();
        }
    }

    public static PartialFunction handleNonFatalOrInterruptedException$(FaultHandling $this, Function1 thunk) {
        return $this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)thunk);
    }

    default public PartialFunction<Throwable, BoxedUnit> handleNonFatalOrInterruptedException(Function1<Throwable, BoxedUnit> thunk) {
        return new Serializable(thunk){
            private final Function1 thunk$1;
            {
                this.thunk$1 = thunk$2;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                boolean bl;
                Throwable throwable = x;
                if (throwable instanceof InterruptedException) {
                    InterruptedException e = (InterruptedException)throwable;
                    bl = true;
                } else if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Object object;
                Throwable throwable = x;
                if (throwable instanceof InterruptedException) {
                    InterruptedException e = (InterruptedException)throwable;
                    this.thunk$1.apply((Object)e);
                    Thread.currentThread().interrupt();
                    object = BoxedUnit.UNIT;
                } else if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    object = this.thunk$1.apply((Object)e);
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        };
    }

    private /* synthetic */ void $anonfun$1(Throwable cause$1, Actor failedActor$1, Option optionalMessage$1, Throwable e) {
        PreRestartException ex = PreRestartException$.MODULE$.apply(((ActorCell)this).self(), e, cause$1, (Option<Object>)optionalMessage$1);
        ((ActorCell)this).publish(Logging$Error$.MODULE$.apply(ex, ((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(failedActor$1), e.getMessage()));
    }

    private /* synthetic */ void $anonfun$3(Throwable t$1, Throwable e) {
        ((ActorCell)this).publish(Logging$Error$.MODULE$.apply(e, ((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(50).append("emergency stop: exception in failure handling for ").append(t$1.getClass()).append(Logging$.MODULE$.stackTraceFor(t$1)).toString()));
        try {
            ((ActorCell)this).children().foreach((Function1)(JProcedure1 & Serializable)actor -> ((ActorCell)this).stop((ActorRef)actor));
        }
        finally {
            this.finishTerminate();
        }
    }

    private void liftedTree1$1(Throwable cause$2, Actor freshActor$1, ActorRef child$1) {
        try {
            ((InternalActorRef)child$1).restart(cause$2);
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $6$ = this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)e -> ((ActorCell)this).publish(Logging$Error$.MODULE$.apply((Throwable)e, ((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(freshActor$1), new StringBuilder(11).append("restarting ").append(child$1).toString())));
            if ($6$.isDefinedAt((Object)ex$)) {
                $6$.apply((Object)ex$);
            }
            throw ex$;
        }
    }

    public static interface FailedInfo {
    }

    private static final class FailedRef
    implements FailedInfo,
    Product,
    Serializable {
        private final ActorRef ref;

        public static FailedRef apply(ActorRef actorRef) {
            return FaultHandling$FailedRef$.MODULE$.apply(actorRef);
        }

        public static FailedRef fromProduct(Product product) {
            return FaultHandling$FailedRef$.MODULE$.fromProduct(product);
        }

        public static FailedRef unapply(FailedRef failedRef) {
            return FaultHandling$FailedRef$.MODULE$.unapply(failedRef);
        }

        public FailedRef(ActorRef ref) {
            this.ref = ref;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FailedRef)) return false;
            FailedRef failedRef = (FailedRef)object;
            ActorRef actorRef = this.ref();
            ActorRef actorRef2 = failedRef.ref();
            if (actorRef != null) {
                if (!((Object)actorRef).equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FailedRef;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FailedRef";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "ref";
        }

        public ActorRef ref() {
            return this.ref;
        }

        public FailedRef copy(ActorRef ref) {
            return new FailedRef(ref);
        }

        public ActorRef copy$default$1() {
            return this.ref();
        }

        public ActorRef _1() {
            return this.ref();
        }
    }
}

