/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.actor.ActorCell;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystemImpl;
import akka.actor.Cell;
import akka.actor.dungeon.Dispatch;
import akka.dispatch.DefaultSystemMessageQueue;
import akka.dispatch.Dispatcher;
import akka.dispatch.Envelope;
import akka.dispatch.ExecutorServiceFactoryProvider;
import akka.dispatch.LoadMetrics;
import akka.dispatch.Mailbox;
import akka.dispatch.MailboxType;
import akka.dispatch.MessageDispatcherConfigurator;
import akka.dispatch.MessageQueue;
import akka.dispatch.sysmsg.EarliestFirstSystemMessageList$;
import akka.dispatch.sysmsg.NoMessage$;
import akka.dispatch.sysmsg.SystemMessage;
import akka.util.Helpers$;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import scala.None$;
import scala.Option;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class BalancingDispatcher
extends Dispatcher {
    private final boolean attemptTeamWork;
    private final ConcurrentSkipListSet team;
    private final MessageQueue messageQueue;

    public BalancingDispatcher(MessageDispatcherConfigurator _configurator, String _id, int throughput, Duration throughputDeadlineTime, MailboxType _mailboxType, ExecutorServiceFactoryProvider _executorServiceFactoryProvider, FiniteDuration _shutdownTimeout, boolean attemptTeamWork) {
        this.attemptTeamWork = attemptTeamWork;
        super(_configurator, _id, throughput, throughputDeadlineTime, _executorServiceFactoryProvider, _shutdownTimeout);
        this.team = new ConcurrentSkipListSet<ActorCell>(Helpers$.MODULE$.identityHashComparator(new Comparator<ActorCell>(){

            public int compare(ActorCell l, ActorCell r) {
                return l.self().path().compareTo(r.self().path());
            }
        }));
        this.messageQueue = _mailboxType.create((Option<ActorRef>)None$.MODULE$, (Option<ActorSystem>)None$.MODULE$);
    }

    private int throughput$accessor() {
        return super.throughput();
    }

    private Duration throughputDeadlineTime$accessor() {
        return super.throughputDeadlineTime();
    }

    public ConcurrentSkipListSet<ActorCell> team() {
        return this.team;
    }

    public MessageQueue messageQueue() {
        return this.messageQueue;
    }

    @Override
    public Mailbox createMailbox(Cell actor, MailboxType mailboxType) {
        return new SharingMailbox(this, actor.systemImpl(), this.messageQueue());
    }

    @Override
    public void register(ActorCell actor) {
        super.register(actor);
        this.team().add(actor);
    }

    @Override
    public void unregister(ActorCell actor) {
        this.team().remove(actor);
        super.unregister(actor);
        this.teamWork();
    }

    @Override
    public void dispatch(ActorCell receiver, Envelope invocation) {
        this.messageQueue().enqueue(receiver.self(), invocation);
        if (!this.registerForExecution(receiver.mailbox(), false, false)) {
            this.teamWork();
        }
    }

    public void teamWork() {
        if (this.attemptTeamWork) {
            this.scheduleOne$1(this.scheduleOne$default$1$1());
        }
    }

    private final void scheduleOne$1(Iterator i) {
        while (this.messageQueue().hasMessages() && i.hasNext()) {
            LoadMetrics lm;
            ExecutorService executorService = this.executorService().executor();
            if ((executorService instanceof LoadMetrics ? !(lm = (LoadMetrics)((Object)executorService)).atFullThrottle() : true) && !this.registerForExecution(((Dispatch)i.next()).mailbox(), false, false)) continue;
        }
    }

    private final Iterator scheduleOne$default$1$1() {
        return this.team().iterator();
    }

    private class SharingMailbox
    extends Mailbox
    implements DefaultSystemMessageQueue {
        private final ActorSystemImpl system;
        private final BalancingDispatcher $outer;

        public SharingMailbox(BalancingDispatcher $outer, ActorSystemImpl system, MessageQueue _messageQueue) {
            this.system = system;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(_messageQueue);
        }

        public ActorSystemImpl system() {
            return this.system;
        }

        @Override
        public void cleanUp() {
            Mailbox dlq = this.$outer.mailboxes().deadLetterMailbox();
            SystemMessage messages = this.systemDrain(NoMessage$.MODULE$);
            while (EarliestFirstSystemMessageList$.MODULE$.nonEmpty$extension(messages)) {
                SystemMessage message = messages;
                messages = EarliestFirstSystemMessageList$.MODULE$.tail$extension(messages);
                message.unlink();
                dlq.systemEnqueue(this.system().deadLetters(), message);
            }
        }

        public final BalancingDispatcher akka$dispatch$BalancingDispatcher$SharingMailbox$$$outer() {
            return this.$outer;
        }
    }
}

