/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.dispatch.BalancingDispatcher;
import akka.dispatch.BalancingDispatcherConfigurator$;
import akka.dispatch.DispatcherPrerequisites;
import akka.dispatch.MailboxType;
import akka.dispatch.Mailboxes;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.MessageDispatcherConfigurator;
import akka.dispatch.MultipleConsumerSemantics;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import com.typesafe.config.Config;
import scala.concurrent.duration.Duration;

public class BalancingDispatcherConfigurator
extends MessageDispatcherConfigurator {
    private final BalancingDispatcher instance;

    public static Config amendConfig(Config config) {
        return BalancingDispatcherConfigurator$.MODULE$.amendConfig(config);
    }

    public BalancingDispatcherConfigurator(Config _config, DispatcherPrerequisites _prerequisites) {
        super(BalancingDispatcherConfigurator$.MODULE$.amendConfig(_config), _prerequisites);
        MailboxType mailboxType;
        Mailboxes mailboxes = this.prerequisites().mailboxes();
        String id = this.config().getString("id");
        Class<? extends Object> requirement = mailboxes.getMailboxRequirement(this.config());
        if (!MultipleConsumerSemantics.class.isAssignableFrom(requirement)) {
            throw new IllegalArgumentException(new StringBuilder(110).append("BalancingDispatcher must have 'mailbox-requirement' which implements akka.dispatch.MultipleConsumerSemantics; ").append(new StringBuilder(20).append("dispatcher [").append(id).append("] has [").append(requirement).append("]").toString()).toString());
        }
        if (this.config().hasPath("mailbox")) {
            MailboxType mt = mailboxes.lookup(this.config().getString("mailbox"));
            if (!requirement.isAssignableFrom(mailboxes.getProducedMessageQueueType(mt))) {
                throw new IllegalArgumentException(new StringBuilder(91).append("BalancingDispatcher [").append(id).append("] has 'mailbox' [").append(mt.getClass()).append("] which is incompatible with 'mailbox-requirement' [").append(requirement).append("]").toString());
            }
            mailboxType = mt;
        } else if (this.config().hasPath("mailbox-type")) {
            MailboxType mt = mailboxes.lookup(id);
            if (!requirement.isAssignableFrom(mailboxes.getProducedMessageQueueType(mt))) {
                throw new IllegalArgumentException(new StringBuilder(96).append("BalancingDispatcher [").append(id).append("] has 'mailbox-type' [").append(mt.getClass()).append("] which is incompatible with 'mailbox-requirement' [").append(requirement).append("]").toString());
            }
            mailboxType = mt;
        } else {
            mailboxType = mailboxes.lookupByQueueType(requirement);
        }
        MailboxType mailboxType2 = mailboxType;
        this.instance = this.create(mailboxType2);
    }

    public BalancingDispatcher create(MailboxType mailboxType) {
        return new BalancingDispatcher(this, this.config().getString("id"), this.config().getInt("throughput"), (Duration)Helpers$ConfigOps$.MODULE$.getNanosDuration$extension(Helpers$.MODULE$.ConfigOps(this.config()), "throughput-deadline-time"), mailboxType, this.configureExecutor(), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.config()), "shutdown-timeout"), this.config().getBoolean("attempt-teamwork"));
    }

    @Override
    public MessageDispatcher dispatcher() {
        return this.instance;
    }
}

