/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.DeadLetter$;
import akka.actor.InternalActorRef;
import akka.dispatch.BoundedControlAwareMailbox$;
import akka.dispatch.BoundedControlAwareMessageQueueSemantics;
import akka.dispatch.ControlAwareMessageQueueSemantics;
import akka.dispatch.ControlMessage;
import akka.dispatch.Envelope;
import akka.dispatch.Envelope$;
import akka.dispatch.MailboxType;
import akka.dispatch.ProducesMessageQueue;
import akka.dispatch.ProducesPushTimeoutSemanticsMailbox;
import akka.dispatch.QueueBasedMessageQueue;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.Option;
import scala.Product;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BoundedControlAwareMailbox
implements MailboxType,
ProducesMessageQueue<MessageQueue>,
ProducesPushTimeoutSemanticsMailbox,
Product,
Serializable {
    private final int capacity;
    private final FiniteDuration pushTimeOut;

    public static BoundedControlAwareMailbox apply(int n, FiniteDuration finiteDuration) {
        return BoundedControlAwareMailbox$.MODULE$.apply(n, finiteDuration);
    }

    public static BoundedControlAwareMailbox fromProduct(Product product) {
        return BoundedControlAwareMailbox$.MODULE$.fromProduct(product);
    }

    public static BoundedControlAwareMailbox unapply(BoundedControlAwareMailbox boundedControlAwareMailbox) {
        return BoundedControlAwareMailbox$.MODULE$.unapply(boundedControlAwareMailbox);
    }

    public BoundedControlAwareMailbox(int capacity, FiniteDuration pushTimeOut) {
        this.capacity = capacity;
        this.pushTimeOut = pushTimeOut;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.capacity());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pushTimeOut()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BoundedControlAwareMailbox)) return false;
        BoundedControlAwareMailbox boundedControlAwareMailbox = (BoundedControlAwareMailbox)object;
        if (this.capacity() != boundedControlAwareMailbox.capacity()) return false;
        FiniteDuration finiteDuration = this.pushTimeOut();
        FiniteDuration finiteDuration2 = boundedControlAwareMailbox.pushTimeOut();
        if (finiteDuration != null) {
            if (!finiteDuration.equals(finiteDuration2)) return false;
            return true;
        }
        if (finiteDuration2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BoundedControlAwareMailbox;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "BoundedControlAwareMailbox";
    }

    public Object productElement(int n) {
        Integer n2;
        int n3 = n;
        if (0 == n3) {
            n2 = BoxesRunTime.boxToInteger((int)this._1());
        } else if (1 == n3) {
            n2 = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return n2;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "capacity";
        } else if (1 == n2) {
            string = "pushTimeOut";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public int capacity() {
        return this.capacity;
    }

    public final FiniteDuration pushTimeOut() {
        return this.pushTimeOut;
    }

    public BoundedControlAwareMailbox(ActorSystem.Settings settings, Config config) {
        this(config.getInt("mailbox-capacity"), Helpers$ConfigOps$.MODULE$.getNanosDuration$extension(Helpers$.MODULE$.ConfigOps(config), "mailbox-push-timeout-time"));
    }

    @Override
    public akka.dispatch.MessageQueue create(Option<ActorRef> owner, Option<ActorSystem> system) {
        return new MessageQueue(this.capacity(), this.pushTimeOut());
    }

    public BoundedControlAwareMailbox copy(int capacity, FiniteDuration pushTimeOut) {
        return new BoundedControlAwareMailbox(capacity, pushTimeOut);
    }

    public int copy$default$1() {
        return this.capacity();
    }

    public FiniteDuration copy$default$2() {
        return this.pushTimeOut();
    }

    public int _1() {
        return this.capacity();
    }

    public FiniteDuration _2() {
        return this.pushTimeOut();
    }

    public static class MessageQueue
    implements QueueBasedMessageQueue,
    ControlAwareMessageQueueSemantics,
    BoundedControlAwareMessageQueueSemantics,
    Serializable {
        private final int capacity;
        private final FiniteDuration pushTimeOut;
        private final AtomicInteger size;
        private final ReentrantLock putLock;
        private final Condition notFull;
        private final Queue controlQueue;
        private final Queue queue;

        public MessageQueue(int capacity, FiniteDuration pushTimeOut) {
            this.capacity = capacity;
            this.pushTimeOut = pushTimeOut;
            this.size = new AtomicInteger(0);
            this.putLock = new ReentrantLock();
            this.notFull = this.putLock.newCondition();
            this.controlQueue = new ConcurrentLinkedQueue();
            this.queue = new ConcurrentLinkedQueue();
        }

        public int capacity() {
            return this.capacity;
        }

        public FiniteDuration pushTimeOut() {
            return this.pushTimeOut;
        }

        @Override
        public Queue<Envelope> controlQueue() {
            return this.controlQueue;
        }

        @Override
        public Queue<Envelope> queue() {
            return this.queue;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void enqueue(ActorRef receiver, Envelope handle) {
            Envelope envelope = handle;
            if (envelope != null) {
                Envelope envelope2 = Envelope$.MODULE$.unapply(envelope);
                Object object = envelope2._1();
                ActorRef actorRef = envelope2._2();
                if (object instanceof ControlMessage) {
                    Envelope envelope3 = envelope;
                    this.enqueueWithTimeout(this.controlQueue(), receiver, envelope3);
                    return;
                }
            }
            Envelope envelope4 = envelope;
            this.enqueueWithTimeout(this.queue(), receiver, envelope4);
        }

        @Override
        public int numberOfMessages() {
            return this.size.get();
        }

        @Override
        public boolean hasMessages() {
            return this.numberOfMessages() > 0;
        }

        @Override
        public final Envelope dequeue() {
            return this.tailrecDequeue$1();
        }

        private void signalNotFull() {
            this.putLock.lock();
            try {
                this.notFull.signal();
            }
            finally {
                this.putLock.unlock();
            }
        }

        private final void enqueueWithTimeout(Queue<Envelope> q, ActorRef receiver, Envelope envelope) {
            boolean bl;
            long remaining = this.pushTimeOut().toNanos();
            this.putLock.lockInterruptibly();
            try {
                boolean stop = false;
                while (this.size.get() == this.capacity() && !stop) {
                    stop = (remaining = this.notFull.awaitNanos(remaining)) <= 0L;
                }
                if (stop) {
                    bl = false;
                } else {
                    q.add(envelope);
                    int c = this.size.incrementAndGet();
                    if (c < this.capacity()) {
                        this.notFull.signal();
                    }
                    bl = true;
                }
            }
            finally {
                this.putLock.unlock();
            }
            boolean inserted = bl;
            if (!inserted) {
                ((InternalActorRef)receiver).provider().deadLetters().tell(DeadLetter$.MODULE$.apply(envelope.message(), envelope.sender(), receiver), envelope.sender());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Envelope tailrecDequeue$1() {
            Envelope envelope;
            block2: {
                int count;
                while ((count = this.size.get()) > 0) {
                    void var2_2;
                    if (!this.size.compareAndSet(count, count - 1)) continue;
                    Envelope item = ControlAwareMessageQueueSemantics.dequeue$(this);
                    if (this.size.get() < this.capacity()) {
                        this.signalNotFull();
                    }
                    envelope = var2_2;
                    break block2;
                }
                envelope = null;
            }
            return envelope;
        }
    }
}

