/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.BoundedDequeBasedMailbox$;
import akka.dispatch.BoundedDequeBasedMessageQueue;
import akka.dispatch.Envelope;
import akka.dispatch.MailboxType;
import akka.dispatch.ProducesMessageQueue;
import akka.dispatch.ProducesPushTimeoutSemanticsMailbox;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingDeque;
import scala.Option;
import scala.Product;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class BoundedDequeBasedMailbox
implements MailboxType,
ProducesMessageQueue<MessageQueue>,
ProducesPushTimeoutSemanticsMailbox,
Product,
Serializable {
    private final int capacity;
    private final FiniteDuration pushTimeOut;

    public static BoundedDequeBasedMailbox apply(int n, FiniteDuration finiteDuration) {
        return BoundedDequeBasedMailbox$.MODULE$.apply(n, finiteDuration);
    }

    public static BoundedDequeBasedMailbox fromProduct(Product product) {
        return BoundedDequeBasedMailbox$.MODULE$.fromProduct(product);
    }

    public static BoundedDequeBasedMailbox unapply(BoundedDequeBasedMailbox boundedDequeBasedMailbox) {
        return BoundedDequeBasedMailbox$.MODULE$.unapply(boundedDequeBasedMailbox);
    }

    public BoundedDequeBasedMailbox(int capacity, FiniteDuration pushTimeOut) {
        this.capacity = capacity;
        this.pushTimeOut = pushTimeOut;
        if (capacity < 0) {
            throw new IllegalArgumentException("The capacity for BoundedDequeBasedMailbox can not be negative");
        }
        if (pushTimeOut == null) {
            throw new IllegalArgumentException("The push time-out for BoundedDequeBasedMailbox can not be null");
        }
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.capacity());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pushTimeOut()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BoundedDequeBasedMailbox)) return false;
        BoundedDequeBasedMailbox boundedDequeBasedMailbox = (BoundedDequeBasedMailbox)object;
        if (this.capacity() != boundedDequeBasedMailbox.capacity()) return false;
        FiniteDuration finiteDuration = this.pushTimeOut();
        FiniteDuration finiteDuration2 = boundedDequeBasedMailbox.pushTimeOut();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!finiteDuration.equals(finiteDuration2)) return false;
        if (!boundedDequeBasedMailbox.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BoundedDequeBasedMailbox;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "BoundedDequeBasedMailbox";
    }

    public Object productElement(int n) {
        Integer n2;
        int n3 = n;
        if (0 == n3) {
            n2 = BoxesRunTime.boxToInteger((int)this._1());
        } else if (1 == n3) {
            n2 = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return n2;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "capacity";
        } else if (1 == n2) {
            string = "pushTimeOut";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final FiniteDuration pushTimeOut() {
        return this.pushTimeOut;
    }

    public BoundedDequeBasedMailbox(ActorSystem.Settings settings, Config config) {
        this(config.getInt("mailbox-capacity"), Helpers$ConfigOps$.MODULE$.getNanosDuration$extension(Helpers$.MODULE$.ConfigOps(config), "mailbox-push-timeout-time"));
    }

    @Override
    public final akka.dispatch.MessageQueue create(Option<ActorRef> owner, Option<ActorSystem> system) {
        return new MessageQueue(this.capacity(), this.pushTimeOut());
    }

    public BoundedDequeBasedMailbox copy(int capacity, FiniteDuration pushTimeOut) {
        return new BoundedDequeBasedMailbox(capacity, pushTimeOut);
    }

    public int copy$default$1() {
        return this.capacity();
    }

    public FiniteDuration copy$default$2() {
        return this.pushTimeOut();
    }

    public int _1() {
        return this.capacity();
    }

    public FiniteDuration _2() {
        return this.pushTimeOut();
    }

    public static class MessageQueue
    extends LinkedBlockingDeque<Envelope>
    implements BoundedDequeBasedMessageQueue {
        private final FiniteDuration pushTimeOut;
        private final MessageQueue queue;

        public MessageQueue(int capacity, FiniteDuration pushTimeOut) {
            this.pushTimeOut = pushTimeOut;
            super(capacity);
            this.queue = this;
        }

        public FiniteDuration pushTimeOut() {
            return this.pushTimeOut;
        }

        public final MessageQueue queue() {
            return this.queue;
        }
    }
}

