/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.BoundedQueueBasedMessageQueue;
import akka.dispatch.Envelope;
import akka.dispatch.MailboxType;
import akka.dispatch.ProducesMessageQueue;
import akka.dispatch.ProducesPushTimeoutSemanticsMailbox;
import akka.util.BoundedBlockingQueue;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import scala.Option;
import scala.concurrent.duration.Duration;

public class BoundedPriorityMailbox
implements MailboxType,
ProducesMessageQueue<MessageQueue>,
ProducesPushTimeoutSemanticsMailbox {
    private final Comparator cmp;
    private final int capacity;
    private final Duration pushTimeOut;

    public BoundedPriorityMailbox(Comparator<Envelope> cmp, int capacity, Duration pushTimeOut) {
        this.cmp = cmp;
        this.capacity = capacity;
        this.pushTimeOut = pushTimeOut;
        if (capacity < 0) {
            throw new IllegalArgumentException("The capacity for BoundedMailbox can not be negative");
        }
        if (pushTimeOut == null) {
            throw new IllegalArgumentException("The push time-out for BoundedMailbox can not be null");
        }
    }

    public final Comparator<Envelope> cmp() {
        return this.cmp;
    }

    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final Duration pushTimeOut() {
        return this.pushTimeOut;
    }

    @Override
    public final akka.dispatch.MessageQueue create(Option<ActorRef> owner, Option<ActorSystem> system) {
        return new MessageQueue(this.capacity(), this.cmp(), this.pushTimeOut());
    }

    public static class MessageQueue
    extends BoundedBlockingQueue<Envelope>
    implements BoundedQueueBasedMessageQueue {
        private final Duration pushTimeOut;

        public MessageQueue(int capacity, Comparator<Envelope> cmp, Duration pushTimeOut) {
            this.pushTimeOut = pushTimeOut;
            super(capacity, new PriorityQueue<Envelope>(11, cmp));
        }

        @Override
        public Duration pushTimeOut() {
            return this.pushTimeOut;
        }

        @Override
        public final BlockingQueue<Envelope> queue() {
            return this;
        }
    }
}

