/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.actor.ActorCell;
import akka.actor.Cell;
import akka.dispatch.DefaultSystemMessageQueue;
import akka.dispatch.Envelope;
import akka.dispatch.ExecutorServiceDelegate;
import akka.dispatch.ExecutorServiceFactory;
import akka.dispatch.ExecutorServiceFactoryProvider;
import akka.dispatch.Mailbox;
import akka.dispatch.MailboxType;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.MessageDispatcherConfigurator;
import akka.dispatch.TaskInvocation;
import akka.dispatch.sysmsg.SystemMessage;
import akka.event.Logging$;
import akka.event.Logging$Error$;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.LazyVals$;

public class Dispatcher
extends MessageDispatcher {
    private final String id;
    private final int throughput;
    private final Duration throughputDeadlineTime;
    private final FiniteDuration shutdownTimeout;
    private volatile LazyExecutorServiceDelegate executorServiceDelegate;
    private final AtomicReferenceFieldUpdater<Dispatcher, LazyExecutorServiceDelegate> esUpdater;
    private final String toString;

    public Dispatcher(MessageDispatcherConfigurator _configurator, String id, int throughput, Duration throughputDeadlineTime, ExecutorServiceFactoryProvider executorServiceFactoryProvider, FiniteDuration shutdownTimeout) {
        this.id = id;
        this.throughput = throughput;
        this.throughputDeadlineTime = throughputDeadlineTime;
        this.shutdownTimeout = shutdownTimeout;
        super(_configurator);
        this.executorServiceDelegate = new LazyExecutorServiceDelegate(this, executorServiceFactoryProvider.createExecutorServiceFactory(id, this.configurator().prerequisites().threadFactory()));
        this.esUpdater = AtomicReferenceFieldUpdater.newUpdater(Dispatcher.class, LazyExecutorServiceDelegate.class, "executorServiceDelegate");
        this.toString = new StringBuilder(2).append(Logging$.MODULE$.simpleName(this)).append("[").append(id).append("]").toString();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public int throughput() {
        return this.throughput;
    }

    @Override
    public Duration throughputDeadlineTime() {
        return this.throughputDeadlineTime;
    }

    @Override
    public FiniteDuration shutdownTimeout() {
        return this.shutdownTimeout;
    }

    public final ExecutorServiceDelegate executorService() {
        return this.executorServiceDelegate;
    }

    @Override
    public void dispatch(ActorCell receiver, Envelope invocation) {
        Mailbox mbox = receiver.mailbox();
        mbox.enqueue(receiver.self(), invocation);
        this.registerForExecution(mbox, true, false);
    }

    @Override
    public void systemDispatch(ActorCell receiver, SystemMessage invocation) {
        Mailbox mbox = receiver.mailbox();
        mbox.systemEnqueue(receiver.self(), invocation);
        this.registerForExecution(mbox, false, true);
    }

    @Override
    public void executeTask(TaskInvocation invocation) {
        try {
            this.executorService().execute(invocation);
        }
        catch (RejectedExecutionException e) {
            try {
                this.executorService().execute(invocation);
            }
            catch (RejectedExecutionException e2) {
                this.eventStream().publish(Logging$Error$.MODULE$.apply(e, this.getClass().getName(), this.getClass(), "executeTask was rejected twice!"));
                throw e2;
            }
        }
    }

    @Override
    public Mailbox createMailbox(Cell actor, MailboxType mailboxType) {
        return new DefaultSystemMessageQueue(actor, mailboxType){};
    }

    @Override
    public void shutdown() {
        LazyExecutorServiceDelegate newDelegate = this.executorServiceDelegate.copy();
        LazyExecutorServiceDelegate es = this.esUpdater.getAndSet(this, newDelegate);
        es.shutdown();
    }

    @Override
    public boolean registerForExecution(Mailbox mbox, boolean hasMessageHint, boolean hasSystemMessageHint) {
        boolean bl;
        if (mbox.canBeScheduledForExecution(hasMessageHint, hasSystemMessageHint)) {
            if (mbox.setAsScheduled()) {
                try {
                    this.executorService().execute(mbox);
                    bl = true;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    try {
                        this.executorService().execute(mbox);
                        bl = true;
                    }
                    catch (RejectedExecutionException e) {
                        mbox.setAsIdle();
                        this.eventStream().publish(Logging$Error$.MODULE$.apply(e, this.getClass().getName(), this.getClass(), "registerForExecution was rejected twice!"));
                        throw e;
                    }
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return this.toString;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LazyExecutorServiceDelegate
    implements ExecutorServiceDelegate {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(LazyExecutorServiceDelegate.class, "0bitmap$1");
        public long 0bitmap$1;
        private final ExecutorServiceFactory factory;
        public ExecutorService executor$lzy1;
        private final Dispatcher $outer;

        public LazyExecutorServiceDelegate(Dispatcher $outer, ExecutorServiceFactory factory) {
            this.factory = factory;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public ExecutorService executor() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                    try {
                        ExecutorService executorService;
                        this.executor$lzy1 = executorService = this.factory.createExecutorService();
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                        return executorService;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
            }
            return this.executor$lzy1;
        }

        public LazyExecutorServiceDelegate copy() {
            return new LazyExecutorServiceDelegate(this.$outer, this.factory);
        }

        public final Dispatcher akka$dispatch$Dispatcher$LazyExecutorServiceDelegate$$$outer() {
            return this.$outer;
        }
    }
}

