/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.dispatch.DispatcherPrerequisites;
import akka.dispatch.ExecutorServiceConfigurator;
import akka.dispatch.ExecutorServiceFactory;
import akka.dispatch.LoadMetrics;
import akka.dispatch.MonitorableThreadFactory;
import akka.dispatch.MonitorableThreadFactory$;
import akka.dispatch.ThreadPoolConfig$;
import com.typesafe.config.Config;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ThreadFactory;
import scala.runtime.BoxedUnit;

public class ForkJoinExecutorConfigurator
extends ExecutorServiceConfigurator {
    private final Config config;

    public ForkJoinExecutorConfigurator(Config config, DispatcherPrerequisites prerequisites) {
        this.config = config;
        super(config, prerequisites);
    }

    public ForkJoinPool.ForkJoinWorkerThreadFactory validate(ThreadFactory t) {
        ThreadFactory threadFactory = t;
        if (!(threadFactory instanceof ForkJoinPool.ForkJoinWorkerThreadFactory)) {
            throw new IllegalStateException("The prerequisites for the ForkJoinExecutorConfigurator is a ForkJoinPool.ForkJoinWorkerThreadFactory!");
        }
        ForkJoinPool.ForkJoinWorkerThreadFactory correct = (ForkJoinPool.ForkJoinWorkerThreadFactory)((Object)threadFactory);
        return correct;
    }

    @Override
    public final ExecutorServiceFactory createExecutorServiceFactory(String id, ThreadFactory threadFactory) {
        boolean bl;
        ThreadFactory threadFactory2;
        ThreadFactory threadFactory3 = threadFactory;
        if (threadFactory3 instanceof MonitorableThreadFactory) {
            MonitorableThreadFactory m = (MonitorableThreadFactory)threadFactory3;
            threadFactory2 = m.withName(new StringBuilder(1).append(m.name()).append("-").append(id).toString());
        } else {
            ThreadFactory other;
            threadFactory2 = other = threadFactory3;
        }
        ThreadFactory tf = threadFactory2;
        String string = this.config.getString("task-peeking-mode");
        if ("FIFO".equals(string)) {
            bl = true;
        } else if ("LIFO".equals(string)) {
            bl = false;
        } else {
            throw new IllegalArgumentException("Cannot instantiate ForkJoinExecutorServiceFactory. \"task-peeking-mode\" in \"fork-join-executor\" section could only set to \"FIFO\" or \"LIFO\".");
        }
        boolean asyncMode = bl;
        return new ForkJoinExecutorServiceFactory(this, this.validate(tf), ThreadPoolConfig$.MODULE$.scaledPoolSize(this.config.getInt("parallelism-min"), this.config.getDouble("parallelism-factor"), this.config.getInt("parallelism-max")), asyncMode);
    }

    public static final class AkkaForkJoinPool
    extends ForkJoinPool
    implements LoadMetrics {
        public AkkaForkJoinPool(int parallelism, ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory, Thread.UncaughtExceptionHandler unhandledExceptionHandler, boolean asyncMode) {
            super(parallelism, threadFactory, unhandledExceptionHandler, asyncMode);
        }

        public AkkaForkJoinPool(int parallelism, ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory, Thread.UncaughtExceptionHandler unhandledExceptionHandler) {
            this(parallelism, threadFactory, unhandledExceptionHandler, true);
        }

        @Override
        public void execute(Runnable r) {
            if (r == null) {
                throw new NullPointerException("Runnable was null");
            }
            super.execute((ForkJoinTask)(r instanceof ForkJoinTask ? r : new AkkaForkJoinTask(r)));
        }

        @Override
        public boolean atFullThrottle() {
            return this.getActiveThreadCount() >= this.getParallelism();
        }
    }

    public static final class AkkaForkJoinTask
    extends ForkJoinTask<BoxedUnit> {
        private static final long serialVersionUID = 1L;
        private final Runnable runnable;

        public AkkaForkJoinTask(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void getRawResult() {
        }

        @Override
        public void setRawResult(BoxedUnit unit) {
        }

        @Override
        public boolean exec() {
            boolean bl;
            try {
                this.runnable.run();
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                bl = false;
            }
            catch (Throwable anything) {
                Thread t = Thread.currentThread();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = t.getUncaughtExceptionHandler();
                if (uncaughtExceptionHandler != null) {
                    Thread.UncaughtExceptionHandler some = uncaughtExceptionHandler;
                    some.uncaughtException(t, anything);
                }
                throw anything;
            }
            return bl;
        }
    }

    public class ForkJoinExecutorServiceFactory
    implements ExecutorServiceFactory {
        private final ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory;
        private final int parallelism;
        private final boolean asyncMode;
        private final ForkJoinExecutorConfigurator $outer;

        public ForkJoinExecutorServiceFactory(ForkJoinExecutorConfigurator $outer, ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory, int parallelism, boolean asyncMode) {
            this.threadFactory = threadFactory;
            this.parallelism = parallelism;
            this.asyncMode = asyncMode;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public int parallelism() {
            return this.parallelism;
        }

        public boolean asyncMode() {
            return this.asyncMode;
        }

        public ForkJoinExecutorServiceFactory(ForkJoinExecutorConfigurator $outer, ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory, int parallelism) {
            this($outer, threadFactory, parallelism, true);
        }

        @Override
        public ExecutorService createExecutorService() {
            return new AkkaForkJoinPool(this.parallelism(), this.threadFactory(), MonitorableThreadFactory$.MODULE$.doNothing(), this.asyncMode());
        }

        public final ForkJoinExecutorConfigurator akka$dispatch$ForkJoinExecutorConfigurator$ForkJoinExecutorServiceFactory$$$outer() {
            return this.$outer;
        }
    }
}

