/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.dispatch.DispatcherPrerequisites;
import akka.dispatch.ExecutorServiceConfigurator;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.MessageDispatcherConfigurator;
import akka.dispatch.PinnedDispatcher;
import akka.dispatch.ThreadPoolConfig;
import akka.dispatch.ThreadPoolConfig$;
import akka.dispatch.ThreadPoolExecutorConfigurator;
import akka.event.Logging$Warning$;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import com.typesafe.config.Config;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class PinnedDispatcherConfigurator
extends MessageDispatcherConfigurator {
    private final Config config;
    private final ThreadPoolConfig threadPoolConfig;

    public PinnedDispatcherConfigurator(Config config, DispatcherPrerequisites prerequisites) {
        ThreadPoolConfig threadPoolConfig;
        this.config = config;
        super(config, prerequisites);
        ExecutorServiceConfigurator executorServiceConfigurator = this.configureExecutor();
        if (executorServiceConfigurator instanceof ThreadPoolExecutorConfigurator) {
            ThreadPoolExecutorConfigurator e = (ThreadPoolExecutorConfigurator)executorServiceConfigurator;
            threadPoolConfig = e.threadPoolConfig();
        } else {
            prerequisites.eventStream().publish(Logging$Warning$.MODULE$.apply("PinnedDispatcherConfigurator", this.getClass(), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("PinnedDispatcher [%s] not configured to use ThreadPoolExecutor, falling back to default config."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{config.getString("id")}))));
            threadPoolConfig = ThreadPoolConfig$.MODULE$.apply(ThreadPoolConfig$.MODULE$.$lessinit$greater$default$1(), ThreadPoolConfig$.MODULE$.$lessinit$greater$default$2(), ThreadPoolConfig$.MODULE$.$lessinit$greater$default$3(), ThreadPoolConfig$.MODULE$.$lessinit$greater$default$4(), ThreadPoolConfig$.MODULE$.$lessinit$greater$default$5(), ThreadPoolConfig$.MODULE$.$lessinit$greater$default$6());
        }
        this.threadPoolConfig = threadPoolConfig;
    }

    private DispatcherPrerequisites prerequisites$accessor() {
        return super.prerequisites();
    }

    @Override
    public MessageDispatcher dispatcher() {
        return new PinnedDispatcher(this, null, this.config.getString("id"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.config), "shutdown-timeout"), this.threadPoolConfig);
    }
}

