/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.dispatch.SaneRejectedExecutionHandler;
import akka.dispatch.ThreadPoolConfig;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Predef$;
import scala.Product;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.deriving.Mirror;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;

public final class ThreadPoolConfig$
implements Mirror.Product,
Serializable {
    private static final boolean defaultAllowCoreThreadTimeout;
    private static final int defaultCorePoolSize;
    private static final int defaultMaxPoolSize;
    private static final Duration defaultTimeout;
    private static final RejectedExecutionHandler defaultRejectionPolicy;
    public static final ThreadPoolConfig$ MODULE$;

    private ThreadPoolConfig$() {
    }

    static {
        MODULE$ = new ThreadPoolConfig$();
        defaultAllowCoreThreadTimeout = false;
        defaultCorePoolSize = 16;
        defaultMaxPoolSize = 128;
        defaultTimeout = Duration$.MODULE$.apply(60000L, TimeUnit.MILLISECONDS);
        defaultRejectionPolicy = new SaneRejectedExecutionHandler();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ThreadPoolConfig$.class);
    }

    public ThreadPoolConfig apply(boolean allowCorePoolTimeout, int corePoolSize, int maxPoolSize, Duration threadTimeout, Function0<BlockingQueue<Runnable>> queueFactory, RejectedExecutionHandler rejectionPolicy) {
        return new ThreadPoolConfig(allowCorePoolTimeout, corePoolSize, maxPoolSize, threadTimeout, queueFactory, rejectionPolicy);
    }

    public ThreadPoolConfig unapply(ThreadPoolConfig x$1) {
        return x$1;
    }

    public String toString() {
        return "ThreadPoolConfig";
    }

    public boolean $lessinit$greater$default$1() {
        return this.defaultAllowCoreThreadTimeout();
    }

    public int $lessinit$greater$default$2() {
        return this.defaultCorePoolSize();
    }

    public int $lessinit$greater$default$3() {
        return this.defaultMaxPoolSize();
    }

    public Duration $lessinit$greater$default$4() {
        return this.defaultTimeout();
    }

    public Function0<BlockingQueue<Runnable>> $lessinit$greater$default$5() {
        return this.linkedBlockingQueue();
    }

    public RejectedExecutionHandler $lessinit$greater$default$6() {
        return this.defaultRejectionPolicy();
    }

    public boolean defaultAllowCoreThreadTimeout() {
        return defaultAllowCoreThreadTimeout;
    }

    public int defaultCorePoolSize() {
        return defaultCorePoolSize;
    }

    public int defaultMaxPoolSize() {
        return defaultMaxPoolSize;
    }

    public Duration defaultTimeout() {
        return defaultTimeout;
    }

    public RejectedExecutionHandler defaultRejectionPolicy() {
        return defaultRejectionPolicy;
    }

    public int scaledPoolSize(int floor, double multiplier, int ceiling) {
        return package$.MODULE$.min(package$.MODULE$.max((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)Runtime.getRuntime().availableProcessors() * multiplier)), floor), ceiling);
    }

    public Function0<BlockingQueue<Runnable>> arrayBlockingQueue(int capacity, boolean fair) {
        return (Function0 & Serializable)() -> new ArrayBlockingQueue(capacity, fair);
    }

    public Function0<BlockingQueue<Runnable>> synchronousQueue(boolean fair) {
        return (Function0 & Serializable)() -> new SynchronousQueue(fair);
    }

    public Function0<BlockingQueue<Runnable>> linkedBlockingQueue() {
        return (Function0 & Serializable)() -> new LinkedBlockingQueue();
    }

    public Function0<BlockingQueue<Runnable>> linkedBlockingQueue(int capacity) {
        return (Function0 & Serializable)() -> new LinkedBlockingQueue(capacity);
    }

    public Function0<BlockingQueue<Runnable>> reusableQueue(BlockingQueue<Runnable> queue) {
        return (Function0 & Serializable)() -> queue;
    }

    public Function0<BlockingQueue<Runnable>> reusableQueue(Function0<BlockingQueue<Runnable>> queueFactory) {
        return this.reusableQueue((BlockingQueue)queueFactory.apply());
    }

    public ThreadPoolConfig fromProduct(Product x$0) {
        return new ThreadPoolConfig(BoxesRunTime.unboxToBoolean((Object)x$0.productElement(0)), BoxesRunTime.unboxToInt((Object)x$0.productElement(1)), BoxesRunTime.unboxToInt((Object)x$0.productElement(2)), (Duration)x$0.productElement(3), (Function0<BlockingQueue<Runnable>>)((Function0)x$0.productElement(4)), (RejectedExecutionHandler)x$0.productElement(5));
    }
}

