/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch.affinity;

import akka.annotation.ApiMayChange;
import akka.annotation.InternalApi;
import akka.dispatch.DispatcherPrerequisites;
import akka.dispatch.ExecutorServiceConfigurator;
import akka.dispatch.ExecutorServiceFactory;
import akka.dispatch.MonitorableThreadFactory;
import akka.dispatch.ThreadPoolConfig$;
import akka.dispatch.affinity.AffinityPool;
import akka.dispatch.affinity.QueueSelectorFactory;
import akka.dispatch.affinity.RejectionHandlerFactory;
import akka.util.Helpers$;
import akka.util.Helpers$Requiring$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@InternalApi
@ApiMayChange
public final class AffinityPoolConfigurator
extends ExecutorServiceConfigurator {
    public final int akka$dispatch$affinity$AffinityPoolConfigurator$$poolSize;
    public final int akka$dispatch$affinity$AffinityPoolConfigurator$$taskQueueSize;
    public final int akka$dispatch$affinity$AffinityPoolConfigurator$$idleCpuLevel;
    public final String akka$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactoryFQCN;
    public final QueueSelectorFactory akka$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactory;
    public final String akka$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactoryFCQN;
    public final RejectionHandlerFactory akka$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactory;

    public AffinityPoolConfigurator(Config config, DispatcherPrerequisites prerequisites) {
        super(config, prerequisites);
        this.akka$dispatch$affinity$AffinityPoolConfigurator$$poolSize = ThreadPoolConfig$.MODULE$.scaledPoolSize(config.getInt("parallelism-min"), config.getDouble("parallelism-factor"), config.getInt("parallelism-max"));
        this.akka$dispatch$affinity$AffinityPoolConfigurator$$taskQueueSize = config.getInt("task-queue-size");
        Integer n = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger((int)config.getInt("idle-cpu-level")));
        this.akka$dispatch$affinity$AffinityPoolConfigurator$$idleCpuLevel = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n, (JFunction1.mcZI.sp & Serializable)level -> 1 <= level && level <= 10, (Function0<Object>)((Function0 & Serializable)AffinityPoolConfigurator::$init$$$anonfun$3)));
        this.akka$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactoryFQCN = config.getString("queue-selector");
        Object[] objectArray = new Tuple2[1];
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(Config.class);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)config);
        this.akka$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactory = (QueueSelectorFactory)prerequisites.dynamicAccess().createInstanceFor(this.akka$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactoryFQCN, (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), ClassTag$.MODULE$.apply(QueueSelectorFactory.class)).recover((PartialFunction)new Serializable(this){
            private final AffinityPoolConfigurator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                throw new IllegalArgumentException(new StringBuilder(134).append("Cannot instantiate QueueSelectorFactory(queueSelector = ").append(this.$outer.akka$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactoryFQCN).append("), make sure it has an accessible constructor which accepts a Config parameter").toString());
            }
        }).get();
        this.akka$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactoryFCQN = config.getString("rejection-handler");
        this.akka$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactory = (RejectionHandlerFactory)prerequisites.dynamicAccess().createInstanceFor(this.akka$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactoryFCQN, (Seq<Tuple2<Class<?>, Object>>)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(RejectionHandlerFactory.class)).recover((PartialFunction)new Serializable(this){
            private final AffinityPoolConfigurator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable exception = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable exception = throwable = x;
                throw new IllegalArgumentException(new StringBuilder(114).append("Cannot instantiate RejectionHandlerFactory(rejection-handler = ").append(this.$outer.akka$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactoryFCQN).append("), make sure it has an accessible empty constructor").toString(), exception);
            }
        }).get();
    }

    @Override
    public ExecutorServiceFactory createExecutorServiceFactory(String id, ThreadFactory threadFactory) {
        ThreadFactory threadFactory2;
        ThreadFactory threadFactory3 = threadFactory;
        if (threadFactory3 instanceof MonitorableThreadFactory) {
            MonitorableThreadFactory m = (MonitorableThreadFactory)threadFactory3;
            threadFactory2 = m.withName(new StringBuilder(1).append(m.name()).append("-").append(id).toString());
        } else {
            ThreadFactory other;
            threadFactory2 = other = threadFactory3;
        }
        ThreadFactory tf = threadFactory2;
        return new ExecutorServiceFactory(id, tf, this){
            private final String id$1;
            private final ThreadFactory tf$1;
            private final AffinityPoolConfigurator $outer;
            {
                this.id$1 = id$2;
                this.tf$1 = tf$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public ExecutorService createExecutorService() {
                return new AffinityPool(this.id$1, this.$outer.akka$dispatch$affinity$AffinityPoolConfigurator$$poolSize, this.$outer.akka$dispatch$affinity$AffinityPoolConfigurator$$taskQueueSize, this.tf$1, this.$outer.akka$dispatch$affinity$AffinityPoolConfigurator$$idleCpuLevel, this.$outer.akka$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactory.create(), this.$outer.akka$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactory.create()).start();
            }
        };
    }

    private static final String $init$$$anonfun$3() {
        return "idle-cpu-level must be between 1 and 10";
    }
}

