/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch.affinity;

import akka.annotation.ApiMayChange;
import akka.annotation.InternalApi;
import akka.dispatch.affinity.QueueSelector;
import akka.dispatch.affinity.QueueSelectorFactory;
import akka.util.Helpers$;
import akka.util.Helpers$Requiring$;
import akka.util.ImmutableIntMap;
import akka.util.ImmutableIntMap$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function0;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@InternalApi
@ApiMayChange
public final class FairDistributionHashCache
implements QueueSelectorFactory {
    private final Config config;
    public final int akka$dispatch$affinity$FairDistributionHashCache$$fairDistributionThreshold;

    public FairDistributionHashCache(Config config) {
        this.config = config;
        int MaxFairDistributionThreshold = 2048;
        Integer n = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger((int)config.getInt("fair-work-distribution.threshold")));
        this.akka$dispatch$affinity$FairDistributionHashCache$$fairDistributionThreshold = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n, (JFunction1.mcZI.sp & Serializable)thr -> 0 <= thr && thr <= 2048, (Function0<Object>)((Function0 & Serializable)FairDistributionHashCache::$init$$$anonfun$5)));
    }

    public Config config() {
        return this.config;
    }

    @Override
    public QueueSelector create() {
        return new QueueSelector(this){
            private final FairDistributionHashCache $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(ImmutableIntMap$.MODULE$.empty());
            }

            public String toString() {
                return new StringBuilder(55).append("FairDistributionHashCache(fairDistributionThreshold = ").append(this.$outer.akka$dispatch$affinity$FairDistributionHashCache$$fairDistributionThreshold).append(")").toString();
            }

            private final int improve(int h) {
                return Integer.MAX_VALUE & Integer.reverseBytes(h * -1640532531) * -1640532531;
            }

            public final int getQueue(Runnable command, int queues) {
                int runnableHash = command.hashCode();
                return this.$outer.akka$dispatch$affinity$FairDistributionHashCache$$fairDistributionThreshold == 0 ? this.improve(runnableHash) % queues : this.cacheLookup$1(queues, runnableHash, (ImmutableIntMap)this.get(), runnableHash);
            }

            private final int cacheLookup$1(int queues$1, int runnableHash$1, ImmutableIntMap prev, int hash) {
                int n;
                ImmutableIntMap immutableIntMap = prev;
                while (true) {
                    int existingIndex;
                    if ((existingIndex = immutableIntMap.get(runnableHash$1)) >= 0) {
                        n = existingIndex;
                        break;
                    }
                    if (immutableIntMap.size() > this.$outer.akka$dispatch$affinity$FairDistributionHashCache$$fairDistributionThreshold) {
                        n = this.improve(hash) % queues$1;
                        break;
                    }
                    int index = immutableIntMap.size() % queues$1;
                    if (this.compareAndSet(immutableIntMap, immutableIntMap.updated(runnableHash$1, index))) {
                        n = index;
                        break;
                    }
                    immutableIntMap = (ImmutableIntMap)this.get();
                }
                return n;
            }
        };
    }

    private static final String $init$$$anonfun$5() {
        return new StringBuilder(69).append("fair-work-distribution.threshold must be between 0 and ").append(2048).toString();
    }
}

