/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.event.DefaultLoggingFilter;
import akka.event.Logging;
import akka.event.Logging$Debug$;
import akka.event.Logging$Error$;
import akka.event.Logging$Info$;
import akka.event.Logging$Warning$;
import akka.event.LoggingAdapter;
import akka.event.LoggingBus;
import akka.event.LoggingFilter;
import java.io.Serializable;
import scala.Function0;
import scala.collection.immutable.Map;

public class BusLogging
implements LoggingAdapter {
    private final LoggingBus bus;
    private final String logSource;
    private final Class logClass;
    private final LoggingFilter loggingFilter;

    public BusLogging(LoggingBus bus, String logSource, Class<?> logClass, LoggingFilter loggingFilter) {
        this.bus = bus;
        this.logSource = logSource;
        this.logClass = logClass;
        this.loggingFilter = loggingFilter;
    }

    public LoggingBus bus() {
        return this.bus;
    }

    public String logSource() {
        return this.logSource;
    }

    public Class<?> logClass() {
        return this.logClass;
    }

    public BusLogging(LoggingBus bus, String logSource, Class<?> logClass) {
        this(bus, logSource, logClass, BusLogging.BusLogging$superArg$1(bus, logSource, logClass));
    }

    @Override
    public boolean isErrorEnabled() {
        return this.loggingFilter.isErrorEnabled(this.logClass(), this.logSource());
    }

    @Override
    public boolean isWarningEnabled() {
        return this.loggingFilter.isWarningEnabled(this.logClass(), this.logSource());
    }

    @Override
    public boolean isInfoEnabled() {
        return this.loggingFilter.isInfoEnabled(this.logClass(), this.logSource());
    }

    @Override
    public boolean isDebugEnabled() {
        return this.loggingFilter.isDebugEnabled(this.logClass(), this.logSource());
    }

    @Override
    public void notifyError(String message) {
        this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), (Object)message, (Map<String, Object>)this.mdc()));
    }

    @Override
    public void notifyError(Throwable cause, String message) {
        this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc()));
    }

    @Override
    public void notifyWarning(String message) {
        this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc()));
    }

    @Override
    public void notifyInfo(String message) {
        this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc()));
    }

    @Override
    public void notifyDebug(String message) {
        this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc()));
    }

    private static DefaultLoggingFilter BusLogging$superArg$1(LoggingBus bus, String logSource, Class<?> logClass) {
        return new DefaultLoggingFilter((Function0<Logging.LogLevel>)(Function0 & Serializable)() -> new Logging.LogLevel(bus.logLevel()));
    }
}

