/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.actor.Actor;
import akka.actor.ActorSelectionMessage;
import akka.actor.ActorSelectionMessage$;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.SelectionPathElement;
import akka.annotation.InternalApi;
import akka.event.BusLogging;
import akka.event.DiagnosticLoggingAdapter;
import akka.event.DiagnosticMarkerBusLoggingAdapter;
import akka.event.LogSource;
import akka.event.LogSource$;
import akka.event.Logging;
import akka.event.Logging$Debug$;
import akka.event.Logging$Error$;
import akka.event.Logging$Error$NoCause$;
import akka.event.Logging$Error2$;
import akka.event.Logging$Info$;
import akka.event.Logging$InitializeLogger$;
import akka.event.Logging$LogEvent$;
import akka.event.Logging$LogExt$;
import akka.event.Logging$LogLevel$;
import akka.event.Logging$LoggerInitialized$;
import akka.event.Logging$StdOutLogger$;
import akka.event.Logging$Warning$;
import akka.event.LoggingAdapter;
import akka.event.LoggingBus;
import akka.event.MarkerLoggingAdapter;
import akka.util.Helpers$;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NoStackTrace;

public final class Logging$
implements Serializable {
    public static final Logging$LogExt$ LogExt;
    public static final Logging$LogLevel$ LogLevel;
    private static final int ErrorLevel;
    private static final int WarningLevel;
    private static final int InfoLevel;
    private static final int DebugLevel;
    @InternalApi
    private static final int OffLevel;
    private static final Seq AllLogLevels;
    public static final Logging$LogEvent$ LogEvent;
    public static final Logging$Error2$ Error2;
    public static final Logging$Error$ Error;
    public static final Logging$Warning$ Warning;
    public static final Logging$Info$ Info;
    public static final Logging$Debug$ Debug;
    public static final Logging$InitializeLogger$ InitializeLogger;
    public static final Logging$LoggerInitialized$ LoggerInitialized;
    public static final Logging$StdOutLogger$ StdOutLogger;
    public static final Logging.SerializedStandardOutLogger akka$event$Logging$$$serializedStandardOutLogger;
    private static final Logging.StandardOutLogger StandardOutLogger;
    private static final Map emptyMDC;
    public static final Logging$ MODULE$;

    private Logging$() {
    }

    static {
        MODULE$ = new Logging$();
        ErrorLevel = Logging$LogLevel$.MODULE$.apply(1);
        WarningLevel = Logging$LogLevel$.MODULE$.apply(2);
        InfoLevel = Logging$LogLevel$.MODULE$.apply(3);
        DebugLevel = Logging$LogLevel$.MODULE$.apply(4);
        OffLevel = Logging$LogLevel$.MODULE$.apply(Integer.MIN_VALUE);
        AllLogLevels = (Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Logging.LogLevel[]{new Logging.LogLevel(MODULE$.ErrorLevel()), new Logging.LogLevel(MODULE$.WarningLevel()), new Logging.LogLevel(MODULE$.InfoLevel()), new Logging.LogLevel(MODULE$.DebugLevel())}));
        akka$event$Logging$$$serializedStandardOutLogger = new Logging.SerializedStandardOutLogger();
        StandardOutLogger = new Logging.StandardOutLogger();
        emptyMDC = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Logging$.class);
    }

    public String simpleName(Object obj) {
        return this.simpleName(obj.getClass());
    }

    public String simpleName(Class<?> clazz) {
        String n = clazz.getName();
        int i = n.lastIndexOf(46);
        return n.substring(i + 1);
    }

    public String messageClassName(Object message) {
        String string;
        Object object = message;
        if (object == null) {
            string = "null";
        } else if (object instanceof ActorSelectionMessage) {
            ActorSelectionMessage actorSelectionMessage = ActorSelectionMessage$.MODULE$.unapply((ActorSelectionMessage)object);
            Object object2 = actorSelectionMessage._1();
            Iterable<SelectionPathElement> iterable = actorSelectionMessage._2();
            boolean bl = actorSelectionMessage._3();
            Object m = object2;
            string = new StringBuilder(23).append("ActorSelectionMessage(").append(m.getClass().getName()).append(")").toString();
        } else {
            Object m = object;
            string = m.getClass().getName();
        }
        return string;
    }

    public final int ErrorLevel() {
        return ErrorLevel;
    }

    public final int WarningLevel() {
        return WarningLevel;
    }

    public final int InfoLevel() {
        return InfoLevel;
    }

    public final int DebugLevel() {
        return DebugLevel;
    }

    public final int OffLevel() {
        return OffLevel;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<Logging.LogLevel> levelFor(String s) {
        None$ none$;
        String string = Helpers$.MODULE$.toRootLowerCase(s);
        switch (string == null ? 0 : string.hashCode()) {
            case 109935: {
                if (!"off".equals(string)) break;
                none$ = Some$.MODULE$.apply((Object)new Logging.LogLevel(this.OffLevel()));
                return none$;
            }
            case 3237038: {
                if (!"info".equals(string)) break;
                none$ = Some$.MODULE$.apply((Object)new Logging.LogLevel(this.InfoLevel()));
                return none$;
            }
            case 95458899: {
                if (!"debug".equals(string)) break;
                none$ = Some$.MODULE$.apply((Object)new Logging.LogLevel(this.DebugLevel()));
                return none$;
            }
            case 96784904: {
                if (!"error".equals(string)) break;
                none$ = Some$.MODULE$.apply((Object)new Logging.LogLevel(this.ErrorLevel()));
                return none$;
            }
            case 1124446108: {
                if (!"warning".equals(string)) break;
                none$ = Some$.MODULE$.apply((Object)new Logging.LogLevel(this.WarningLevel()));
                return none$;
            }
        }
        none$ = None$.MODULE$;
        return none$;
    }

    public int levelFor(Class<? extends Logging.LogEvent> eventClass) {
        return Logging.Error.class.isAssignableFrom(eventClass) ? this.ErrorLevel() : (Logging.Warning.class.isAssignableFrom(eventClass) ? this.WarningLevel() : (Logging.Info.class.isAssignableFrom(eventClass) ? this.InfoLevel() : (Logging.Debug.class.isAssignableFrom(eventClass) ? this.DebugLevel() : this.DebugLevel())));
    }

    public Class<? extends Logging.LogEvent> classFor(int level) {
        Class clazz;
        int n = level;
        if (this.ErrorLevel() == n) {
            clazz = Logging.Error.class;
        } else if (this.WarningLevel() == n) {
            clazz = Logging.Warning.class;
        } else if (this.InfoLevel() == n) {
            clazz = Logging.Info.class;
        } else if (this.DebugLevel() == n) {
            clazz = Logging.Debug.class;
        } else {
            int level2 = n;
            throw new IllegalArgumentException(new StringBuilder(24).append("Unsupported log level [").append(new Logging.LogLevel(level2)).append("]").toString());
        }
        return clazz;
    }

    public Seq<Logging.LogLevel> AllLogLevels() {
        return AllLogLevels;
    }

    public <T> LoggingAdapter apply(ActorSystem system, T logSource, LogSource<T> evidence$1) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple22._1();
        Class clazz2 = (Class)tuple22._2();
        return new BusLogging(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public <T> MarkerLoggingAdapter withMarker(ActorSystem system, T logSource, LogSource<T> evidence$2) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple22._1();
        Class clazz2 = (Class)tuple22._2();
        return new MarkerLoggingAdapter(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public <T> LoggingAdapter apply(LoggingBus bus, T logSource, LogSource<T> evidence$3) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$3);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple22._1();
        Class clazz2 = (Class)tuple22._2();
        return new BusLogging(bus, str2, clazz2);
    }

    public <T> MarkerLoggingAdapter withMarker(LoggingBus bus, T logSource, LogSource<T> evidence$4) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$4);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple22._1();
        Class clazz2 = (Class)tuple22._2();
        return new MarkerLoggingAdapter(bus, str2, clazz2);
    }

    public DiagnosticLoggingAdapter apply(Actor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple22._1();
        Class clazz2 = (Class)tuple22._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.context().system();
        return new DiagnosticLoggingAdapter(str2, clazz2, system){
            private Map akka$event$DiagnosticLoggingAdapter$$_mdc;
            {
                DiagnosticLoggingAdapter.$init$(this);
            }

            public Map akka$event$DiagnosticLoggingAdapter$$_mdc() {
                return this.akka$event$DiagnosticLoggingAdapter$$_mdc;
            }

            public void akka$event$DiagnosticLoggingAdapter$$_mdc_$eq(Map x$1) {
                this.akka$event$DiagnosticLoggingAdapter$$_mdc = x$1;
            }
        };
    }

    public DiagnosticMarkerBusLoggingAdapter withMarker(Actor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple22._1();
        Class clazz2 = (Class)tuple22._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.context().system();
        return new DiagnosticMarkerBusLoggingAdapter(system.eventStream(), str2, clazz2, system.logFilter());
    }

    public LoggingAdapter getLogger(ActorSystem system, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource, system);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple22._1();
        Class clazz2 = (Class)tuple22._2();
        return new BusLogging(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public LoggingAdapter getLogger(LoggingBus bus, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple22._1();
        Class clazz2 = (Class)tuple22._2();
        return new BusLogging(bus, str2, clazz2);
    }

    public DiagnosticLoggingAdapter getLogger(Actor logSource) {
        return this.apply(logSource);
    }

    public Logging$Error$NoCause$ noCause() {
        return Logging$Error$NoCause$.MODULE$;
    }

    public Logging$LoggerInitialized$ loggerInitialized() {
        return Logging$LoggerInitialized$.MODULE$;
    }

    public Logging.StandardOutLogger StandardOutLogger() {
        return StandardOutLogger;
    }

    public String stackTraceFor(Throwable e) {
        String string;
        Throwable throwable = e;
        if (throwable == null || Logging$Error$NoCause$.MODULE$.equals(throwable)) {
            string = "";
        } else if (throwable instanceof NoStackTrace) {
            string = new StringBuilder(5).append(" (").append(e.getClass().getName()).append(": ").append(e.getMessage()).append(")").toString();
        } else {
            Throwable other = throwable;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.append('\n');
            other.printStackTrace(pw);
            string = sw.toString();
        }
        return string;
    }

    public Map<String, Object> emptyMDC() {
        return emptyMDC;
    }
}

