/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.event.Logging;
import akka.event.Logging$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public interface LoggingAdapter {
    public static Map mdc$(LoggingAdapter $this) {
        return $this.mdc();
    }

    default public Map<String, Object> mdc() {
        return Logging$.MODULE$.emptyMDC();
    }

    public boolean isErrorEnabled();

    public boolean isWarningEnabled();

    public boolean isInfoEnabled();

    public boolean isDebugEnabled();

    public void notifyError(String var1);

    public void notifyError(Throwable var1, String var2);

    public void notifyWarning(String var1);

    public void notifyInfo(String var1);

    public void notifyDebug(String var1);

    public static void error$(LoggingAdapter $this, Throwable cause, String message) {
        $this.error(cause, message);
    }

    default public void error(Throwable cause, String message) {
        if (this.isErrorEnabled()) {
            this.notifyError(cause, message);
        }
    }

    public static void error$(LoggingAdapter $this, Throwable cause, String template, Object arg1) {
        $this.error(cause, template, arg1);
    }

    default public void error(Throwable cause, String template, Object arg1) {
        if (this.isErrorEnabled()) {
            this.notifyError(cause, this.format1(template, arg1));
        }
    }

    public static void error$(LoggingAdapter $this, Throwable cause, String template, Object arg1, Object arg2) {
        $this.error(cause, template, arg1, arg2);
    }

    default public void error(Throwable cause, String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.notifyError(cause, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    public static void error$(LoggingAdapter $this, Throwable cause, String template, Object arg1, Object arg2, Object arg3) {
        $this.error(cause, template, arg1, arg2, arg3);
    }

    default public void error(Throwable cause, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.notifyError(cause, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    public static void error$(LoggingAdapter $this, Throwable cause, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        $this.error(cause, template, arg1, arg2, arg3, arg4);
    }

    default public void error(Throwable cause, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isErrorEnabled()) {
            this.notifyError(cause, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    public static void error$(LoggingAdapter $this, String message) {
        $this.error(message);
    }

    default public void error(String message) {
        if (this.isErrorEnabled()) {
            this.notifyError(message);
        }
    }

    public static void error$(LoggingAdapter $this, String template, Object arg1) {
        $this.error(template, arg1);
    }

    default public void error(String template, Object arg1) {
        if (this.isErrorEnabled()) {
            this.notifyError(this.format1(template, arg1));
        }
    }

    public static void error$(LoggingAdapter $this, String template, Object arg1, Object arg2) {
        $this.error(template, arg1, arg2);
    }

    default public void error(String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.notifyError(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    public static void error$(LoggingAdapter $this, String template, Object arg1, Object arg2, Object arg3) {
        $this.error(template, arg1, arg2, arg3);
    }

    default public void error(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.notifyError(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    public static void error$(LoggingAdapter $this, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        $this.error(template, arg1, arg2, arg3, arg4);
    }

    default public void error(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isErrorEnabled()) {
            this.notifyError(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    public static void warning$(LoggingAdapter $this, String message) {
        $this.warning(message);
    }

    default public void warning(String message) {
        if (this.isWarningEnabled()) {
            this.notifyWarning(message);
        }
    }

    public static void warning$(LoggingAdapter $this, String template, Object arg1) {
        $this.warning(template, arg1);
    }

    default public void warning(String template, Object arg1) {
        if (this.isWarningEnabled()) {
            this.notifyWarning(this.format1(template, arg1));
        }
    }

    public static void warning$(LoggingAdapter $this, String template, Object arg1, Object arg2) {
        $this.warning(template, arg1, arg2);
    }

    default public void warning(String template, Object arg1, Object arg2) {
        if (this.isWarningEnabled()) {
            this.notifyWarning(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    public static void warning$(LoggingAdapter $this, String template, Object arg1, Object arg2, Object arg3) {
        $this.warning(template, arg1, arg2, arg3);
    }

    default public void warning(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isWarningEnabled()) {
            this.notifyWarning(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    public static void warning$(LoggingAdapter $this, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        $this.warning(template, arg1, arg2, arg3, arg4);
    }

    default public void warning(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isWarningEnabled()) {
            this.notifyWarning(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    public static void info$(LoggingAdapter $this, String message) {
        $this.info(message);
    }

    default public void info(String message) {
        if (this.isInfoEnabled()) {
            this.notifyInfo(message);
        }
    }

    public static void info$(LoggingAdapter $this, String template, Object arg1) {
        $this.info(template, arg1);
    }

    default public void info(String template, Object arg1) {
        if (this.isInfoEnabled()) {
            this.notifyInfo(this.format1(template, arg1));
        }
    }

    public static void info$(LoggingAdapter $this, String template, Object arg1, Object arg2) {
        $this.info(template, arg1, arg2);
    }

    default public void info(String template, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.notifyInfo(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    public static void info$(LoggingAdapter $this, String template, Object arg1, Object arg2, Object arg3) {
        $this.info(template, arg1, arg2, arg3);
    }

    default public void info(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled()) {
            this.notifyInfo(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    public static void info$(LoggingAdapter $this, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        $this.info(template, arg1, arg2, arg3, arg4);
    }

    default public void info(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isInfoEnabled()) {
            this.notifyInfo(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    public static void debug$(LoggingAdapter $this, String message) {
        $this.debug(message);
    }

    default public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.notifyDebug(message);
        }
    }

    public static void debug$(LoggingAdapter $this, String template, Object arg1) {
        $this.debug(template, arg1);
    }

    default public void debug(String template, Object arg1) {
        if (this.isDebugEnabled()) {
            this.notifyDebug(this.format1(template, arg1));
        }
    }

    public static void debug$(LoggingAdapter $this, String template, Object arg1, Object arg2) {
        $this.debug(template, arg1, arg2);
    }

    default public void debug(String template, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.notifyDebug(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    public static void debug$(LoggingAdapter $this, String template, Object arg1, Object arg2, Object arg3) {
        $this.debug(template, arg1, arg2, arg3);
    }

    default public void debug(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.notifyDebug(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    public static void debug$(LoggingAdapter $this, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        $this.debug(template, arg1, arg2, arg3, arg4);
    }

    default public void debug(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isDebugEnabled()) {
            this.notifyDebug(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    public static void log$(LoggingAdapter $this, int level, String message) {
        $this.log(level, message);
    }

    default public void log(int level, String message) {
        if (this.isEnabled(level)) {
            this.notifyLog(level, message);
        }
    }

    public static void log$(LoggingAdapter $this, int level, String template, Object arg1) {
        $this.log(level, template, arg1);
    }

    default public void log(int level, String template, Object arg1) {
        if (this.isEnabled(level)) {
            this.notifyLog(level, this.format1(template, arg1));
        }
    }

    public static void log$(LoggingAdapter $this, int level, String template, Object arg1, Object arg2) {
        $this.log(level, template, arg1, arg2);
    }

    default public void log(int level, String template, Object arg1, Object arg2) {
        if (this.isEnabled(level)) {
            this.notifyLog(level, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    public static void log$(LoggingAdapter $this, int level, String template, Object arg1, Object arg2, Object arg3) {
        $this.log(level, template, arg1, arg2, arg3);
    }

    default public void log(int level, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isEnabled(level)) {
            this.notifyLog(level, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    public static void log$(LoggingAdapter $this, int level, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        $this.log(level, template, arg1, arg2, arg3, arg4);
    }

    default public void log(int level, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isEnabled(level)) {
            this.notifyLog(level, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    public static boolean isEnabled$(LoggingAdapter $this, int level) {
        return $this.isEnabled(level);
    }

    default public boolean isEnabled(int level) {
        int n = level;
        return Logging$.MODULE$.ErrorLevel() == n ? this.isErrorEnabled() : (Logging$.MODULE$.WarningLevel() == n ? this.isWarningEnabled() : (Logging$.MODULE$.InfoLevel() == n ? this.isInfoEnabled() : (Logging$.MODULE$.DebugLevel() == n ? this.isDebugEnabled() : false)));
    }

    public static void notifyLog$(LoggingAdapter $this, int level, String message) {
        $this.notifyLog(level, message);
    }

    default public void notifyLog(int level, String message) {
        int n = level;
        if (Logging$.MODULE$.ErrorLevel() == n) {
            if (this.isErrorEnabled()) {
                this.notifyError(message);
            }
        } else if (Logging$.MODULE$.WarningLevel() == n) {
            if (this.isWarningEnabled()) {
                this.notifyWarning(message);
            }
        } else if (Logging$.MODULE$.InfoLevel() == n) {
            if (this.isInfoEnabled()) {
                this.notifyInfo(message);
            }
        } else if (Logging$.MODULE$.DebugLevel() == n) {
            if (this.isDebugEnabled()) {
                this.notifyDebug(message);
            }
        } else {
            int level2 = n;
            throw new IllegalArgumentException(new StringBuilder(24).append("Unsupported log level [").append(new Logging.LogLevel(level2)).append("]").toString());
        }
    }

    private String format1(String t, Object arg) {
        String string;
        Object a;
        Object object = arg;
        if (ScalaRunTime$.MODULE$.isArray(object, 1) && !(a = object).getClass().getComponentType().isPrimitive()) {
            Object object2 = Predef$.MODULE$.genericArrayOps(a);
            string = this.formatImpl(t, (Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(object2));
        } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object a2 = object;
            Object object3 = Predef$.MODULE$.genericArrayOps(a2);
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$4 -> _$4, ClassTag$.MODULE$.apply(Object.class)));
            string = this.formatImpl(t, (Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(object4));
        } else {
            Object x = object;
            string = this.format(t, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x}));
        }
        return string;
    }

    public static String format$(LoggingAdapter $this, String t, Seq arg) {
        return $this.format(t, (Seq<Object>)arg);
    }

    default public String format(String t, Seq<Object> arg) {
        return this.formatImpl(t, arg);
    }

    private String formatImpl(String t, Seq<Object> arg) {
        StringBuilder sb = new StringBuilder(64);
        int p = 0;
        int startIndex = 0;
        while (p < arg.length()) {
            int index = t.indexOf("{}", startIndex);
            if (index == -1) {
                sb.append(t.substring(startIndex, t.length())).append(" WARNING arguments left: ").append(arg.length() - p);
                p = arg.length();
                startIndex = t.length();
                continue;
            }
            sb.append(t.substring(startIndex, index)).append(arg.apply(p));
            startIndex = index + 2;
            ++p;
        }
        return sb.append(t.substring(startIndex, t.length())).toString();
    }
}

