/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.ConfigurationException;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystemImpl;
import akka.actor.InternalActorRef;
import akka.actor.InvalidActorNameException;
import akka.actor.Props$;
import akka.actor.UnhandledMessage;
import akka.actor.UnhandledMessage$;
import akka.event.ActorEventBus;
import akka.event.Logging;
import akka.event.Logging$;
import akka.event.Logging$Debug$;
import akka.event.Logging$Error$;
import akka.event.Logging$InitializeLogger$;
import akka.event.Logging$LogExt$;
import akka.event.Logging$LogLevel$;
import akka.event.Logging$LoggerInitialized$;
import akka.event.Logging$Warning$;
import akka.event.LoggingBus$;
import akka.pattern.AskableActorRef$;
import akka.util.ReentrantGuard;
import akka.util.Timeout;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public interface LoggingBus
extends ActorEventBus {
    public static void $init$(LoggingBus $this) {
        $this.akka$event$LoggingBus$_setter_$akka$event$LoggingBus$$guard_$eq(new ReentrantGuard());
        $this.akka$event$LoggingBus$$loggers_$eq((Seq<ActorRef>)((Seq)package$.MODULE$.Seq().empty()));
    }

    public ReentrantGuard akka$event$LoggingBus$$guard();

    public void akka$event$LoggingBus$_setter_$akka$event$LoggingBus$$guard_$eq(ReentrantGuard var1);

    public Seq<ActorRef> akka$event$LoggingBus$$loggers();

    public void akka$event$LoggingBus$$loggers_$eq(Seq<ActorRef> var1);

    public int akka$event$LoggingBus$$_logLevel();

    public void akka$event$LoggingBus$$_logLevel_$eq(int var1);

    public static int logLevel$(LoggingBus $this) {
        return $this.logLevel();
    }

    default public int logLevel() {
        return this.akka$event$LoggingBus$$_logLevel();
    }

    public static void setLogLevel$(LoggingBus $this, int level) {
        $this.setLogLevel(level);
    }

    default public void setLogLevel(int level) {
        this.akka$event$LoggingBus$$guard().withGuard(() -> this.setLogLevel$$anonfun$1(level));
    }

    private void setUpStdoutLogger(ActorSystem.Settings config) {
        Object object = Logging$.MODULE$.levelFor(config.StdoutLogLevel()).getOrElse((Function0 & Serializable)() -> new Logging.LogLevel(this.$anonfun$1(config)));
        int level = object == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)object).asInt();
        ((IterableOnceOps)Logging$.MODULE$.AllLogLevels().filter((Function1 & Serializable)_$2 -> Logging$LogLevel$.MODULE$.$greater$eq$extension(level, _$2 == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)_$2).asInt()))).foreach((Function1 & Serializable)l -> this.setUpStdoutLogger$$anonfun$2(l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt()));
        this.akka$event$LoggingBus$$guard().withGuard(() -> this.setUpStdoutLogger$$anonfun$3(level));
    }

    public static void startStdoutLogger$(LoggingBus $this, ActorSystem.Settings config) {
        $this.startStdoutLogger(config);
    }

    default public void startStdoutLogger(ActorSystem.Settings config) {
        this.setUpStdoutLogger(config);
        this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), "StandardOutLogger started"));
    }

    public static void startDefaultLoggers$(LoggingBus $this, ActorSystemImpl system) {
        $this.startDefaultLoggers(system);
    }

    default public void startDefaultLoggers(ActorSystemImpl system) {
        String logName = new StringBuilder(2).append(Logging$.MODULE$.simpleName(this)).append("(").append(system).append(")").toString();
        Object object = Logging$.MODULE$.levelFor(system.settings().LogLevel()).getOrElse((Function0 & Serializable)() -> new Logging.LogLevel(this.$anonfun$2(system, logName)));
        int level = object == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)object).asInt();
        try {
            List list;
            List list2 = system.settings().Loggers();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list2;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                String string = Logging.DefaultLogger.class.getName();
                list = package$.MODULE$.Nil().$colon$colon((Object)string);
            } else {
                List loggers;
                list = loggers = list2;
            }
            List defaultLoggers = list;
            Seq myloggers = (Seq)defaultLoggers.withFilter((Function1 & Serializable)loggerName -> {
                String string = loggerName;
                String string2 = Logging$.MODULE$.StandardOutLogger().getClass().getName();
                return string == null ? string2 != null : !string.equals(string2);
            }).map((Function1 & Serializable)loggerName -> (ActorRef)system.dynamicAccess().getClassFor((String)loggerName, ClassTag$.MODULE$.apply(Actor.class)).map((Function1 & Serializable)actorClass -> this.addLogger(system, (Class<? extends Actor>)actorClass, level, logName)).recover((PartialFunction)new Serializable((String)loggerName){
                private final String loggerName$1;
                {
                    this.loggerName$1 = loggerName$2;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    throw new ConfigurationException(new StringBuilder(55).append("Logger specified in config can't be loaded [").append(this.loggerName$1).append("] due to [").append(e.toString()).append("]").toString(), e);
                }
            }).get());
            this.akka$event$LoggingBus$$guard().withGuard(() -> this.startDefaultLoggers$$anonfun$1(level, myloggers));
            try {
                if (system.settings().DebugUnhandledMessage()) {
                    this.subscribe(system.systemActorOf(Props$.MODULE$.apply(this::startDefaultLoggers$$anonfun$2, ClassTag$.MODULE$.apply(Actor.class)), "UnhandledMessageForwarder"), UnhandledMessage.class);
                }
            }
            catch (InvalidActorNameException invalidActorNameException) {}
            this.publish(Logging$Debug$.MODULE$.apply(logName, this.getClass(), "Default Loggers started"));
            if (!defaultLoggers.contains((Object)Logging$.MODULE$.StandardOutLogger().getClass().getName())) {
                this.unsubscribe(Logging$.MODULE$.StandardOutLogger());
            }
        }
        catch (Exception e) {
            System.err.println("error while starting up loggers");
            e.printStackTrace();
            throw new ConfigurationException(new StringBuilder(32).append("Could not start logger due to [").append(e.toString()).append("]").toString());
        }
    }

    public static void stopDefaultLoggers$(LoggingBus $this, ActorSystem system) {
        $this.stopDefaultLoggers(system);
    }

    default public void stopDefaultLoggers(ActorSystem system) {
        int level = this.akka$event$LoggingBus$$_logLevel();
        if (!this.akka$event$LoggingBus$$loggers().contains((Object)Logging$.MODULE$.StandardOutLogger())) {
            this.setUpStdoutLogger(system.settings());
            this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), "shutting down: StandardOutLogger"));
        }
        this.akka$event$LoggingBus$$loggers().withFilter((Function1 & Serializable)logger -> {
            ActorRef actorRef = logger;
            Logging.StandardOutLogger standardOutLogger = Logging$.MODULE$.StandardOutLogger();
            return actorRef == null ? standardOutLogger != null : !((Object)actorRef).equals(standardOutLogger);
        }).foreach((Function1)(JProcedure1 & Serializable)logger -> {
            block0: {
                this.unsubscribe(logger);
                ActorRef actorRef = logger;
                if (!(actorRef instanceof InternalActorRef)) break block0;
                InternalActorRef ref = (InternalActorRef)actorRef;
                ref.stop();
            }
        });
        this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), "all default loggers stopped"));
    }

    private ActorRef addLogger(ActorSystemImpl system, Class<? extends Actor> clazz, int level, String logName) {
        Object response;
        Object object;
        String name = new StringBuilder(4).append("log").append(((Logging.LogExt)Logging$LogExt$.MODULE$.apply(system)).id()).append("-").append(Logging$.MODULE$.simpleName(clazz)).toString();
        ActorRef actor = system.systemActorOf(Props$.MODULE$.apply(clazz, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).withDispatcher(system.settings().LoggersDispatcher()), name);
        try {
            ActorRef actorRef = akka.pattern.package$.MODULE$.ask(actor);
            Logging.InitializeLogger initializeLogger = Logging$InitializeLogger$.MODULE$.apply(this);
            object = Await$.MODULE$.result(AskableActorRef$.MODULE$.$qmark$extension(actorRef, initializeLogger, LoggingBus.timeout$1(system), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, initializeLogger)), (Duration)LoggingBus.timeout$1(system).duration());
        }
        catch (TimeoutException timeoutException) {
            this.publish(Logging$Warning$.MODULE$.apply(logName, this.getClass(), new StringBuilder(56).append("Logger ").append(name).append(" did not respond within ").append(LoggingBus.timeout$1(system)).append(" to InitializeLogger(bus)").toString()));
            object = "[TIMEOUT]";
        }
        Object object2 = response = object;
        Logging$LoggerInitialized$ logging$LoggerInitialized$ = Logging$LoggerInitialized$.MODULE$;
        if (object2 == null ? logging$LoggerInitialized$ != null : !object2.equals(logging$LoggerInitialized$)) {
            throw new Logging.LoggerInitializationException(new StringBuilder(61).append("Logger ").append(name).append(" did not respond with LoggerInitialized, sent instead ").append(response).toString());
        }
        ((IterableOnceOps)Logging$.MODULE$.AllLogLevels().filter((Function1 & Serializable)_$3 -> Logging$LogLevel$.MODULE$.$greater$eq$extension(level, _$3 == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)_$3).asInt()))).foreach((Function1 & Serializable)l -> this.addLogger$$anonfun$2(actor, l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt()));
        this.publish(Logging$Debug$.MODULE$.apply(logName, this.getClass(), new StringBuilder(15).append("logger ").append(name).append(" started").toString()));
        return actor;
    }

    private static /* synthetic */ boolean setLogLevel$$anonfun$1$$anonfun$1(int level$1, int logLvl$1, int l) {
        return Logging$LogLevel$.MODULE$.$greater$extension(l, logLvl$1) && Logging$LogLevel$.MODULE$.$less$eq$extension(l, level$1);
    }

    private /* synthetic */ void setLogLevel$$anonfun$1$$anonfun$2(int l) {
        this.akka$event$LoggingBus$$loggers().foreach((Function1 & Serializable)log -> this.subscribe(log, Logging$.MODULE$.classFor(l)));
    }

    private static /* synthetic */ boolean setLogLevel$$anonfun$1$$anonfun$3(int level$3, int logLvl$2, int l) {
        return Logging$LogLevel$.MODULE$.$less$eq$extension(l, logLvl$2) && Logging$LogLevel$.MODULE$.$greater$extension(l, level$3);
    }

    private /* synthetic */ void setLogLevel$$anonfun$1$$anonfun$4(int l) {
        this.akka$event$LoggingBus$$loggers().foreach((Function1 & Serializable)log -> this.unsubscribe(log, Logging$.MODULE$.classFor(l)));
    }

    private void setLogLevel$$anonfun$1(int level$2) {
        int logLvl = this.akka$event$LoggingBus$$_logLevel();
        Logging$.MODULE$.AllLogLevels().withFilter((Function1 & Serializable)l -> LoggingBus.setLogLevel$$anonfun$1$$anonfun$1(level$2, logLvl, l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt())).foreach((Function1 & Serializable)v1 -> {
            this.setLogLevel$$anonfun$1$$anonfun$2(v1 == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)v1).asInt());
            return BoxedUnit.UNIT;
        });
        Logging$.MODULE$.AllLogLevels().withFilter((Function1 & Serializable)l -> LoggingBus.setLogLevel$$anonfun$1$$anonfun$3(level$2, logLvl, l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt())).foreach((Function1 & Serializable)v1 -> {
            this.setLogLevel$$anonfun$1$$anonfun$4(v1 == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)v1).asInt());
            return BoxedUnit.UNIT;
        });
        this.akka$event$LoggingBus$$_logLevel_$eq(level$2);
    }

    private int $anonfun$1(ActorSystem.Settings config$1) {
        Logging$.MODULE$.StandardOutLogger().print(Logging$Error$.MODULE$.apply(new Logging.LoggerException(), Logging$.MODULE$.simpleName(this), this.getClass(), new StringBuilder(29).append("unknown akka.stdout-loglevel ").append(config$1.StdoutLogLevel()).toString()));
        return Logging$.MODULE$.ErrorLevel();
    }

    private /* synthetic */ boolean setUpStdoutLogger$$anonfun$2(int l) {
        return this.subscribe(Logging$.MODULE$.StandardOutLogger(), Logging$.MODULE$.classFor(l));
    }

    private void setUpStdoutLogger$$anonfun$3(int level$5) {
        this.akka$event$LoggingBus$$loggers_$eq((Seq<ActorRef>)((Seq)this.akka$event$LoggingBus$$loggers().$colon$plus((Object)Logging$.MODULE$.StandardOutLogger())));
        this.akka$event$LoggingBus$$_logLevel_$eq(level$5);
    }

    private int $anonfun$2(ActorSystemImpl system$1, String logName$1) {
        Logging$.MODULE$.StandardOutLogger().print(Logging$Error$.MODULE$.apply(new Logging.LoggerException(), logName$1, this.getClass(), new StringBuilder(22).append("unknown akka.loglevel ").append(system$1.settings().LogLevel()).toString()));
        return Logging$.MODULE$.ErrorLevel();
    }

    private void startDefaultLoggers$$anonfun$1(int level$8, Seq myloggers$1) {
        this.akka$event$LoggingBus$$loggers_$eq((Seq<ActorRef>)myloggers$1);
        this.akka$event$LoggingBus$$_logLevel_$eq(level$8);
    }

    private Actor startDefaultLoggers$$anonfun$2() {
        return new Actor(this){
            private ActorContext context;
            private ActorRef self;
            private final LoggingBus $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Actor.$init$(this);
                Statics.releaseFence();
            }

            public ActorContext context() {
                return this.context;
            }

            public final ActorRef self() {
                return this.self;
            }

            public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
                this.context = x$0;
            }

            public void akka$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
                this.self = x$0;
            }

            public PartialFunction receive() {
                return new Serializable(this){
                    private final $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Object x) {
                        boolean bl;
                        Object object = x;
                        if (object instanceof UnhandledMessage) {
                            UnhandledMessage unhandledMessage = UnhandledMessage$.MODULE$.unapply((UnhandledMessage)object);
                            Object object2 = unhandledMessage._1();
                            ActorRef actorRef = unhandledMessage._2();
                            ActorRef actorRef2 = unhandledMessage._3();
                            Object msg = object2;
                            ActorRef sender = actorRef;
                            ActorRef rcp = actorRef2;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        Object object;
                        Object object2 = x;
                        if (object2 instanceof UnhandledMessage) {
                            UnhandledMessage unhandledMessage = UnhandledMessage$.MODULE$.unapply((UnhandledMessage)object2);
                            Object object3 = unhandledMessage._1();
                            ActorRef actorRef = unhandledMessage._2();
                            ActorRef actorRef2 = unhandledMessage._3();
                            Object msg = object3;
                            ActorRef sender = actorRef;
                            ActorRef rcp = actorRef2;
                            this.$outer.akka$event$LoggingBus$_$_$$anon$$$outer().publish(Logging$Debug$.MODULE$.apply(rcp.path().toString(), rcp.getClass(), new StringBuilder(25).append("unhandled message from ").append(sender).append(": ").append(msg).toString()));
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x);
                        }
                        return object;
                    }
                };
            }

            public final LoggingBus akka$event$LoggingBus$_$_$$anon$$$outer() {
                return this.$outer;
            }
        };
    }

    private static Timeout timeout$1(ActorSystemImpl system$4) {
        return system$4.settings().LoggerStartTimeout();
    }

    private /* synthetic */ boolean addLogger$$anonfun$2(ActorRef actor$1, int l) {
        return this.subscribe(actor$1, Logging$.MODULE$.classFor(l));
    }
}

