/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.io.BufferPool;
import akka.io.DirectByteBufferPool$;
import java.nio.ByteBuffer;

public class DirectByteBufferPool
implements BufferPool {
    private final int defaultBufferSize;
    private final int maxPoolEntries;
    private final ByteBuffer[] pool;
    private int buffersInPool;

    public DirectByteBufferPool(int defaultBufferSize, int maxPoolEntries) {
        this.defaultBufferSize = defaultBufferSize;
        this.maxPoolEntries = maxPoolEntries;
        this.pool = new ByteBuffer[maxPoolEntries];
        this.buffersInPool = 0;
    }

    @Override
    public ByteBuffer acquire() {
        return this.takeBufferFromPool();
    }

    @Override
    public void release(ByteBuffer buf) {
        this.offerBufferToPool(buf);
    }

    private ByteBuffer allocate(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    /*
     * WARNING - void declaration
     */
    private final ByteBuffer takeBufferFromPool() {
        ByteBuffer[] byteBufferArray = this.pool;
        synchronized (this.pool) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2;
            if (this.buffersInPool > 0) {
                --this.buffersInPool;
                byteBuffer2 = this.pool[this.buffersInPool];
            } else {
                byteBuffer2 = null;
            }
            ByteBuffer byteBuffer3 = byteBuffer2;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ByteBuffer buffer = byteBuffer3;
            if (buffer == null) {
                byteBuffer = this.allocate(this.defaultBufferSize);
            } else {
                void var1_3;
                buffer.clear();
                byteBuffer = var1_3;
            }
            return byteBuffer;
        }
    }

    private final void offerBufferToPool(ByteBuffer buf) {
        ByteBuffer[] byteBufferArray = this.pool;
        synchronized (this.pool) {
            boolean bl;
            if (this.buffersInPool < this.maxPoolEntries) {
                this.pool[this.buffersInPool] = buf;
                ++this.buffersInPool;
                bl = false;
            } else {
                bl = true;
            }
            boolean bl2 = bl;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            boolean clean = bl2;
            if (clean) {
                this.tryCleanDirectByteBuffer(buf);
            }
            return;
        }
    }

    private final void tryCleanDirectByteBuffer(ByteBuffer toBeDestroyed) {
        DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(toBeDestroyed);
    }
}

