/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.actor.NoSerializationVerificationNeeded;
import akka.annotation.InternalApi;
import akka.io.Dns;
import akka.io.Dns$Resolved$;
import akka.io.PeriodicCacheCleanup;
import akka.io.SimpleDnsCache$;
import akka.io.SimpleDnsCache$CacheEntry$;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Forever$;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Ip$;
import akka.io.dns.ResourceRecord;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class SimpleDnsCache
extends Dns
implements PeriodicCacheCleanup,
NoSerializationVerificationNeeded {
    private final AtomicReference<Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved>> cacheRef = new AtomicReference(new Cache((SortedSet)SortedSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExpiryEntry[0]), SimpleDnsCache$.MODULE$.expiryEntryOrdering()), (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0<Object>)(Function0 & Serializable)() -> this.clock()));
    private final long nanoBase = System.nanoTime();

    @InternalApi
    public static <K> Ordering<ExpiryEntry<K>> expiryEntryOrdering() {
        return SimpleDnsCache$.MODULE$.expiryEntryOrdering();
    }

    @Override
    public Option<Dns.Resolved> cached(String name) {
        List ipv4 = this.cacheRef.get().get((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), false))).toList().flatMap((Function1 & Serializable)_$1 -> _$1.records());
        List ipv6 = this.cacheRef.get().get((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)DnsProtocol$Ip$.MODULE$.apply(false, DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2()))).toList().flatMap((Function1 & Serializable)_$2 -> _$2.records());
        List both = this.cacheRef.get().get((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2()))).toList().flatMap((Function1 & Serializable)_$3 -> _$3.records());
        List all = ((List)((IterableOps)ipv4.$plus$plus((IterableOnce)ipv6)).$plus$plus((IterableOnce)both)).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(ResourceRecord x) {
                boolean bl;
                ResourceRecord resourceRecord = x;
                if (resourceRecord instanceof ARecord) {
                    ARecord r = (ARecord)resourceRecord;
                    bl = true;
                } else if (resourceRecord instanceof AAAARecord) {
                    AAAARecord r = (AAAARecord)resourceRecord;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(ResourceRecord x, Function1 function1) {
                Object object;
                ResourceRecord resourceRecord = x;
                if (resourceRecord instanceof ARecord) {
                    ARecord r = (ARecord)resourceRecord;
                    object = r.ip();
                } else if (resourceRecord instanceof AAAARecord) {
                    AAAARecord r = (AAAARecord)resourceRecord;
                    object = r.ip();
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        });
        return all.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)all));
    }

    @Override
    public Option<DnsProtocol.Resolved> cached(DnsProtocol.Resolve request) {
        return this.cacheRef.get().get((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)request.name(), (Object)request.requestType()));
    }

    public long clock() {
        long now = System.nanoTime();
        return now - this.nanoBase < 0L ? 0L : (now - this.nanoBase) / 1000000L;
    }

    @InternalApi
    public final Option<DnsProtocol.Resolved> get(Tuple2<String, DnsProtocol.RequestType> key) {
        return this.cacheRef.get().get(key);
    }

    public final void put(Tuple2<String, DnsProtocol.RequestType> key, DnsProtocol.Resolved records, CachePolicy.CachePolicy ttl) {
        Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved> c;
        SimpleDnsCache simpleDnsCache = this;
        while (!simpleDnsCache.cacheRef.compareAndSet(c = simpleDnsCache.cacheRef.get(), c.put(key, records, ttl))) {
        }
    }

    @Override
    public final void cleanup() {
        Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved> c;
        SimpleDnsCache simpleDnsCache = this;
        while (!simpleDnsCache.cacheRef.compareAndSet(c = simpleDnsCache.cacheRef.get(), c.cleanup())) {
        }
    }

    @InternalApi
    public static class Cache<K, V> {
        private final SortedSet<ExpiryEntry<K>> queue;
        private final Map<K, CacheEntry<V>> cache;
        private final Function0<Object> clock;

        public Cache(SortedSet<ExpiryEntry<K>> queue, Map<K, CacheEntry<V>> cache, Function0<Object> clock) {
            this.queue = queue;
            this.cache = cache;
            this.clock = clock;
        }

        public Option<V> get(K name) {
            return this.cache.get(name).withFilter((Function1 & Serializable)e -> e.isValid(this.clock.apply$mcJ$sp())).map((Function1 & Serializable)e -> e.answer());
        }

        public Cache<K, V> put(K name, V answer, CachePolicy.CachePolicy ttl) {
            long l;
            CachePolicy.CachePolicy cachePolicy = ttl;
            if (CachePolicy$Forever$.MODULE$.equals(cachePolicy)) {
                l = Long.MAX_VALUE;
            } else if (CachePolicy$Never$.MODULE$.equals(cachePolicy)) {
                l = this.clock.apply$mcJ$sp() - 1L;
            } else if (cachePolicy instanceof CachePolicy.Ttl) {
                CachePolicy.Ttl ttl2 = (CachePolicy.Ttl)cachePolicy;
                l = this.clock.apply$mcJ$sp() + ttl2.value().toMillis();
            } else {
                throw new MatchError((Object)cachePolicy);
            }
            long until = l;
            Object object = Predef$.MODULE$.ArrowAssoc(name);
            return new Cache<K, V>((SortedSet)this.queue.$plus(new ExpiryEntry<K>(name, until)), (Map)this.cache.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, SimpleDnsCache$CacheEntry$.MODULE$.apply(answer, until))), this.clock);
        }

        public Cache<K, V> cleanup() {
            long now = this.clock.apply$mcJ$sp();
            SortedSet q = this.queue;
            Map c = this.cache;
            while (q.nonEmpty() && !((ExpiryEntry)q.head()).isValid(now)) {
                ExpiryEntry minEntry = (ExpiryEntry)q.head();
                Object name = minEntry.name();
                q = (SortedSet)q.$minus((Object)minEntry);
                if (!c.get(name).filterNot((Function1 & Serializable)_$4 -> _$4.isValid(now)).isDefined()) continue;
                c = (Map)c.$minus(name);
            }
            return new Cache<K, V>(q, c, this.clock);
        }
    }

    public static class CacheEntry<T>
    implements Product,
    Serializable {
        private final Object answer;
        private final long until;

        public static <T> CacheEntry<T> apply(T t, long l) {
            return SimpleDnsCache$CacheEntry$.MODULE$.apply(t, l);
        }

        public static CacheEntry<?> fromProduct(Product product) {
            return SimpleDnsCache$CacheEntry$.MODULE$.fromProduct(product);
        }

        public static <T> CacheEntry<T> unapply(CacheEntry<T> cacheEntry) {
            return SimpleDnsCache$CacheEntry$.MODULE$.unapply(cacheEntry);
        }

        public CacheEntry(T answer, long until) {
            this.answer = answer;
            this.until = until;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.answer()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.until()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CacheEntry)) return false;
            CacheEntry cacheEntry = (CacheEntry)object;
            if (this.until() != cacheEntry.until()) return false;
            if (!BoxesRunTime.equals(this.answer(), cacheEntry.answer())) return false;
            if (!cacheEntry.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CacheEntry;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CacheEntry";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = BoxesRunTime.boxToLong((long)this._2());
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "answer";
            } else if (1 == n2) {
                string = "until";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public T answer() {
            return (T)this.answer;
        }

        public long until() {
            return this.until;
        }

        public boolean isValid(long clock) {
            return clock < this.until();
        }

        public <T> CacheEntry<T> copy(T answer, long until) {
            return new CacheEntry<T>(answer, until);
        }

        public <T> T copy$default$1() {
            return this.answer();
        }

        public long copy$default$2() {
            return this.until();
        }

        public T _1() {
            return this.answer();
        }

        public long _2() {
            return this.until();
        }
    }

    @InternalApi
    public static class ExpiryEntry<K>
    implements Ordered<ExpiryEntry<K>> {
        private final Object name;
        private final long until;

        public ExpiryEntry(K name, long until) {
            this.name = name;
            this.until = until;
            Ordered.$init$((Ordered)this);
        }

        public K name() {
            return (K)this.name;
        }

        public long until() {
            return this.until;
        }

        public boolean isValid(long clock) {
            return clock < this.until();
        }

        public int compare(ExpiryEntry<K> that) {
            return -Predef$.MODULE$.long2Long(this.until()).compareTo(Predef$.MODULE$.long2Long(that.until()));
        }
    }
}

