/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Deploy$;
import akka.actor.Props$;
import akka.dispatch.RequiresMessageQueue;
import akka.dispatch.UnboundedMessageQueueSemantics;
import akka.event.LoggingAdapter;
import akka.io.Dns;
import akka.io.Dns$Resolve$;
import akka.io.DnsExt;
import akka.io.PeriodicCacheCleanup;
import akka.io.SimpleDnsManager$CacheCleanup$;
import akka.io.dns.DnsProtocol;
import akka.routing.FromConfig$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class SimpleDnsManager
implements Actor,
RequiresMessageQueue<UnboundedMessageQueueSemantics>,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final DnsExt ext;
    public final ActorRef akka$io$SimpleDnsManager$$resolver;
    public final Option<Dns> akka$io$SimpleDnsManager$$cacheCleanup;
    private final Option<Cancellable> cleanupTimer;

    public SimpleDnsManager(DnsExt ext) {
        None$ none$;
        this.ext = ext;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.akka$io$SimpleDnsManager$$resolver = this.context().actorOf(FromConfig$.MODULE$.props(Props$.MODULE$.apply(ext.provider().actorClass(), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ext.cache(), ext.Settings().ResolverConfig()})).withDeploy(Deploy$.MODULE$.local()).withDispatcher(ext.Settings().Dispatcher())), ext.Settings().Resolver());
        Dns dns = ext.cache();
        if (dns instanceof PeriodicCacheCleanup) {
            Dns cleanup = (Dns)((Object)((PeriodicCacheCleanup)((Object)dns)));
            none$ = Some$.MODULE$.apply((Object)cleanup);
        } else {
            none$ = None$.MODULE$;
        }
        this.akka$io$SimpleDnsManager$$cacheCleanup = none$;
        this.cleanupTimer = this.akka$io$SimpleDnsManager$$cacheCleanup.map((Function1 & Serializable)_$1 -> {
            FiniteDuration interval = Duration$.MODULE$.apply(ext.Settings().ResolverConfig().getDuration("cache-cleanup-interval", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            return this.context().system().scheduler().scheduleWithFixedDelay(interval, interval, this.self(), (Object)SimpleDnsManager$CacheCleanup$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        });
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void akka$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public DnsExt ext() {
        return this.ext;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final SimpleDnsManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof Dns.Resolve) {
                    String string;
                    Dns.Resolve resolve = (Dns.Resolve)object;
                    Dns.Resolve resolve2 = Dns$Resolve$.MODULE$.unapply(resolve);
                    String name = string = resolve2._1();
                    Dns.Resolve r = resolve;
                    bl = true;
                } else if (object instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve m = (DnsProtocol.Resolve)object;
                    bl = true;
                } else {
                    bl = SimpleDnsManager$CacheCleanup$.MODULE$.equals(object);
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof Dns.Resolve) {
                    String string;
                    Dns.Resolve resolve = (Dns.Resolve)object2;
                    Dns.Resolve resolve2 = Dns$Resolve$.MODULE$.unapply(resolve);
                    String name = string = resolve2._1();
                    Dns.Resolve r = resolve;
                    this.$outer.log().debug("(deprecated) Resolution request for {} from {}", name, this.$outer.sender());
                    this.$outer.akka$io$SimpleDnsManager$$resolver.forward(r, this.$outer.context());
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve m = (DnsProtocol.Resolve)object2;
                    this.$outer.log().debug("Resolution request for {} from {}", m.name(), this.$outer.sender());
                    this.$outer.akka$io$SimpleDnsManager$$resolver.forward(m, this.$outer.context());
                    object = BoxedUnit.UNIT;
                } else if (SimpleDnsManager$CacheCleanup$.MODULE$.equals(object2)) {
                    this.$outer.akka$io$SimpleDnsManager$$cacheCleanup.foreach((Function1)((JProcedure1 & Serializable)SimpleDnsManager::akka$io$SimpleDnsManager$$anon$1$$_$applyOrElse$$anonfun$1));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{akka$io$SimpleDnsManager$$anon$1$$_$applyOrElse$$anonfun$1(akka.io.Dns )}, serializedLambda);
            }
        };
    }

    @Override
    public void postStop() {
        this.cleanupTimer.foreach((Function1 & Serializable)_$3 -> _$3.cancel());
    }

    public static final /* synthetic */ void akka$io$SimpleDnsManager$$anon$1$$_$applyOrElse$$anonfun$1(Dns _$2) {
        ((PeriodicCacheCleanup)((Object)_$2)).cleanup();
    }
}

