/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.actor.ActorRef;
import akka.actor.ReceiveTimeout$;
import akka.actor.Status;
import akka.actor.Status$Failure$;
import akka.io.ChannelRegistration;
import akka.io.ChannelRegistry;
import akka.io.Dns$;
import akka.io.SelectionHandler$ChannelConnectable$;
import akka.io.Tcp;
import akka.io.Tcp$CommandFailed$;
import akka.io.TcpConnection;
import akka.io.TcpConnection$CloseInformation$;
import akka.io.TcpExt;
import akka.io.TcpOutgoingConnection$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolve$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public class TcpOutgoingConnection
extends TcpConnection {
    public final ChannelRegistry akka$io$TcpOutgoingConnection$$channelRegistry;
    public final ActorRef akka$io$TcpOutgoingConnection$$commander;
    public final Tcp.Connect akka$io$TcpOutgoingConnection$$connect;

    public static ConnectException FinishConnectNeverReturnedTrueException() {
        return TcpOutgoingConnection$.MODULE$.FinishConnectNeverReturnedTrueException();
    }

    public static ConnectException connectTimeoutExpired(Option<FiniteDuration> option) {
        return TcpOutgoingConnection$.MODULE$.connectTimeoutExpired(option);
    }

    public TcpOutgoingConnection(TcpExt _tcp, ChannelRegistry channelRegistry, ActorRef commander, Tcp.Connect connect) {
        this.akka$io$TcpOutgoingConnection$$channelRegistry = channelRegistry;
        this.akka$io$TcpOutgoingConnection$$commander = commander;
        this.akka$io$TcpOutgoingConnection$$connect = connect;
        super(_tcp, (SocketChannel)SocketChannel.open().configureBlocking(false), connect.pullMode());
        this.signDeathPact(commander);
        connect.options().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.beforeConnect(this.channel().socket()));
        Socket socket = this.channel().socket();
        connect.localAddress().foreach((Function1)(JProcedure1 & Serializable)x$0 -> socket.bind((SocketAddress)x$0));
        channelRegistry.register(this.channel(), 0, this.self());
        connect.timeout().foreach((Function1)(JProcedure1 & Serializable)timeout -> this.context().setReceiveTimeout((Duration)timeout));
    }

    public void akka$io$TcpOutgoingConnection$$stop(Throwable cause) {
        this.stopWith(TcpConnection$CloseInformation$.MODULE$.apply((Set<ActorRef>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[]{this.akka$io$TcpOutgoingConnection$$commander}))), Tcp$CommandFailed$.MODULE$.apply(this.akka$io$TcpOutgoingConnection$$connect).withCause(cause)), true);
    }

    public void akka$io$TcpOutgoingConnection$$reportConnectFailure(Function0 thunk) {
        try {
            thunk.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.log().debug("Could not establish connection to [{}] due to {}", this.akka$io$TcpOutgoingConnection$$connect.remoteAddress(), e);
                this.akka$io$TcpOutgoingConnection$$stop(e);
            }
            throw throwable;
        }
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final TcpOutgoingConnection $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object;
                    bl = true;
                } else {
                    bl = ReceiveTimeout$.MODULE$.equals(object);
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object2;
                    this.$outer.setRegistration(registration);
                    this.$outer.akka$io$TcpOutgoingConnection$$reportConnectFailure((Function0)((JFunction0.mcV.sp & Serializable)() -> this.applyOrElse$$anonfun$1(registration)));
                    object = BoxedUnit.UNIT;
                } else if (ReceiveTimeout$.MODULE$.equals(object2)) {
                    this.$outer.akka$io$TcpOutgoingConnection$$connectionTimeout();
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final void applyOrElse$$anonfun$1(ChannelRegistration registration$1) {
                if (this.$outer.akka$io$TcpOutgoingConnection$$connect.remoteAddress().isUnresolved()) {
                    this.$outer.log().debug("Resolving {} before connecting", this.$outer.akka$io$TcpOutgoingConnection$$connect.remoteAddress().getHostName());
                    Option<DnsProtocol.Resolved> option = Dns$.MODULE$.resolve(DnsProtocol$Resolve$.MODULE$.apply(this.$outer.akka$io$TcpOutgoingConnection$$connect.remoteAddress().getHostName()), this.$outer.context().system(), this.$outer.self());
                    if (None$.MODULE$.equals(option)) {
                        this.$outer.context().become(this.$outer.resolving(registration$1));
                        return;
                    } else {
                        if (!(option instanceof Some)) throw new MatchError(option);
                        DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)((Some)option).value();
                        this.$outer.register(new InetSocketAddress(resolved.address(), this.$outer.akka$io$TcpOutgoingConnection$$connect.remoteAddress().getPort()), registration$1);
                    }
                    return;
                } else {
                    this.$outer.register(this.$outer.akka$io$TcpOutgoingConnection$$connect.remoteAddress(), registration$1);
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(akka.io.ChannelRegistration )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> resolving(ChannelRegistration registration) {
        return new Serializable(registration, this){
            private final ChannelRegistration registration$2;
            private final TcpOutgoingConnection $outer;
            {
                this.registration$2 = registration$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof DnsProtocol.Resolved) {
                    DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)object;
                    bl = true;
                } else if (ReceiveTimeout$.MODULE$.equals(object)) {
                    bl = true;
                } else if (object instanceof Status.Failure) {
                    Throwable throwable;
                    Status.Failure failure = Status$Failure$.MODULE$.unapply((Status.Failure)object);
                    Throwable ex = throwable = failure._1();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof DnsProtocol.Resolved) {
                    DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)object2;
                    this.$outer.akka$io$TcpOutgoingConnection$$reportConnectFailure((Function0)((JFunction0.mcV.sp & Serializable)() -> this.applyOrElse$$anonfun$2(resolved)));
                    object = BoxedUnit.UNIT;
                } else if (ReceiveTimeout$.MODULE$.equals(object2)) {
                    this.$outer.akka$io$TcpOutgoingConnection$$connectionTimeout();
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Status.Failure) {
                    Throwable throwable;
                    Status.Failure failure = Status$Failure$.MODULE$.unapply((Status.Failure)object2);
                    Throwable ex = throwable = failure._1();
                    this.$outer.akka$io$TcpOutgoingConnection$$reportConnectFailure((Function0)((JFunction0.mcV.sp & Serializable)() -> TcpOutgoingConnection.akka$io$TcpOutgoingConnection$$anon$2$$_$applyOrElse$$anonfun$3(ex)));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }

            private final void applyOrElse$$anonfun$2(DnsProtocol.Resolved resolved$1) {
                this.$outer.register(new InetSocketAddress(resolved$1.address(), this.$outer.akka$io$TcpOutgoingConnection$$connect.remoteAddress().getPort()), this.registration$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$2(akka.io.dns.DnsProtocol$Resolved ), akka$io$TcpOutgoingConnection$$anon$2$$_$applyOrElse$$anonfun$3(java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    public void register(InetSocketAddress address, ChannelRegistration registration) {
        this.akka$io$TcpOutgoingConnection$$reportConnectFailure((Function0)((JFunction0.mcV.sp & Serializable)() -> this.register$$anonfun$1(address, registration)));
    }

    public PartialFunction<Object, BoxedUnit> connecting(ChannelRegistration registration, int remainingFinishConnectRetries) {
        return new Serializable(registration, remainingFinishConnectRetries, this){
            private final ChannelRegistration registration$4;
            private final int remainingFinishConnectRetries$1;
            private final TcpOutgoingConnection $outer;
            {
                this.registration$4 = registration$6;
                this.remainingFinishConnectRetries$1 = remainingFinishConnectRetries$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return SelectionHandler$ChannelConnectable$.MODULE$.equals(object) ? true : ReceiveTimeout$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (SelectionHandler$ChannelConnectable$.MODULE$.equals(object2)) {
                    this.$outer.akka$io$TcpOutgoingConnection$$reportConnectFailure((Function0)((JFunction0.mcV.sp & Serializable)this::applyOrElse$$anonfun$4));
                    object = BoxedUnit.UNIT;
                } else if (ReceiveTimeout$.MODULE$.equals(object2)) {
                    this.$outer.akka$io$TcpOutgoingConnection$$connectionTimeout();
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }

            private final void applyOrElse$$anonfun$4$$anonfun$1() {
                this.$outer.akka$io$TcpOutgoingConnection$$channelRegistry.register(this.$outer.channel(), 8, this.$outer.self());
            }

            private final void applyOrElse$$anonfun$4() {
                if (this.$outer.channel().finishConnect()) {
                    if (this.$outer.akka$io$TcpOutgoingConnection$$connect.timeout().isDefined()) {
                        this.$outer.context().setReceiveTimeout((Duration)Duration$.MODULE$.Undefined());
                    }
                    this.$outer.log().debug("Connection established to [{}]", this.$outer.akka$io$TcpOutgoingConnection$$connect.remoteAddress());
                    this.$outer.completeConnect(this.registration$4, this.$outer.akka$io$TcpOutgoingConnection$$commander, this.$outer.akka$io$TcpOutgoingConnection$$connect.options());
                } else if (this.remainingFinishConnectRetries$1 > 0) {
                    this.$outer.context().system().scheduler().scheduleOnce(new package.DurationInt(package$.MODULE$.DurationInt(1)).millisecond(), (Function0)((JFunction0.mcV.sp & Serializable)this::applyOrElse$$anonfun$4$$anonfun$1), (ExecutionContext)this.$outer.context().dispatcher());
                    this.$outer.context().become(this.$outer.connecting(this.registration$4, this.remainingFinishConnectRetries$1 - 1));
                } else {
                    this.$outer.log().debug("Could not establish connection because finishConnect never returned true (consider increasing akka.io.tcp.finish-connect-retries)");
                    this.$outer.akka$io$TcpOutgoingConnection$$stop(TcpOutgoingConnection$.MODULE$.FinishConnectNeverReturnedTrueException());
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$4(), applyOrElse$$anonfun$4$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public void akka$io$TcpOutgoingConnection$$connectionTimeout() {
        if (this.akka$io$TcpOutgoingConnection$$connect.timeout().isDefined()) {
            this.context().setReceiveTimeout((Duration)Duration$.MODULE$.Undefined());
        }
        this.log().debug("Connect timeout expired, could not establish connection to [{}]", this.akka$io$TcpOutgoingConnection$$connect.remoteAddress());
        this.akka$io$TcpOutgoingConnection$$stop(TcpOutgoingConnection$.MODULE$.connectTimeoutExpired(this.akka$io$TcpOutgoingConnection$$connect.timeout()));
    }

    public static final void akka$io$TcpOutgoingConnection$$anon$2$$_$applyOrElse$$anonfun$3(Throwable ex$1) {
        throw new RuntimeException(ex$1);
    }

    private final void register$$anonfun$1(InetSocketAddress address$1, ChannelRegistration registration$3) {
        this.log().debug("Attempting connection to [{}]", address$1);
        if (this.channel().connect(address$1)) {
            this.completeConnect(registration$3, this.akka$io$TcpOutgoingConnection$$commander, this.akka$io$TcpOutgoingConnection$$connect.options());
        } else {
            registration$3.enableInterest(8);
            this.context().become(this.connecting(registration$3, this.tcp().Settings().FinishConnectRetries()));
        }
    }
}

