/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Status;
import akka.actor.Status$Failure$;
import akka.dispatch.RequiresMessageQueue;
import akka.dispatch.UnboundedMessageQueueSemantics;
import akka.event.LoggingAdapter;
import akka.io.ChannelRegistration;
import akka.io.ChannelRegistry;
import akka.io.Dns$;
import akka.io.Inet;
import akka.io.SelectionHandler$ChannelReadable$;
import akka.io.SelectionHandler$ChannelWritable$;
import akka.io.UdpConnected;
import akka.io.UdpConnected$CommandFailed$;
import akka.io.UdpConnected$Connected$;
import akka.io.UdpConnected$Disconnect$;
import akka.io.UdpConnected$Disconnected$;
import akka.io.UdpConnected$Received$;
import akka.io.UdpConnected$ResumeReading$;
import akka.io.UdpConnected$SuspendReading$;
import akka.io.UdpConnectedExt;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolve$;
import akka.util.ByteString$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public class UdpConnection
implements Actor,
ActorLogging,
RequiresMessageQueue<UnboundedMessageQueueSemantics> {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    public final UdpConnectedExt akka$io$UdpConnection$$udpConn;
    private final ChannelRegistry channelRegistry;
    public final ActorRef akka$io$UdpConnection$$commander;
    public final UdpConnected.Connect akka$io$UdpConnection$$connect;
    private Tuple2 pendingSend;
    private DatagramChannel channel;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UdpConnection(UdpConnectedExt udpConn, ChannelRegistry channelRegistry, ActorRef commander, UdpConnected.Connect connect) {
        this.akka$io$UdpConnection$$udpConn = udpConn;
        this.channelRegistry = channelRegistry;
        this.akka$io$UdpConnection$$commander = commander;
        this.akka$io$UdpConnection$$connect = connect;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.pendingSend = null;
        this.context().watch(connect.handler());
        this.channel = null;
        if (connect.remoteAddress().isUnresolved()) {
            Option<DnsProtocol.Resolved> option = Dns$.MODULE$.resolve(DnsProtocol$Resolve$.MODULE$.apply(connect.remoteAddress().getHostName()), this.context().system(), this.self());
            if (option instanceof Some) {
                DnsProtocol.Resolved r = (DnsProtocol.Resolved)((Some)option).value();
                this.akka$io$UdpConnection$$reportConnectFailure((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$init$$$anonfun$1(connect, r)));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                this.context().become(this.resolving());
            }
        } else {
            this.akka$io$UdpConnection$$reportConnectFailure((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$init$$$anonfun$2(connect)));
        }
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void akka$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public Tuple2<UdpConnected.Send, ActorRef> pendingSend() {
        return this.pendingSend;
    }

    public void pendingSend_$eq(Tuple2<UdpConnected.Send, ActorRef> x$1) {
        this.pendingSend = x$1;
    }

    public boolean writePending() {
        return this.pendingSend() != null;
    }

    public DatagramChannel channel() {
        return this.channel;
    }

    public void channel_$eq(DatagramChannel x$1) {
        this.channel = x$1;
    }

    public PartialFunction<Object, BoxedUnit> resolving() {
        return new Serializable(this){
            private final UdpConnection $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof DnsProtocol.Resolved) {
                    DnsProtocol.Resolved r = (DnsProtocol.Resolved)object;
                    bl = true;
                } else if (object instanceof Status.Failure) {
                    Throwable throwable;
                    Status.Failure failure = Status$Failure$.MODULE$.unapply((Status.Failure)object);
                    Throwable ex = throwable = failure._1();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof DnsProtocol.Resolved) {
                    DnsProtocol.Resolved r = (DnsProtocol.Resolved)object2;
                    this.$outer.akka$io$UdpConnection$$reportConnectFailure((Function0)((JFunction0.mcV.sp & Serializable)() -> this.applyOrElse$$anonfun$1(r)));
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Status.Failure) {
                    Throwable throwable;
                    Status.Failure failure = Status$Failure$.MODULE$.unapply((Status.Failure)object2);
                    Throwable ex = throwable = failure._1();
                    this.$outer.akka$io$UdpConnection$$reportConnectFailure((Function0)((JFunction0.mcV.sp & Serializable)() -> UdpConnection.akka$io$UdpConnection$$anon$1$$_$applyOrElse$$anonfun$2(ex)));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }

            private final void applyOrElse$$anonfun$1(DnsProtocol.Resolved r$2) {
                this.$outer.doConnect(new InetSocketAddress(r$2.address(), this.$outer.akka$io$UdpConnection$$connect.remoteAddress().getPort()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(akka.io.dns.DnsProtocol$Resolved ), akka$io$UdpConnection$$anon$1$$_$applyOrElse$$anonfun$2(java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    public void doConnect(InetSocketAddress address) {
        this.channel_$eq(DatagramChannel.open());
        this.channel().configureBlocking(false);
        DatagramSocket socket = this.channel().socket();
        this.akka$io$UdpConnection$$connect.options().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.beforeDatagramBind(socket));
        this.akka$io$UdpConnection$$connect.localAddress().foreach((Function1)(JProcedure1 & Serializable)x$0 -> socket.bind((SocketAddress)x$0));
        this.channel().connect(this.akka$io$UdpConnection$$connect.remoteAddress());
        this.channelRegistry.register(this.channel(), 1, this.self());
        this.log().debug("Successfully connected to [{}]", this.akka$io$UdpConnection$$connect.remoteAddress());
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final UdpConnection $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object2;
                    this.$outer.akka$io$UdpConnection$$connect.options().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        block0: {
                            Inet.SocketOption socketOption = x$1;
                            if (!(socketOption instanceof Inet.SocketOptionV2)) break block0;
                            Inet.SocketOptionV2 v2 = (Inet.SocketOptionV2)socketOption;
                            v2.afterConnect(this.$outer.channel().socket());
                        }
                    });
                    this.$outer.akka$io$UdpConnection$$commander.$bang(UdpConnected$Connected$.MODULE$, this.$outer.self());
                    this.$outer.context().become(this.$outer.connected(registration), true);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$3(akka.io.Inet$SocketOption )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> connected(ChannelRegistration registration) {
        return new Serializable(registration, this){
            private final ChannelRegistration registration$1;
            private final UdpConnection $outer;
            {
                this.registration$1 = registration$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (UdpConnected$SuspendReading$.MODULE$.equals(object)) {
                    bl = true;
                } else if (UdpConnected$ResumeReading$.MODULE$.equals(object)) {
                    bl = true;
                } else if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    bl = true;
                } else if (UdpConnected$Disconnect$.MODULE$.equals(object)) {
                    bl = true;
                } else if (object instanceof UdpConnected.Send) {
                    UdpConnected.Send send;
                    UdpConnected.Send send2 = send = (UdpConnected.Send)object;
                    if (this.$outer.writePending()) {
                        bl = true;
                    } else {
                        UdpConnected.Send send3 = send;
                        if (send3.payload().isEmpty()) {
                            bl = true;
                        } else {
                            UdpConnected.Send send4 = send;
                            bl = true;
                        }
                    }
                } else {
                    bl = SelectionHandler$ChannelWritable$.MODULE$.equals(object);
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (UdpConnected$SuspendReading$.MODULE$.equals(object2)) {
                    this.registration$1.disableInterest(1);
                    object = BoxedUnit.UNIT;
                } else if (UdpConnected$ResumeReading$.MODULE$.equals(object2)) {
                    this.registration$1.enableInterest(1);
                    object = BoxedUnit.UNIT;
                } else if (SelectionHandler$ChannelReadable$.MODULE$.equals(object2)) {
                    this.$outer.doRead(this.registration$1, this.$outer.akka$io$UdpConnection$$connect.handler());
                    object = BoxedUnit.UNIT;
                } else if (UdpConnected$Disconnect$.MODULE$.equals(object2)) {
                    this.$outer.log().debug("Closing UDP connection to [{}]", this.$outer.akka$io$UdpConnection$$connect.remoteAddress());
                    this.$outer.channel().close();
                    this.$outer.sender().$bang(UdpConnected$Disconnected$.MODULE$, this.$outer.self());
                    this.$outer.log().debug("Connection closed to [{}], stopping listener", this.$outer.akka$io$UdpConnection$$connect.remoteAddress());
                    this.$outer.context().stop(this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof UdpConnected.Send) {
                    UdpConnected.Send send;
                    UdpConnected.Send send2 = send = (UdpConnected.Send)object2;
                    if (this.$outer.writePending()) {
                        if (this.$outer.akka$io$UdpConnection$$udpConn.settings().TraceLogging()) {
                            this.$outer.log().debug("Dropping write because queue is full");
                        }
                        this.$outer.sender().$bang(UdpConnected$CommandFailed$.MODULE$.apply(send2), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else {
                        UdpConnected.Send send3 = send;
                        if (send3.payload().isEmpty()) {
                            if (send3.wantsAck()) {
                                this.$outer.sender().$bang(send3.ack(), this.$outer.self());
                                object = BoxedUnit.UNIT;
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        } else {
                            UdpConnected.Send send4 = send;
                            this.$outer.pendingSend_$eq((Tuple2<UdpConnected.Send, ActorRef>)Tuple2$.MODULE$.apply((Object)send4, (Object)this.$outer.sender()));
                            this.registration$1.enableInterest(4);
                            object = BoxedUnit.UNIT;
                        }
                    }
                } else if (SelectionHandler$ChannelWritable$.MODULE$.equals(object2)) {
                    this.$outer.doWrite();
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
    }

    public void doRead(ChannelRegistration registration, ActorRef handler) {
        ByteBuffer buffer = this.akka$io$UdpConnection$$udpConn.bufferPool().acquire();
        try {
            try {
                this.innerRead$1(handler, this.akka$io$UdpConnection$$udpConn.settings().BatchReceiveLimit(), buffer);
            }
            catch (PortUnreachableException portUnreachableException) {
                if (this.akka$io$UdpConnection$$udpConn.settings().TraceLogging()) {
                    this.log().debug("Ignoring PortUnreachableException in doRead");
                }
            }
        }
        finally {
            registration.enableInterest(1);
            this.akka$io$UdpConnection$$udpConn.bufferPool().release(buffer);
        }
    }

    public final void doWrite() {
        ByteBuffer buffer = this.akka$io$UdpConnection$$udpConn.bufferPool().acquire();
        try {
            Tuple2<UdpConnected.Send, ActorRef> tuple2 = this.pendingSend();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            UdpConnected.Send send = (UdpConnected.Send)tuple2._1();
            ActorRef commander = (ActorRef)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)send, (Object)commander);
            UdpConnected.Send send2 = (UdpConnected.Send)tuple22._1();
            ActorRef commander2 = (ActorRef)tuple22._2();
            buffer.clear();
            send2.payload().copyToBuffer(buffer);
            buffer.flip();
            int writtenBytes = this.channel().write(buffer);
            if (this.akka$io$UdpConnection$$udpConn.settings().TraceLogging()) {
                this.log().debug("Wrote [{}] bytes to channel", BoxesRunTime.boxToInteger((int)writtenBytes));
            }
            if (writtenBytes == 0) {
                commander2.$bang(UdpConnected$CommandFailed$.MODULE$.apply(send2), this.self());
            } else if (send2.wantsAck()) {
                commander2.$bang(send2.ack(), this.self());
            }
        }
        finally {
            this.akka$io$UdpConnection$$udpConn.bufferPool().release(buffer);
            this.pendingSend_$eq(null);
        }
    }

    @Override
    public void postStop() {
        if (this.channel() != null && this.channel().isOpen()) {
            this.log().debug("Closing DatagramChannel after being stopped");
            try {
                this.channel().close();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.log().debug("Error closing DatagramChannel: {}", e);
                }
                throw throwable;
            }
        }
    }

    public void akka$io$UdpConnection$$reportConnectFailure(Function0 thunk) {
        try {
            thunk.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.log().debug("Failure while connecting UDP channel to remote address [{}] local address [{}]: {}", this.akka$io$UdpConnection$$connect.remoteAddress(), this.akka$io$UdpConnection$$connect.localAddress().getOrElse(UdpConnection::reportConnectFailure$$anonfun$1), e);
                this.akka$io$UdpConnection$$commander.$bang(UdpConnected$CommandFailed$.MODULE$.apply(this.akka$io$UdpConnection$$connect), this.self());
                this.context().stop(this.self());
            }
            throw throwable;
        }
    }

    private final void $init$$$anonfun$1(UdpConnected.Connect connect$1, DnsProtocol.Resolved r$1) {
        this.doConnect(new InetSocketAddress(r$1.address(), connect$1.remoteAddress().getPort()));
    }

    private final void $init$$$anonfun$2(UdpConnected.Connect connect$2) {
        this.doConnect(connect$2.remoteAddress());
    }

    public static final void akka$io$UdpConnection$$anon$1$$_$applyOrElse$$anonfun$2(Throwable ex$1) {
        throw new RuntimeException(ex$1);
    }

    private final void innerRead$1(ActorRef handler$1, int readsLeft, ByteBuffer buffer) {
        int n = readsLeft;
        while (true) {
            buffer.clear();
            buffer.limit(this.akka$io$UdpConnection$$udpConn.settings().DirectBufferSize());
            if (this.channel().read(buffer) <= 0) break;
            buffer.flip();
            handler$1.$bang(UdpConnected$Received$.MODULE$.apply(ByteString$.MODULE$.apply(buffer)), this.self());
            --n;
        }
    }

    private static final String reportConnectFailure$$anonfun$1() {
        return "undefined";
    }
}

