/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.util.ccompat.package$JavaConverters$;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Hashtable;
import javax.naming.directory.InitialDirContext;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class DnsSettings$
implements Serializable {
    private static final Regex inetSocketAddress;
    public static final DnsSettings$ MODULE$;

    private DnsSettings$() {
    }

    static {
        MODULE$ = new DnsSettings$();
        int DnsFallbackPort = 53;
        inetSocketAddress = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(.*?)(?::(\\d+))?"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DnsSettings$.class);
    }

    @InternalApi
    public InetSocketAddress parseNameserverAddress(String str) {
        List list;
        Option option;
        String string = str;
        if (string == null || (option = inetSocketAddress.unapplySeq((CharSequence)string)).isEmpty() || (list = (List)option.get()).lengthCompare(2) != 0) {
            String unexpected = string;
            throw new IllegalArgumentException(new StringBuilder(28).append("Unparseable address string: ").append(unexpected).toString());
        }
        String string2 = (String)list.apply(0);
        String string3 = (String)list.apply(1);
        String host = string2;
        String port = string3;
        return new InetSocketAddress(host, BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)port).fold(this::parseNameserverAddress$$anonfun$1, (Function1 & Serializable)_$4 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$4)))));
    }

    public Try<List<InetSocketAddress>> getDefaultNameServers(ExtendedActorSystem system) {
        return this.getNameserversUsingJNDI$1().orElse(() -> this.getDefaultNameServers$$anonfun$1(system));
    }

    private final int parseNameserverAddress$$anonfun$1() {
        return 53;
    }

    private final InetSocketAddress asInetSocketAddress$1$$anonfun$1(String server$1) {
        int selected;
        URI uri = new URI(server$1);
        String host = uri.getHost();
        int n = uri.getPort();
        int port = -1 == n ? 53 : (selected = n);
        return new InetSocketAddress(host, port);
    }

    private final Try asInetSocketAddress$1(String server) {
        return Try$.MODULE$.apply(() -> this.asInetSocketAddress$1$$anonfun$1(server));
    }

    private final List getNameserversUsingJNDI$1$$anonfun$1(Hashtable env$1) {
        Nil$ nil$;
        InitialDirContext ctx = new InitialDirContext(env$1);
        String dnsUrls = (String)ctx.getEnvironment().get("java.naming.provider.url");
        if (dnsUrls != null && !dnsUrls.isEmpty()) {
            Object[] servers = dnsUrls.split(" ");
            Object object = Predef$.MODULE$.refArrayOps(servers);
            nil$ = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)server -> this.asInetSocketAddress$1((String)server).toOption(), ClassTag$.MODULE$.apply(InetSocketAddress.class))).toList();
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    private final Try getNameserversUsingJNDI$1() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns://");
        return Try$.MODULE$.apply(() -> this.getNameserversUsingJNDI$1$$anonfun$1(env));
    }

    private final List getNameserversUsingReflection$1$$anonfun$1$$anonfun$1(Class c$1) {
        Object instance;
        Method open = c$1.getMethod("open", new Class[0]);
        Method nameservers = c$1.getMethod("nameservers", new Class[0]);
        java.util.List ns = (java.util.List)nameservers.invoke(instance = open.invoke(null, new Object[0]), new Object[0]);
        if (ns.isEmpty()) {
            throw new IllegalStateException("Empty nameservers list discovered using reflection. Consider configuring default nameservers manually!");
        }
        List res = package$JavaConverters$.MODULE$.ListHasAsScala(ns).asScala().toList();
        return res.flatMap((Function1 & Serializable)s -> this.asInetSocketAddress$1((String)s).toOption());
    }

    private final Try getNameserversUsingReflection$1(ExtendedActorSystem system$1) {
        return system$1.dynamicAccess().getClassFor("sun.net.dns.ResolverConfiguration", ClassTag$.MODULE$.Any()).flatMap((Function1 & Serializable)c -> Try$.MODULE$.apply(() -> this.getNameserversUsingReflection$1$$anonfun$1$$anonfun$1(c)));
    }

    private final Try getDefaultNameServers$$anonfun$1(ExtendedActorSystem system$2) {
        return this.getNameserversUsingReflection$1(system$2);
    }
}

