/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.annotation.InternalApi;
import akka.io.dns.AAAARecord;
import akka.io.dns.AAAARecord$;
import akka.io.dns.ARecord;
import akka.io.dns.ARecord$;
import akka.io.dns.CNameRecord;
import akka.io.dns.CNameRecord$;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.ResourceRecord;
import akka.io.dns.SRVRecord;
import akka.io.dns.SRVRecord$;
import akka.io.dns.UnknownRecord;
import akka.io.dns.UnknownRecord$;
import akka.io.dns.internal.DomainName$;
import akka.io.dns.internal.package$;
import akka.util.ByteIterator;
import akka.util.ByteString;
import java.io.Serializable;
import scala.MatchError;
import scala.Short$;
import scala.concurrent.duration.package;
import scala.deriving.Mirror;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class ResourceRecord$
implements Mirror.Sum,
Serializable {
    public static final ResourceRecord$ MODULE$ = new ResourceRecord$();

    private ResourceRecord$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ResourceRecord$.class);
    }

    @InternalApi
    public ResourceRecord parse(ByteIterator it, ByteString msg) {
        ResourceRecord resourceRecord;
        CachePolicy.Ttl ttl;
        String name = DomainName$.MODULE$.parse(it, msg);
        short recType = it.getShort(package$.MODULE$.networkByteOrder());
        short recClass = it.getShort(package$.MODULE$.networkByteOrder());
        int n = it.getInt(package$.MODULE$.networkByteOrder());
        if (0 == n) {
            ttl = CachePolicy$Ttl$.MODULE$.never();
        } else {
            int nonZero = n;
            ttl = CachePolicy$Ttl$.MODULE$.fromPositive(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(nonZero)).seconds());
        }
        CachePolicy.Ttl ttl2 = ttl;
        short rdLength = it.getShort(package$.MODULE$.networkByteOrder());
        ByteIterator data = it.clone().take(Short$.MODULE$.short2int(rdLength));
        it.drop(Short$.MODULE$.short2int(rdLength));
        short s = recType;
        switch (s) {
            case 1: {
                resourceRecord = ARecord$.MODULE$.parseBody(name, ttl2, rdLength, data);
                break;
            }
            case 5: {
                resourceRecord = CNameRecord$.MODULE$.parseBody(name, ttl2, rdLength, data, msg);
                break;
            }
            case 28: {
                resourceRecord = AAAARecord$.MODULE$.parseBody(name, ttl2, rdLength, data);
                break;
            }
            case 33: {
                resourceRecord = SRVRecord$.MODULE$.parseBody(name, ttl2, rdLength, data, msg);
                break;
            }
            default: {
                resourceRecord = UnknownRecord$.MODULE$.parseBody(name, ttl2, recType, recClass, rdLength, data);
                break;
            }
        }
        return resourceRecord;
    }

    public int ordinal(ResourceRecord x$0) {
        int n;
        ResourceRecord resourceRecord = x$0;
        if (resourceRecord instanceof ARecord) {
            n = 0;
        } else if (resourceRecord instanceof AAAARecord) {
            n = 1;
        } else if (resourceRecord instanceof CNameRecord) {
            n = 2;
        } else if (resourceRecord instanceof SRVRecord) {
            n = 3;
        } else if (resourceRecord instanceof UnknownRecord) {
            n = 4;
        } else {
            throw new MatchError((Object)resourceRecord);
        }
        return n;
    }
}

