/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.SimpleDnsCache;
import akka.io.dns.AAAARecord$;
import akka.io.dns.ARecord;
import akka.io.dns.ARecord$;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Ip$;
import akka.io.dns.DnsProtocol$Resolve$;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.AsyncDnsResolver$ResolveFailedException$;
import akka.io.dns.internal.DnsClient;
import akka.io.dns.internal.DnsClient$DropRequest$;
import akka.io.dns.internal.DnsClient$Question4$;
import akka.io.dns.internal.DnsClient$Question6$;
import akka.io.dns.internal.DnsClient$SrvQuestion$;
import akka.io.dns.internal.package$CachePolicyIsOrdered$;
import akka.pattern.AskTimeoutException;
import akka.pattern.AskableActorRef$;
import akka.util.Helpers$;
import akka.util.PrettyDuration$;
import akka.util.PrettyDuration$PrettyPrintableDuration$;
import akka.util.Timeout;
import akka.util.Timeout$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@InternalApi
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final DnsSettings settings;
    public final SimpleDnsCache akka$io$dns$internal$AsyncDnsResolver$$cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List nameServers;
    private final CachePolicy.CachePolicy positiveCachePolicy;
    private final CachePolicy.CachePolicy negativeCachePolicy;
    private short requestId;
    public final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;

    public static boolean isIpv4Address(String string) {
        return AsyncDnsResolver$.MODULE$.isIpv4Address(string);
    }

    public static boolean isIpv6Address(String string) {
        return AsyncDnsResolver$.MODULE$.isIpv6Address(string);
    }

    public AsyncDnsResolver(DnsSettings settings, SimpleDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        Tuple2 tuple2;
        InetAddress loopback;
        this.settings = settings;
        this.akka$io$dns$internal$AsyncDnsResolver$$cache = cache;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.ec = this.context().dispatcher();
        InetAddress inetAddress = loopback = InetAddress.getLoopbackAddress();
        if (inetAddress instanceof Inet6Address) {
            Inet6Address ipv6 = (Inet6Address)inetAddress;
            tuple2 = Tuple2$.MODULE$.apply((Object)InetAddress.getByName("127.0.0.1"), (Object)ipv6);
        } else if (inetAddress instanceof Inet4Address) {
            Inet4Address ipv4 = (Inet4Address)inetAddress;
            tuple2 = Tuple2$.MODULE$.apply((Object)ipv4, (Object)InetAddress.getByName("::1"));
        } else {
            InetAddress unknown = inetAddress;
            throw new IllegalArgumentException(new StringBuilder(23).append("Loopback address was [").append(unknown).append("]").toString());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        InetAddress ipv4Address = (InetAddress)tuple22._1();
        InetAddress ipv6Address = (InetAddress)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)ipv4Address, (Object)ipv6Address);
        InetAddress ipv4Address2 = (InetAddress)tuple23._1();
        InetAddress ipv6Address2 = (InetAddress)tuple23._2();
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"localhost");
        ARecord aRecord = ARecord$.MODULE$.apply("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), loopback);
        cache.put((Tuple2<String, DnsProtocol.RequestType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2())), DnsProtocol$Resolved$.MODULE$.apply("localhost", (Seq<ResourceRecord>)package$.MODULE$.Nil().$colon$colon((Object)aRecord)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"localhost");
        ARecord aRecord2 = ARecord$.MODULE$.apply("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), ipv4Address2);
        cache.put((Tuple2<String, DnsProtocol.RequestType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)DnsProtocol$Ip$.MODULE$.apply(true, false)), DnsProtocol$Resolved$.MODULE$.apply("localhost", (Seq<ResourceRecord>)package$.MODULE$.Nil().$colon$colon((Object)aRecord2)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"localhost");
        ARecord aRecord3 = ARecord$.MODULE$.apply("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), ipv6Address2);
        cache.put((Tuple2<String, DnsProtocol.RequestType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)DnsProtocol$Ip$.MODULE$.apply(false, true)), DnsProtocol$Resolved$.MODULE$.apply("localhost", (Seq<ResourceRecord>)package$.MODULE$.Nil().$colon$colon((Object)aRecord3)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        this.timeout = Timeout$.MODULE$.apply(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.positiveCachePolicy = settings.PositiveCachePolicy();
        this.negativeCachePolicy = settings.NegativeCachePolicy();
        this.log().debug("Using name servers [{}] and search domains [{}] with ndots={}", this.nameServers(), settings.SearchDomains(), BoxesRunTime.boxToInteger((int)settings.NDots()));
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = (List)clientFactory.apply((Object)this.context(), this.nameServers());
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void akka$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    public CachePolicy.CachePolicy positiveCachePolicy() {
        return this.positiveCachePolicy;
    }

    public CachePolicy.CachePolicy negativeCachePolicy() {
        return this.negativeCachePolicy;
    }

    private short nextId() {
        this.requestId = (short)(this.requestId + 1);
        return this.requestId;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final AsyncDnsResolver $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve resolve = DnsProtocol$Resolve$.MODULE$.unapply((DnsProtocol.Resolve)object);
                    String string = resolve._1();
                    DnsProtocol.RequestType requestType = resolve._2();
                    String name = string;
                    DnsProtocol.RequestType mode = requestType;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.RequestType requestType;
                    DnsProtocol.RequestType mode;
                    DnsProtocol.Resolve resolve = DnsProtocol$Resolve$.MODULE$.unapply((DnsProtocol.Resolve)object2);
                    String string = resolve._1();
                    String name = string;
                    Option<DnsProtocol.Resolved> option = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.get((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)(mode = (requestType = resolve._2()))));
                    if (option instanceof Some) {
                        DnsProtocol.Resolved resolved2 = (DnsProtocol.Resolved)((Some)option).value();
                        this.$outer.log().debug("{} cached {}", mode, resolved2);
                        this.$outer.sender().$bang(resolved2, this.$outer.self());
                    } else if (None$.MODULE$.equals(option)) {
                        akka.pattern.package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers).map((Function1 & Serializable)resolved -> {
                            if (resolved.records().nonEmpty()) {
                                CachePolicy.CachePolicy minTtl = (CachePolicy.CachePolicy)((IterableOnceOps)((SeqOps)resolved.records().map(AsyncDnsResolver::akka$io$dns$internal$AsyncDnsResolver$$anon$1$$_$_$$anonfun$1)).$plus$colon((Object)this.$outer.positiveCachePolicy())).min((Ordering)package$CachePolicyIsOrdered$.MODULE$);
                                this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)mode), (DnsProtocol.Resolved)resolved, minTtl);
                            } else {
                                CachePolicy.CachePolicy cachePolicy = this.$outer.negativeCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)mode), (DnsProtocol.Resolved)resolved, this.$outer.negativeCachePolicy());
                                }
                            }
                            this.$outer.log().debug("{} resolved {}", mode, resolved);
                            return resolved;
                        }, (ExecutionContext)this.$outer.ec()), (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                    } else {
                        throw new MatchError(option);
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(akka.io.dns.DnsProtocol$RequestType java.lang.String akka.io.dns.DnsProtocol$Resolved ), akka$io$dns$internal$AsyncDnsResolver$$anon$1$$_$_$$anonfun$1(akka.io.dns.ResourceRecord )}, serializedLambda);
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        Future future;
        if (AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$$isInetAddress(name)) {
            future = Future$.MODULE$.fromTry(Try$.MODULE$.apply(() -> AsyncDnsResolver.resolveWithResolvers$$anonfun$1(name)));
        } else {
            List<ActorRef> list = resolvers;
            Nil$ nil$ = package$.MODULE$.Nil();
            List<ActorRef> list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                future = Future$.MODULE$.failed((Throwable)AsyncDnsResolver$ResolveFailedException$.MODULE$.apply(new StringBuilder(37).append("Failed to resolve ").append(name).append(" with nameservers: ").append(this.nameServers()).toString()));
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                ActorRef head = (ActorRef)colon2.head();
                List tail = list3;
                future = this.resolveWithSearch(name, requestType, head).recoverWith((PartialFunction)new Serializable(name, requestType, tail, this){
                    private final String name$3;
                    private final DnsProtocol.RequestType requestType$1;
                    private final List tail$1;
                    private final AsyncDnsResolver $outer;
                    {
                        this.name$3 = name$8;
                        this.requestType$1 = requestType$3;
                        this.tail$1 = tail$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        boolean bl;
                        Option option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable t = throwable2 = (Throwable)option.get();
                            bl = true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Future<DnsProtocol.Resolved> future;
                        Option option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2 = (Throwable)option.get();
                            Throwable t = throwable2;
                            Throwable throwable3 = t;
                            if (throwable3 instanceof AskTimeoutException) {
                                this.$outer.log().info("Resolve of {} timed out after {}. Trying next name server", this.name$3, PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.timeout().duration())));
                            } else {
                                this.$outer.log().info("Resolve of {} failed. Trying next name server {}", this.name$3, t.getMessage());
                            }
                            future = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(this.name$3, this.requestType$1, (List<ActorRef>)this.tail$1);
                        } else {
                            future = function1.apply((Object)x);
                        }
                        return future;
                    }
                }, (ExecutionContext)this.ec());
            } else {
                throw new MatchError(list);
            }
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        void var3_3;
        Future result = AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result.failed().foreach((Function1)(JProcedure1 & Serializable)_$2 -> resolver.$bang(DnsClient$DropRequest$.MODULE$.apply(message.id()), this.self()), (ExecutionContext)this.ec());
        return var3_3;
    }

    private Future<DnsProtocol.Resolved> resolveWithSearch(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future<DnsProtocol.Resolved> future;
        if (this.settings.SearchDomains().nonEmpty()) {
            List nameWithSearch = this.settings.SearchDomains().map((Function1 & Serializable)sd -> new StringBuilder(1).append(name).append(".").append((String)sd).toString());
            List toResolve = StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(name), (Function1 & Serializable)_$3 -> AsyncDnsResolver.$anonfun$3(BoxesRunTime.unboxToChar((Object)_$3))) >= this.settings.NDots() ? nameWithSearch.$colon$colon((Object)name) : (List)nameWithSearch.$colon$plus((Object)name);
            future = this.resolveFirst((List<String>)toResolve, requestType, resolver);
        } else {
            future = this.resolve(name, requestType, resolver);
        }
        return future;
    }

    private Future<DnsProtocol.Resolved> resolveFirst(List<String> searchNames, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future future;
        List<String> list = searchNames;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            List list2 = colon2.next$access$1();
            String searchName = string;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list2;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                future = this.resolve(searchName, requestType, resolver);
            } else {
                String searchName2 = string;
                List remaining = list2;
                future = this.resolve(searchName2, requestType, resolver).flatMap((Function1 & Serializable)resolved -> resolved.records().isEmpty() ? this.resolveFirst((List<String>)remaining, requestType, resolver) : Future$.MODULE$.successful(resolved), (ExecutionContext)this.ec());
            }
        } else {
            Nil$ nil$ = package$.MODULE$.Nil();
            List<String> list4 = list;
            if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                future = Future$.MODULE$.failed((Throwable)new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
            } else {
                throw new MatchError(list);
            }
        }
        return future;
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future future;
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        DnsProtocol.RequestType requestType2 = requestType;
        if (requestType2 instanceof DnsProtocol.Ip) {
            DnsProtocol.Ip ip = DnsProtocol$Ip$.MODULE$.unapply((DnsProtocol.Ip)requestType2);
            boolean bl = ip._1();
            boolean bl2 = ip._2();
            boolean ipv42 = bl;
            boolean ipv6 = bl2;
            Future<DnsClient.Answer> ipv4Recs = ipv42 ? this.sendQuestion(resolver, DnsClient$Question4$.MODULE$.apply(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.akka$io$dns$internal$AsyncDnsResolver$$$Empty;
            Future<DnsClient.Answer> ipv6Recs = ipv6 ? this.sendQuestion(resolver, DnsClient$Question6$.MODULE$.apply(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.akka$io$dns$internal$AsyncDnsResolver$$$Empty;
            future = ipv4Recs.flatMap((Function1 & Serializable)ipv4 -> ipv6Recs.map((Function1 & Serializable)ipv6 -> DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)((Seq)ipv4.rrs().$plus$plus(ipv6.rrs())), (Seq<ResourceRecord>)((Seq)ipv4.additionalRecs().$plus$plus(ipv6.additionalRecs()))), (ExecutionContext)this.ec()), (ExecutionContext)this.ec());
        } else if (DnsProtocol$Srv$.MODULE$.equals(requestType2)) {
            future = this.sendQuestion(resolver, DnsClient$SrvQuestion$.MODULE$.apply(this.nextId(), caseFoldedName)).map((Function1 & Serializable)answer -> DnsProtocol$Resolved$.MODULE$.apply(name, answer.rrs(), answer.additionalRecs()), (ExecutionContext)this.ec());
        } else {
            throw new MatchError((Object)requestType2);
        }
        return future;
    }

    public static final /* synthetic */ CachePolicy.Ttl akka$io$dns$internal$AsyncDnsResolver$$anon$1$$_$_$$anonfun$1(ResourceRecord _$1) {
        return _$1.ttl();
    }

    private static final DnsProtocol.Resolved resolveWithResolvers$$anonfun$1(String name$2) {
        ResourceRecord resourceRecord;
        InetAddress address = InetAddress.getByName(name$2);
        InetAddress inetAddress = address;
        if (inetAddress instanceof Inet4Address) {
            resourceRecord = ARecord$.MODULE$.apply(name$2, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
        } else if (inetAddress instanceof Inet6Address) {
            Inet6Address ipv6address = (Inet6Address)inetAddress;
            resourceRecord = AAAARecord$.MODULE$.apply(name$2, CachePolicy$Ttl$.MODULE$.effectivelyForever(), ipv6address);
        } else {
            InetAddress unexpected = inetAddress;
            throw new IllegalArgumentException(new StringBuilder(20).append("Unexpected address: ").append(unexpected).toString());
        }
        ResourceRecord record = resourceRecord;
        return DnsProtocol$Resolved$.MODULE$.apply(name$2, (Seq<ResourceRecord>)package$.MODULE$.Nil().$colon$colon((Object)record));
    }

    private static final /* synthetic */ boolean $anonfun$3(char _$3) {
        return _$3 == '.';
    }

    public static class ResolveFailedException
    extends Exception
    implements Product {
        private final String msg;

        public static ResolveFailedException apply(String string) {
            return AsyncDnsResolver$ResolveFailedException$.MODULE$.apply(string);
        }

        public static ResolveFailedException fromProduct(Product product) {
            return AsyncDnsResolver$ResolveFailedException$.MODULE$.fromProduct(product);
        }

        public static ResolveFailedException unapply(ResolveFailedException resolveFailedException) {
            return AsyncDnsResolver$ResolveFailedException$.MODULE$.unapply(resolveFailedException);
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResolveFailedException)) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)object;
            String string = this.msg();
            String string2 = resolveFailedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ResolveFailedException;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ResolveFailedException";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "msg";
        }

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }
}

