/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Stash;
import akka.actor.StashSupport;
import akka.actor.UnrestrictedStash;
import akka.annotation.InternalApi;
import akka.dispatch.DequeBasedMessageQueueSemantics;
import akka.event.LoggingAdapter;
import akka.io.Tcp;
import akka.io.Tcp$CommandFailed$;
import akka.io.Tcp$Connect$;
import akka.io.Tcp$PeerClosed$;
import akka.io.Tcp$Received$;
import akka.io.Tcp$Register$;
import akka.io.Tcp$Write$;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.DnsClient;
import akka.io.dns.internal.DnsClient$Answer$;
import akka.io.dns.internal.Message;
import akka.io.dns.internal.Message$;
import akka.io.dns.internal.MessageFlags$;
import akka.io.dns.internal.ResponseCode$;
import akka.io.dns.internal.TcpDnsClient$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.net.InetSocketAddress;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@InternalApi
public class TcpDnsClient
implements Actor,
ActorLogging,
StashSupport,
UnrestrictedStash,
Stash {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private Vector akka$actor$StashSupport$$theStash;
    private int akka$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    public final ActorRef akka$io$dns$internal$TcpDnsClient$$tcp;
    public final InetSocketAddress akka$io$dns$internal$TcpDnsClient$$ns;
    public final ActorRef akka$io$dns$internal$TcpDnsClient$$answerRecipient;
    private final PartialFunction idle;
    private final PartialFunction connecting;

    public static int decodeLength(ByteString byteString) {
        return TcpDnsClient$.MODULE$.decodeLength(byteString);
    }

    public static ByteString encodeLength(int n) {
        return TcpDnsClient$.MODULE$.encodeLength(n);
    }

    public static void throwFailure(String string, Option<Throwable> option) {
        TcpDnsClient$.MODULE$.throwFailure(string, option);
    }

    public TcpDnsClient(ActorRef tcp, InetSocketAddress ns, ActorRef answerRecipient) {
        this.akka$io$dns$internal$TcpDnsClient$$tcp = tcp;
        this.akka$io$dns$internal$TcpDnsClient$$ns = ns;
        this.akka$io$dns$internal$TcpDnsClient$$answerRecipient = answerRecipient;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        StashSupport.$init$(this);
        this.idle = new Serializable(this){
            private final TcpDnsClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return object instanceof Message;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof Message) {
                    this.$outer.stash();
                    this.$outer.log().debug("Connecting to [{}]", this.$outer.akka$io$dns$internal$TcpDnsClient$$ns);
                    this.$outer.akka$io$dns$internal$TcpDnsClient$$tcp.$bang(Tcp$Connect$.MODULE$.apply(this.$outer.akka$io$dns$internal$TcpDnsClient$$ns, Tcp$Connect$.MODULE$.$lessinit$greater$default$2(), Tcp$Connect$.MODULE$.$lessinit$greater$default$3(), Tcp$Connect$.MODULE$.$lessinit$greater$default$4(), Tcp$Connect$.MODULE$.$lessinit$greater$default$5()), this.$outer.self());
                    this.$outer.context().become(this.$outer.connecting());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
        this.connecting = new Serializable(this){
            private final TcpDnsClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Tcp.CommandFailed commandFailed;
                Tcp.CommandFailed commandFailed2;
                Tcp.Command command;
                Object object = x;
                if (object instanceof Tcp.CommandFailed && (command = (commandFailed2 = Tcp$CommandFailed$.MODULE$.unapply(commandFailed = (Tcp.CommandFailed)object))._1()) instanceof Tcp.Connect) {
                    Tcp.CommandFailed failure = commandFailed;
                    bl = true;
                } else {
                    bl = object instanceof Tcp.Connected ? true : object instanceof Message;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Tcp.CommandFailed commandFailed;
                Tcp.CommandFailed commandFailed2;
                Tcp.Command command;
                Object object2 = x;
                if (object2 instanceof Tcp.CommandFailed && (command = (commandFailed2 = Tcp$CommandFailed$.MODULE$.unapply(commandFailed = (Tcp.CommandFailed)object2))._1()) instanceof Tcp.Connect) {
                    Tcp.CommandFailed failure = commandFailed;
                    TcpDnsClient$.MODULE$.throwFailure(new StringBuilder(41).append("Failed to connect to TCP DNS server at [").append(this.$outer.akka$io$dns$internal$TcpDnsClient$$ns).append("]").toString(), failure.cause());
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Tcp.Connected) {
                    this.$outer.log().debug("Connected to TCP address [{}]", this.$outer.akka$io$dns$internal$TcpDnsClient$$ns);
                    ActorRef connection = this.$outer.sender();
                    this.$outer.context().become(this.$outer.ready(connection, this.$outer.ready$default$2()));
                    connection.$bang(Tcp$Register$.MODULE$.apply(this.$outer.self(), Tcp$Register$.MODULE$.$lessinit$greater$default$2(), Tcp$Register$.MODULE$.$lessinit$greater$default$3()), this.$outer.self());
                    this.$outer.unstashAll();
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Message) {
                    this.$outer.stash();
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void akka$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public Vector akka$actor$StashSupport$$theStash() {
        return this.akka$actor$StashSupport$$theStash;
    }

    @Override
    public int akka$actor$StashSupport$$capacity() {
        return this.akka$actor$StashSupport$$capacity;
    }

    @Override
    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public void akka$actor$StashSupport$$theStash_$eq(Vector x$1) {
        this.akka$actor$StashSupport$$theStash = x$1;
    }

    @Override
    public void akka$actor$StashSupport$_setter_$akka$actor$StashSupport$$capacity_$eq(int x$0) {
        this.akka$actor$StashSupport$$capacity = x$0;
    }

    @Override
    public void akka$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$0) {
        this.mailbox = x$0;
    }

    @Override
    public /* synthetic */ void akka$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public /* synthetic */ void akka$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$(this);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return this.idle();
    }

    public PartialFunction<Object, BoxedUnit> idle() {
        return this.idle;
    }

    public PartialFunction<Object, BoxedUnit> connecting() {
        return this.connecting;
    }

    public PartialFunction<Object, BoxedUnit> ready(ActorRef connection, ByteString buffer) {
        return new Serializable(connection, buffer, this){
            private final ActorRef connection$1;
            private final ByteString buffer$1;
            private final TcpDnsClient $outer;
            {
                this.connection$1 = connection$2;
                this.buffer$1 = buffer$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Tcp.CommandFailed commandFailed;
                Tcp.CommandFailed commandFailed2;
                Tcp.Command command;
                boolean bl;
                Object object = x;
                if (object instanceof Message) {
                    Message msg = (Message)object;
                    bl = true;
                } else if (object instanceof Tcp.CommandFailed && (command = (commandFailed2 = Tcp$CommandFailed$.MODULE$.unapply(commandFailed = (Tcp.CommandFailed)object))._1()) instanceof Tcp.Write) {
                    Tcp.CommandFailed failure = commandFailed;
                    bl = true;
                } else if (object instanceof Tcp.Received) {
                    ByteString byteString;
                    Tcp.Received received = Tcp$Received$.MODULE$.unapply((Tcp.Received)object);
                    ByteString newData = byteString = received._1();
                    bl = true;
                } else {
                    bl = Tcp$PeerClosed$.MODULE$.equals(object);
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Tcp.CommandFailed commandFailed;
                Tcp.CommandFailed commandFailed2;
                Tcp.Command command;
                Object object;
                Object object2 = x;
                if (object2 instanceof Message) {
                    Message msg = (Message)object2;
                    ByteString bytes = msg.write();
                    this.connection$1.$bang(Tcp$Write$.MODULE$.apply(TcpDnsClient$.MODULE$.encodeLength(bytes.length()).$plus$plus(bytes)), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Tcp.CommandFailed && (command = (commandFailed2 = Tcp$CommandFailed$.MODULE$.unapply(commandFailed = (Tcp.CommandFailed)object2))._1()) instanceof Tcp.Write) {
                    Tcp.CommandFailed failure = commandFailed;
                    TcpDnsClient$.MODULE$.throwFailure("Write failed", failure.cause());
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Tcp.Received) {
                    ByteString byteString;
                    Tcp.Received received = Tcp$Received$.MODULE$.unapply((Tcp.Received)object2);
                    ByteString newData = byteString = received._1();
                    ByteString data = this.buffer$1.$plus$plus(newData);
                    int prefixSize = 2;
                    if (data.length() < prefixSize) {
                        this.$outer.context().become(this.$outer.ready(this.connection$1, data));
                        object = BoxedUnit.UNIT;
                    } else {
                        int expectedPayloadLength = TcpDnsClient$.MODULE$.decodeLength(data);
                        if (data.drop(prefixSize).length() < expectedPayloadLength) {
                            this.$outer.context().become(this.$outer.ready(this.connection$1, data));
                            object = BoxedUnit.UNIT;
                        } else {
                            this.$outer.akka$io$dns$internal$TcpDnsClient$$answerRecipient.$bang(this.$outer.akka$io$dns$internal$TcpDnsClient$$parseResponse(data.drop(prefixSize)), this.$outer.self());
                            this.$outer.context().become(this.$outer.ready(this.connection$1, ByteString$.MODULE$.empty()));
                            if (data.length() > prefixSize + expectedPayloadLength) {
                                this.$outer.self().$bang(Tcp$Received$.MODULE$.apply(data.drop(prefixSize + expectedPayloadLength)), this.$outer.self());
                                object = BoxedUnit.UNIT;
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        }
                    }
                } else if (Tcp$PeerClosed$.MODULE$.equals(object2)) {
                    this.$outer.context().become(this.$outer.idle());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
    }

    public ByteString ready$default$2() {
        return ByteString$.MODULE$.empty();
    }

    public DnsClient.Answer akka$io$dns$internal$TcpDnsClient$$parseResponse(ByteString data) {
        Message msg = Message$.MODULE$.parse(data);
        this.log().debug("Decoded TCP DNS response [{}]", msg);
        if (MessageFlags$.MODULE$.isTruncated$extension(msg.flags())) {
            this.log().warning("TCP DNS response truncated");
        }
        Enumeration.Value value = MessageFlags$.MODULE$.responseCode$extension(msg.flags());
        Enumeration.Value value2 = ResponseCode$.MODULE$.SUCCESS();
        Tuple2 tuple2 = !(value != null ? !value.equals(value2) : value2 != null) ? Tuple2$.MODULE$.apply(msg.answerRecs(), msg.additionalRecs()) : Tuple2$.MODULE$.apply((Object)package$.MODULE$.Nil(), (Object)package$.MODULE$.Nil());
        Seq recs = (Seq)tuple2._1();
        Seq additionalRecs = (Seq)tuple2._2();
        return DnsClient$Answer$.MODULE$.apply(msg.id(), (Seq<ResourceRecord>)recs, (Seq<ResourceRecord>)additionalRecs);
    }
}

