/*
 * Decompiled with CFR 0.152.
 */
package akka.pattern;

import akka.actor.Scheduler;
import akka.pattern.BackoffSupervisor$;
import akka.pattern.RetrySupport$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;

public interface RetrySupport {
    public static Future retry$(RetrySupport $this, Function0 attempt, int attempts, ExecutionContext ec) {
        return $this.retry(attempt, attempts, ec);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, int attempts, ExecutionContext ec) {
        return RetrySupport$.MODULE$.akka$pattern$RetrySupport$$$retry(attempt, attempts, 0, ec);
    }

    public static Future retry$(RetrySupport $this, Function0 attempt, int attempts, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, ExecutionContext ec, Scheduler scheduler) {
        return $this.retry(attempt, attempts, minBackoff, maxBackoff, randomFactor, ec, scheduler);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, int attempts, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, ExecutionContext ec, Scheduler scheduler) {
        Predef$.MODULE$.require(attempt != null, RetrySupport::retry$$anonfun$1);
        Predef$.MODULE$.require(minBackoff != null, RetrySupport::retry$$anonfun$2);
        Predef$.MODULE$.require(maxBackoff != null, RetrySupport::retry$$anonfun$3);
        Predef$.MODULE$.require(minBackoff.$greater((Object)Duration$.MODULE$.Zero()), RetrySupport::retry$$anonfun$4);
        Predef$.MODULE$.require(maxBackoff.$greater$eq((Object)minBackoff), RetrySupport::retry$$anonfun$5);
        Predef$.MODULE$.require(0.0 <= randomFactor && randomFactor <= 1.0, RetrySupport::retry$$anonfun$6);
        return this.retry(attempt, attempts, (Function1<Object, Option<FiniteDuration>>)(Function1 & Serializable)attempted -> Some$.MODULE$.apply((Object)BackoffSupervisor$.MODULE$.calculateDelay(BoxesRunTime.unboxToInt((Object)attempted), minBackoff, maxBackoff, randomFactor)), ec, scheduler);
    }

    public static Future retry$(RetrySupport $this, Function0 attempt, int attempts, FiniteDuration delay, ExecutionContext ec, Scheduler scheduler) {
        return $this.retry(attempt, attempts, delay, ec, scheduler);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, int attempts, FiniteDuration delay, ExecutionContext ec, Scheduler scheduler) {
        return this.retry(attempt, attempts, (Function1<Object, Option<FiniteDuration>>)(Function1 & Serializable)_$1 -> Some$.MODULE$.apply((Object)delay), ec, scheduler);
    }

    public static Future retry$(RetrySupport $this, Function0 attempt, int attempts, Function1 delayFunction, ExecutionContext ec, Scheduler scheduler) {
        return $this.retry(attempt, attempts, (Function1<Object, Option<FiniteDuration>>)delayFunction, ec, scheduler);
    }

    default public <T> Future<T> retry(Function0<Future<T>> attempt, int attempts, Function1<Object, Option<FiniteDuration>> delayFunction, ExecutionContext ec, Scheduler scheduler) {
        return RetrySupport$.MODULE$.akka$pattern$RetrySupport$$$retry(attempt, attempts, delayFunction, 0, ec, scheduler);
    }

    private static String retry$$anonfun$1() {
        return "Parameter attempt should not be null.";
    }

    private static String retry$$anonfun$2() {
        return "Parameter minBackoff should not be null.";
    }

    private static String retry$$anonfun$3() {
        return "Parameter maxBackoff should not be null.";
    }

    private static String retry$$anonfun$4() {
        return "Parameter minBackoff must be > 0";
    }

    private static String retry$$anonfun$5() {
        return "Parameter maxBackoff must be >= minBackoff";
    }

    private static String retry$$anonfun$6() {
        return "randomFactor must be between 0.0 and 1.0";
    }
}

