/*
 * Decompiled with CFR 0.152.
 */
package akka.pattern.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.OneForOneStrategy;
import akka.actor.OneForOneStrategy$;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.actor.SupervisorStrategy$Escalate$;
import akka.actor.SupervisorStrategy$Restart$;
import akka.actor.SupervisorStrategy$Stop$;
import akka.actor.Terminated;
import akka.actor.Terminated$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.pattern.BackoffReset;
import akka.pattern.BackoffSupervisor$;
import akka.pattern.BackoffSupervisor$ResetRestartCount$;
import akka.pattern.BackoffSupervisor$StartChild$;
import akka.pattern.ForwardDeathLetters$;
import akka.pattern.ForwardTo;
import akka.pattern.ForwardTo$;
import akka.pattern.HandleBackoff;
import akka.pattern.HandlingWhileStopped;
import akka.pattern.ReplyWith;
import akka.pattern.ReplyWith$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;

@InternalApi
public class BackoffOnRestartSupervisor
implements Actor,
HandleBackoff,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private Option child;
    private int restartCount;
    private boolean finalStopMessageReceived;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final Props childProps;
    private final String childName;
    public final FiniteDuration akka$pattern$internal$BackoffOnRestartSupervisor$$minBackoff;
    public final FiniteDuration akka$pattern$internal$BackoffOnRestartSupervisor$$maxBackoff;
    private final BackoffReset reset;
    public final double akka$pattern$internal$BackoffOnRestartSupervisor$$randomFactor;
    public final OneForOneStrategy akka$pattern$internal$BackoffOnRestartSupervisor$$strategy;
    private final HandlingWhileStopped handlingWhileStopped;
    private final OneForOneStrategy supervisorStrategy;

    public BackoffOnRestartSupervisor(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, BackoffReset reset, double randomFactor, OneForOneStrategy strategy, HandlingWhileStopped handlingWhileStopped) {
        this.childProps = childProps;
        this.childName = childName;
        this.akka$pattern$internal$BackoffOnRestartSupervisor$$minBackoff = minBackoff;
        this.akka$pattern$internal$BackoffOnRestartSupervisor$$maxBackoff = maxBackoff;
        this.reset = reset;
        this.akka$pattern$internal$BackoffOnRestartSupervisor$$randomFactor = randomFactor;
        this.akka$pattern$internal$BackoffOnRestartSupervisor$$strategy = strategy;
        this.handlingWhileStopped = handlingWhileStopped;
        Actor.$init$(this);
        HandleBackoff.$init$(this);
        ActorLogging.$init$(this);
        PartialFunction<Throwable, SupervisorStrategy.Directive> decider = Actor.supervisorStrategy$(this).decider();
        this.supervisorStrategy = OneForOneStrategy$.MODULE$.apply(strategy.maxNrOfRetries(), strategy.withinTimeRange(), strategy.loggingEnabled(), (PartialFunction<Throwable, SupervisorStrategy.Directive>)new Serializable(decider, this){
            private final PartialFunction decider$1;
            private final BackoffOnRestartSupervisor $outer;
            {
                this.decider$1 = decider$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                SupervisorStrategy.Directive directive;
                Throwable throwable;
                Throwable ex = throwable = x;
                SupervisorStrategy.Directive defaultDirective = (SupervisorStrategy.Directive)this.decider$1.applyOrElse((Object)ex, BackoffOnRestartSupervisor::akka$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$_$$anonfun$1);
                SupervisorStrategy.Directive directive2 = (SupervisorStrategy.Directive)this.$outer.akka$pattern$internal$BackoffOnRestartSupervisor$$strategy.decider().applyOrElse((Object)ex, arg_0 -> BackoffOnRestartSupervisor.akka$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$applyOrElse$$anonfun$1(defaultDirective, arg_0));
                if (SupervisorStrategy$Restart$.MODULE$.equals(directive2)) {
                    int nextRestartCount = this.$outer.restartCount() + 1;
                    if (this.$outer.akka$pattern$internal$BackoffOnRestartSupervisor$$strategy.withinTimeRange().isFinite() && this.$outer.restartCount() == 0) {
                        FiniteDuration finiteWithinTimeRange = (FiniteDuration)this.$outer.akka$pattern$internal$BackoffOnRestartSupervisor$$strategy.withinTimeRange();
                        this.$outer.context().system().scheduler().scheduleOnce(finiteWithinTimeRange, this.$outer.self(), (Object)BackoffSupervisor$ResetRestartCount$.MODULE$.apply(nextRestartCount), (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self());
                    }
                    ActorRef childRef = this.$outer.sender();
                    if (this.$outer.akka$pattern$internal$BackoffOnRestartSupervisor$$strategy.maxNrOfRetries() >= 0 && nextRestartCount > this.$outer.akka$pattern$internal$BackoffOnRestartSupervisor$$strategy.maxNrOfRetries()) {
                        this.$outer.log().debug("Terminating on restart #{} which exceeds max allowed restarts ({})", BoxesRunTime.boxToInteger((int)nextRestartCount), BoxesRunTime.boxToInteger((int)this.$outer.akka$pattern$internal$BackoffOnRestartSupervisor$$strategy.maxNrOfRetries()));
                        this.$outer.context().become(this.$outer.receive());
                        this.$outer.context().stop(this.$outer.self());
                    } else {
                        this.$outer.context().become((PartialFunction<Object, BoxedUnit>)this.$outer.waitChildTerminatedBeforeBackoff(childRef).orElse(this.$outer.handleBackoff()));
                    }
                    directive = SupervisorStrategy$Stop$.MODULE$;
                } else {
                    SupervisorStrategy.Directive other;
                    directive = other = directive2;
                }
                return directive;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{akka$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$_$$anonfun$1(java.lang.Object ), akka$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$applyOrElse$$anonfun$1(akka.actor.SupervisorStrategy$Directive java.lang.Object )}, serializedLambda);
            }
        });
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void akka$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Option child() {
        return this.child;
    }

    @Override
    public int restartCount() {
        return this.restartCount;
    }

    @Override
    public boolean finalStopMessageReceived() {
        return this.finalStopMessageReceived;
    }

    public void child_$eq(Option x$1) {
        this.child = x$1;
    }

    @Override
    public void restartCount_$eq(int x$1) {
        this.restartCount = x$1;
    }

    @Override
    public void finalStopMessageReceived_$eq(boolean x$1) {
        this.finalStopMessageReceived = x$1;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public Props childProps() {
        return this.childProps;
    }

    @Override
    public String childName() {
        return this.childName;
    }

    @Override
    public BackoffReset reset() {
        return this.reset;
    }

    @Override
    public OneForOneStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    public PartialFunction<Object, BoxedUnit> waitChildTerminatedBeforeBackoff(ActorRef childRef) {
        return new Serializable(childRef, this){
            private final ActorRef childRef$1;
            private final BackoffOnRestartSupervisor $outer;
            {
                this.childRef$1 = childRef$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    ActorRef actorRef2 = this.childRef$1;
                    ActorRef actorRef3 = actorRef;
                    if (actorRef2 == null) {
                        if (actorRef3 == null) return true;
                    } else if (((Object)actorRef2).equals(actorRef3)) {
                        return true;
                    }
                }
                if (!BackoffSupervisor$StartChild$.MODULE$.equals(object)) return false;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object2);
                    ActorRef actorRef = terminated._1();
                    ActorRef actorRef2 = this.childRef$1;
                    ActorRef actorRef3 = actorRef;
                    if (!(actorRef2 != null ? !((Object)actorRef2).equals(actorRef3) : actorRef3 != null)) {
                        this.$outer.context().become(this.$outer.receive());
                        this.$outer.child_$eq((Option)None$.MODULE$);
                        FiniteDuration restartDelay = BackoffSupervisor$.MODULE$.calculateDelay(this.$outer.restartCount(), this.$outer.akka$pattern$internal$BackoffOnRestartSupervisor$$minBackoff, this.$outer.akka$pattern$internal$BackoffOnRestartSupervisor$$maxBackoff, this.$outer.akka$pattern$internal$BackoffOnRestartSupervisor$$randomFactor);
                        this.$outer.context().system().scheduler().scheduleOnce(restartDelay, this.$outer.self(), (Object)BackoffSupervisor$StartChild$.MODULE$, (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self());
                        this.$outer.restartCount_$eq(this.$outer.restartCount() + 1);
                        object = BoxedUnit.UNIT;
                        return object;
                    }
                }
                if (BackoffSupervisor$StartChild$.MODULE$.equals(object2)) {
                    object = BoxedUnit.UNIT;
                    return object;
                }
                object = function1.apply(x);
                return object;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> onTerminated() {
        return new Serializable(this){
            private final BackoffOnRestartSupervisor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef c = actorRef = terminated._1();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object2);
                    ActorRef c = actorRef = terminated._1();
                    this.$outer.log().debug(new StringBuilder(47).append("Terminating, because child [").append(c).append("] terminated itself").toString());
                    this.$outer.context().stop(this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return this.onTerminated().orElse(this.handleBackoff());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleMessageToChild(Object msg) {
        Option option = this.child();
        if (option instanceof Some) {
            ActorRef c = (ActorRef)((Some)option).value();
            c.forward(msg, this.context());
            return;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            HandlingWhileStopped handlingWhileStopped = this.handlingWhileStopped;
            if (ForwardDeathLetters$.MODULE$.equals(handlingWhileStopped)) {
                this.context().system().deadLetters().forward(msg, this.context());
                return;
            } else if (handlingWhileStopped instanceof ForwardTo) {
                ActorRef actorRef;
                ForwardTo forwardTo = ForwardTo$.MODULE$.unapply((ForwardTo)handlingWhileStopped);
                ActorRef h = actorRef = forwardTo._1();
                h.forward(msg, this.context());
                return;
            } else {
                Object object;
                if (!(handlingWhileStopped instanceof ReplyWith)) throw new MatchError((Object)handlingWhileStopped);
                ReplyWith replyWith = ReplyWith$.MODULE$.unapply((ReplyWith)handlingWhileStopped);
                Object r = object = replyWith._1();
                this.sender().$bang(r, this.self());
            }
        }
    }

    public static final /* synthetic */ SupervisorStrategy.Directive akka$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$_$$anonfun$1(Object _$1) {
        return SupervisorStrategy$Escalate$.MODULE$;
    }

    public static final /* synthetic */ SupervisorStrategy.Directive akka$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$applyOrElse$$anonfun$1(SupervisorStrategy.Directive defaultDirective$1, Object _$2) {
        return defaultDirective$1;
    }
}

