/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.ActorSystemImpl;
import akka.actor.InternalActorRef;
import akka.actor.Props;
import akka.dispatch.Envelope;
import akka.dispatch.Envelope$;
import akka.dispatch.MessageDispatcher;
import akka.routing.OptimalSizeExploringResizer;
import akka.routing.Pool;
import akka.routing.ResizablePoolActor$Resize$;
import akka.routing.Resizer;
import akka.routing.RoutedActorCell;
import akka.routing.Routee;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Vector;
import scala.package$;

public final class ResizablePoolCell
extends RoutedActorCell {
    private final Pool pool;
    private final Resizer resizer;
    private final AtomicBoolean resizeInProgress;
    private final AtomicLong resizeCounter;

    public ResizablePoolCell(ActorSystemImpl _system, InternalActorRef _ref, Props _routerProps, MessageDispatcher _routerDispatcher, Props _routeeProps, InternalActorRef _supervisor, Pool pool) {
        this.pool = pool;
        super(_system, _ref, _routerProps, _routerDispatcher, _routeeProps, _supervisor);
        Predef$.MODULE$.require(pool.resizer().isDefined(), ResizablePoolCell::$init$$$anonfun$1);
        this.resizer = (Resizer)pool.resizer().get();
        this.resizeInProgress = new AtomicBoolean();
        this.resizeCounter = new AtomicLong();
    }

    public Pool pool() {
        return this.pool;
    }

    public Resizer resizer() {
        return this.resizer;
    }

    @Override
    public void preSuperStart() {
        if (this.resizer().isTimeForResize(this.resizeCounter.getAndIncrement())) {
            this.resize(true);
        }
    }

    @Override
    public void sendMessage(Envelope envelope) {
        if (!this.routerConfig().isManagementMessage(envelope.message()) && this.resizer().isTimeForResize(this.resizeCounter.getAndIncrement()) && this.resizeInProgress.compareAndSet(false, true)) {
            super.sendMessage(Envelope$.MODULE$.apply(ResizablePoolActor$Resize$.MODULE$, this.self(), this.system()));
        }
        super.sendMessage(envelope);
    }

    public void resize(boolean initial) {
        if (this.resizeInProgress.get() || initial) {
            try {
                this.tryReportMessageCount();
                int requestedCapacity = this.resizer().resize(this.router().routees());
                if (requestedCapacity > 0) {
                    Vector newRoutees = (Vector)package$.MODULE$.Vector().fill(requestedCapacity, this::$anonfun$1);
                    this.addRoutees((Iterable<Routee>)newRoutees);
                } else if (requestedCapacity < 0) {
                    IndexedSeq<Routee> currentRoutees = this.router().routees();
                    IndexedSeq abandon = (IndexedSeq)currentRoutees.drop(currentRoutees.length() + requestedCapacity);
                    this.removeRoutees((Iterable<Routee>)abandon, true);
                }
            }
            finally {
                this.resizeInProgress.set(false);
            }
        }
    }

    private void tryReportMessageCount() {
        block0: {
            Resizer resizer = this.resizer();
            if (!(resizer instanceof OptimalSizeExploringResizer)) break block0;
            OptimalSizeExploringResizer r = (OptimalSizeExploringResizer)resizer;
            r.reportMessageCount(this.router().routees(), this.resizeCounter.get());
        }
    }

    private static final String $init$$$anonfun$1() {
        return "RouterConfig must be a Pool with defined resizer";
    }

    private final Routee $anonfun$1() {
        return this.pool().newRoutee(this.routeeProps(), this);
    }
}

