/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.InternalActorRef;
import akka.japi.Util$;
import akka.routing.ActorRefRoutee$;
import akka.routing.ActorSelectionRoutee$;
import akka.routing.Broadcast;
import akka.routing.Broadcast$;
import akka.routing.NoRoutee$;
import akka.routing.Routee;
import akka.routing.Router$;
import akka.routing.RouterEnvelope;
import akka.routing.RoutingLogic;
import akka.routing.SeveralRoutees$;
import java.io.Serializable;
import scala.Function1;
import scala.Product;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Router
implements Product,
Serializable {
    private final RoutingLogic logic;
    private final IndexedSeq routees;

    public static Router apply(RoutingLogic routingLogic, IndexedSeq<Routee> indexedSeq) {
        return Router$.MODULE$.apply(routingLogic, indexedSeq);
    }

    public static Router fromProduct(Product product) {
        return Router$.MODULE$.fromProduct(product);
    }

    public static Router unapply(Router router) {
        return Router$.MODULE$.unapply(router);
    }

    public static IndexedSeq<Routee> $lessinit$greater$default$2() {
        return Router$.MODULE$.$lessinit$greater$default$2();
    }

    public Router(RoutingLogic logic, IndexedSeq<Routee> routees) {
        this.logic = logic;
        this.routees = routees;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Router)) return false;
        Router router = (Router)object;
        RoutingLogic routingLogic = this.logic();
        RoutingLogic routingLogic2 = router.logic();
        if (routingLogic == null) {
            if (routingLogic2 != null) {
                return false;
            }
        } else if (!routingLogic.equals(routingLogic2)) return false;
        IndexedSeq<Routee> indexedSeq = this.routees();
        IndexedSeq<Routee> indexedSeq2 = router.routees();
        if (indexedSeq == null) {
            if (indexedSeq2 == null) return true;
            return false;
        } else {
            if (!indexedSeq.equals(indexedSeq2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Router;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Router";
    }

    public Object productElement(int n) {
        IndexedSeq<Routee> indexedSeq;
        int n2 = n;
        if (0 == n2) {
            indexedSeq = this._1();
        } else if (1 == n2) {
            indexedSeq = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return indexedSeq;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "logic";
        } else if (1 == n2) {
            string = "routees";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public RoutingLogic logic() {
        return this.logic;
    }

    public IndexedSeq<Routee> routees() {
        return this.routees;
    }

    public Router(RoutingLogic logic) {
        this(logic, (IndexedSeq<Routee>)package$.MODULE$.Vector().empty());
    }

    public Router(RoutingLogic logic, Iterable<Routee> routees) {
        this(logic, (IndexedSeq<Routee>)Util$.MODULE$.immutableSeq(routees).toVector());
    }

    public void route(Object message, ActorRef sender) {
        Object object = message;
        if (object instanceof Broadcast) {
            Object object2;
            Broadcast broadcast = Broadcast$.MODULE$.unapply((Broadcast)object);
            Object msg = object2 = broadcast._1();
            SeveralRoutees$.MODULE$.apply(this.routees()).send(msg, sender);
        } else {
            Object msg = object;
            this.send(this.logic().select(msg, this.routees()), message, sender);
        }
    }

    private void send(Routee routee, Object msg, ActorRef sender) {
        Routee routee2 = routee;
        NoRoutee$ noRoutee$ = NoRoutee$.MODULE$;
        if (!(routee2 != null ? !routee2.equals(noRoutee$) : noRoutee$ != null) && sender instanceof InternalActorRef) {
            ((InternalActorRef)sender).provider().deadLetters().tell(this.unwrap(msg), sender);
        } else {
            routee.send(this.unwrap(msg), sender);
        }
    }

    private Object unwrap(Object msg) {
        Object object;
        Object object2 = msg;
        if (object2 instanceof RouterEnvelope) {
            RouterEnvelope env = (RouterEnvelope)object2;
            object = env.message();
        } else {
            object = msg;
        }
        return object;
    }

    public Router withRoutees(IndexedSeq<Routee> rs) {
        return this.copy(this.copy$default$1(), rs);
    }

    public Router addRoutee(Routee routee) {
        IndexedSeq indexedSeq = (IndexedSeq)this.routees().$colon$plus((Object)routee);
        RoutingLogic routingLogic = this.copy$default$1();
        return this.copy(routingLogic, (IndexedSeq<Routee>)indexedSeq);
    }

    public Router addRoutee(ActorRef ref) {
        return this.addRoutee(ActorRefRoutee$.MODULE$.apply(ref));
    }

    public Router addRoutee(ActorSelection sel) {
        return this.addRoutee(ActorSelectionRoutee$.MODULE$.apply(sel));
    }

    public Router removeRoutee(Routee routee) {
        IndexedSeq indexedSeq = (IndexedSeq)this.routees().filterNot((Function1 & Serializable)_$2 -> {
            Routee routee = _$2;
            Routee routee2 = routee;
            return !(routee != null ? !routee.equals(routee2) : routee2 != null);
        });
        RoutingLogic routingLogic = this.copy$default$1();
        return this.copy(routingLogic, (IndexedSeq<Routee>)indexedSeq);
    }

    public Router removeRoutee(ActorRef ref) {
        return this.removeRoutee(ActorRefRoutee$.MODULE$.apply(ref));
    }

    public Router removeRoutee(ActorSelection sel) {
        return this.removeRoutee(ActorSelectionRoutee$.MODULE$.apply(sel));
    }

    public Router copy(RoutingLogic logic, IndexedSeq<Routee> routees) {
        return new Router(logic, routees);
    }

    public RoutingLogic copy$default$1() {
        return this.logic();
    }

    public IndexedSeq<Routee> copy$default$2() {
        return this.routees();
    }

    public RoutingLogic _1() {
        return this.logic();
    }

    public IndexedSeq<Routee> _2() {
        return this.routees();
    }
}

