/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorInitializationException$;
import akka.actor.ActorRef;
import akka.actor.Terminated;
import akka.actor.Terminated$;
import akka.routing.ActorRefRoutee$;
import akka.routing.AddRoutee;
import akka.routing.AddRoutee$;
import akka.routing.GetRoutees$;
import akka.routing.RemoveRoutee;
import akka.routing.RemoveRoutee$;
import akka.routing.RoutedActorCell;
import akka.routing.Routee;
import akka.routing.Routees$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class RouterActor
implements Actor {
    private ActorContext context;
    private ActorRef self;
    private final RoutedActorCell cell;
    private final Option routingLogicController;

    public RouterActor() {
        Actor.$init$(this);
        ActorContext actorContext = this.context();
        if (!(actorContext instanceof RoutedActorCell)) {
            throw ActorInitializationException$.MODULE$.apply(new StringBuilder(56).append("Router actor can only be used in RoutedActorRef, not in ").append(this.context().getClass()).toString());
        }
        RoutedActorCell x = (RoutedActorCell)actorContext;
        this.cell = x;
        this.routingLogicController = this.cell().routerConfig().routingLogicController(this.cell().router().logic()).map((Function1 & Serializable)props -> this.context().actorOf(props.withDispatcher(this.context().props().dispatcher()), "routingLogicController"));
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void akka$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public RoutedActorCell cell() {
        return this.cell;
    }

    public Option<ActorRef> routingLogicController() {
        return this.routingLogicController;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final RouterActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (GetRoutees$.MODULE$.equals(object)) {
                    bl = true;
                } else if (object instanceof AddRoutee) {
                    Routee routee;
                    AddRoutee addRoutee = AddRoutee$.MODULE$.unapply((AddRoutee)object);
                    Routee routee2 = routee = addRoutee._1();
                    bl = true;
                } else if (object instanceof RemoveRoutee) {
                    Routee routee;
                    RemoveRoutee removeRoutee = RemoveRoutee$.MODULE$.unapply((RemoveRoutee)object);
                    Routee routee3 = routee = removeRoutee._1();
                    bl = true;
                } else if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef child = actorRef = terminated._1();
                    bl = true;
                } else {
                    Object other = object;
                    bl = this.$outer.routingLogicController().isDefined();
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (GetRoutees$.MODULE$.equals(object2)) {
                    this.$outer.sender().$bang(Routees$.MODULE$.apply(this.$outer.cell().router().routees()), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof AddRoutee) {
                    Routee routee;
                    AddRoutee addRoutee = AddRoutee$.MODULE$.unapply((AddRoutee)object2);
                    Routee routee2 = routee = addRoutee._1();
                    this.$outer.cell().addRoutee(routee2);
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof RemoveRoutee) {
                    Routee routee;
                    RemoveRoutee removeRoutee = RemoveRoutee$.MODULE$.unapply((RemoveRoutee)object2);
                    Routee routee3 = routee = removeRoutee._1();
                    this.$outer.cell().removeRoutee(routee3, true);
                    this.$outer.stopIfAllRouteesRemoved();
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object2);
                    ActorRef child = actorRef = terminated._1();
                    this.$outer.cell().removeRoutee(ActorRefRoutee$.MODULE$.apply(child), false);
                    this.$outer.stopIfAllRouteesRemoved();
                    object = BoxedUnit.UNIT;
                } else {
                    Object other = object2;
                    if (this.$outer.routingLogicController().isDefined()) {
                        this.$outer.routingLogicController().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.forward(other, this.$outer.context()));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x);
                    }
                }
                return object;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.Object akka.actor.ActorRef )}, serializedLambda);
            }
        };
    }

    public void stopIfAllRouteesRemoved() {
        if (this.cell().router().routees().isEmpty() && this.cell().routerConfig().stopRouterWhenAllRouteesRemoved()) {
            this.context().stop(this.self());
        }
    }

    @Override
    public void preRestart(Throwable cause, Option<Object> msg) {
    }
}

