/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.ActorSystem;
import akka.actor.SupervisorStrategy;
import akka.routing.PoolOverrideUnsetConfig;
import akka.routing.Resizer;
import akka.routing.Resizer$;
import akka.routing.Router;
import akka.routing.RouterConfig;
import akka.routing.TailChoppingPool$;
import akka.routing.TailChoppingRoutingLogic$;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import com.typesafe.config.Config;
import java.time.Duration;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class TailChoppingPool
implements PoolOverrideUnsetConfig<TailChoppingPool>,
Product {
    private static final long serialVersionUID = 1L;
    private final int nrOfInstances;
    private final Option resizer;
    private final FiniteDuration within;
    private final FiniteDuration interval;
    private final SupervisorStrategy supervisorStrategy;
    private final String routerDispatcher;
    private final boolean usePoolDispatcher;

    public static TailChoppingPool apply(int n, Option<Resizer> option, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, SupervisorStrategy supervisorStrategy, String string, boolean bl) {
        return TailChoppingPool$.MODULE$.apply(n, option, finiteDuration, finiteDuration2, supervisorStrategy, string, bl);
    }

    public static TailChoppingPool fromProduct(Product product) {
        return TailChoppingPool$.MODULE$.fromProduct(product);
    }

    public static TailChoppingPool unapply(TailChoppingPool tailChoppingPool) {
        return TailChoppingPool$.MODULE$.unapply(tailChoppingPool);
    }

    public static Option<Resizer> $lessinit$greater$default$2() {
        return TailChoppingPool$.MODULE$.$lessinit$greater$default$2();
    }

    public static SupervisorStrategy $lessinit$greater$default$5() {
        return TailChoppingPool$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$6() {
        return TailChoppingPool$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$7() {
        return TailChoppingPool$.MODULE$.$lessinit$greater$default$7();
    }

    public TailChoppingPool(int nrOfInstances, Option<Resizer> resizer, FiniteDuration within, FiniteDuration interval, SupervisorStrategy supervisorStrategy, String routerDispatcher, boolean usePoolDispatcher) {
        this.nrOfInstances = nrOfInstances;
        this.resizer = resizer;
        this.within = within;
        this.interval = interval;
        this.supervisorStrategy = supervisorStrategy;
        this.routerDispatcher = routerDispatcher;
        this.usePoolDispatcher = usePoolDispatcher;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.nrOfInstances());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.resizer()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.within()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interval()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.supervisorStrategy()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.routerDispatcher()));
        n = Statics.mix((int)n, (int)(this.usePoolDispatcher() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TailChoppingPool)) return false;
        TailChoppingPool tailChoppingPool = (TailChoppingPool)object;
        if (this.nrOfInstances() != tailChoppingPool.nrOfInstances()) return false;
        if (this.usePoolDispatcher() != tailChoppingPool.usePoolDispatcher()) return false;
        Option<Resizer> option = this.resizer();
        Option<Resizer> option2 = tailChoppingPool.resizer();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        FiniteDuration finiteDuration = this.within();
        FiniteDuration finiteDuration2 = tailChoppingPool.within();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!finiteDuration.equals(finiteDuration2)) return false;
        FiniteDuration finiteDuration3 = this.interval();
        FiniteDuration finiteDuration4 = tailChoppingPool.interval();
        if (finiteDuration3 == null) {
            if (finiteDuration4 != null) {
                return false;
            }
        } else if (!finiteDuration3.equals(finiteDuration4)) return false;
        SupervisorStrategy supervisorStrategy = this.supervisorStrategy();
        SupervisorStrategy supervisorStrategy2 = tailChoppingPool.supervisorStrategy();
        if (supervisorStrategy == null) {
            if (supervisorStrategy2 != null) {
                return false;
            }
        } else if (!supervisorStrategy.equals(supervisorStrategy2)) return false;
        String string = this.routerDispatcher();
        String string2 = tailChoppingPool.routerDispatcher();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TailChoppingPool;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "TailChoppingPool";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this._1());
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            case 5: {
                object = this._6();
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToBoolean((boolean)this._7());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "nrOfInstances";
                break;
            }
            case 1: {
                string = "resizer";
                break;
            }
            case 2: {
                string = "within";
                break;
            }
            case 3: {
                string = "interval";
                break;
            }
            case 4: {
                string = "supervisorStrategy";
                break;
            }
            case 5: {
                string = "routerDispatcher";
                break;
            }
            case 6: {
                string = "usePoolDispatcher";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public int nrOfInstances() {
        return this.nrOfInstances;
    }

    @Override
    public Option<Resizer> resizer() {
        return this.resizer;
    }

    public FiniteDuration within() {
        return this.within;
    }

    public FiniteDuration interval() {
        return this.interval;
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    @Override
    public String routerDispatcher() {
        return this.routerDispatcher;
    }

    @Override
    public boolean usePoolDispatcher() {
        return this.usePoolDispatcher;
    }

    public TailChoppingPool(Config config) {
        int n = config.getInt("nr-of-instances");
        FiniteDuration finiteDuration = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "within");
        FiniteDuration finiteDuration2 = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "tail-chopping-router.interval");
        Option<Resizer> option = Resizer$.MODULE$.fromConfig(config);
        boolean bl = config.hasPath("pool-dispatcher");
        SupervisorStrategy supervisorStrategy = TailChoppingPool$.MODULE$.$lessinit$greater$default$5();
        String string = TailChoppingPool$.MODULE$.$lessinit$greater$default$6();
        this(n, option, finiteDuration, finiteDuration2, supervisorStrategy, string, bl);
    }

    public TailChoppingPool(int nr, FiniteDuration within, FiniteDuration interval) {
        this(nr, TailChoppingPool$.MODULE$.$lessinit$greater$default$2(), within, interval, TailChoppingPool$.MODULE$.$lessinit$greater$default$5(), TailChoppingPool$.MODULE$.$lessinit$greater$default$6(), TailChoppingPool$.MODULE$.$lessinit$greater$default$7());
    }

    public TailChoppingPool(int nr, Duration within, Duration interval) {
        this(nr, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(within)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(interval)));
    }

    @Override
    public Router createRouter(ActorSystem system) {
        return new Router(TailChoppingRoutingLogic$.MODULE$.apply(system.scheduler(), this.within(), this.interval(), system.dispatchers().lookup(this.routerDispatcher())));
    }

    @Override
    public int nrOfInstances(ActorSystem sys) {
        return this.nrOfInstances();
    }

    @Override
    public TailChoppingPool withSupervisorStrategy(SupervisorStrategy strategy) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), strategy, this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public TailChoppingPool withResizer(Resizer resizer) {
        Some some = Some$.MODULE$.apply((Object)resizer);
        int n = this.copy$default$1();
        FiniteDuration finiteDuration = this.copy$default$3();
        FiniteDuration finiteDuration2 = this.copy$default$4();
        SupervisorStrategy supervisorStrategy = this.copy$default$5();
        String string = this.copy$default$6();
        boolean bl = this.copy$default$7();
        return this.copy(n, (Option<Resizer>)some, finiteDuration, finiteDuration2, supervisorStrategy, string, bl);
    }

    public TailChoppingPool withDispatcher(String dispatcherId) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), dispatcherId, this.copy$default$7());
    }

    @Override
    public RouterConfig withFallback(RouterConfig other) {
        return this.overrideUnsetConfig(other);
    }

    public TailChoppingPool copy(int nrOfInstances, Option<Resizer> resizer, FiniteDuration within, FiniteDuration interval, SupervisorStrategy supervisorStrategy, String routerDispatcher, boolean usePoolDispatcher) {
        return new TailChoppingPool(nrOfInstances, resizer, within, interval, supervisorStrategy, routerDispatcher, usePoolDispatcher);
    }

    public int copy$default$1() {
        return this.nrOfInstances();
    }

    public Option<Resizer> copy$default$2() {
        return this.resizer();
    }

    public FiniteDuration copy$default$3() {
        return this.within();
    }

    public FiniteDuration copy$default$4() {
        return this.interval();
    }

    public SupervisorStrategy copy$default$5() {
        return this.supervisorStrategy();
    }

    public String copy$default$6() {
        return this.routerDispatcher();
    }

    public boolean copy$default$7() {
        return this.usePoolDispatcher();
    }

    public int _1() {
        return this.nrOfInstances();
    }

    public Option<Resizer> _2() {
        return this.resizer();
    }

    public FiniteDuration _3() {
        return this.within();
    }

    public FiniteDuration _4() {
        return this.interval();
    }

    public SupervisorStrategy _5() {
        return this.supervisorStrategy();
    }

    public String _6() {
        return this.routerDispatcher();
    }

    public boolean _7() {
        return this.usePoolDispatcher();
    }
}

