/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Cancellable;
import akka.actor.Scheduler;
import akka.pattern.AskTimeoutException;
import akka.pattern.AskableActorRef$;
import akka.pattern.AskableActorSelection$;
import akka.pattern.PipeToSupport;
import akka.pattern.package$;
import akka.routing.ActorRefRoutee;
import akka.routing.ActorRefRoutee$;
import akka.routing.ActorSelectionRoutee;
import akka.routing.ActorSelectionRoutee$;
import akka.routing.Routee;
import akka.routing.TailChoppingRoutees$;
import akka.util.Timeout;
import akka.util.Timeout$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.collection.BuildFrom$;
import scala.collection.immutable.IndexedSeq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.Try;

public final class TailChoppingRoutees
implements Routee,
Product,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Scheduler scheduler;
    private final IndexedSeq routees;
    private final FiniteDuration within;
    private final FiniteDuration interval;
    private final ExecutionContext ec;

    public static TailChoppingRoutees apply(Scheduler scheduler, IndexedSeq<Routee> indexedSeq, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, ExecutionContext executionContext) {
        return TailChoppingRoutees$.MODULE$.apply(scheduler, indexedSeq, finiteDuration, finiteDuration2, executionContext);
    }

    public static TailChoppingRoutees unapply(TailChoppingRoutees tailChoppingRoutees) {
        return TailChoppingRoutees$.MODULE$.unapply(tailChoppingRoutees);
    }

    public TailChoppingRoutees(Scheduler scheduler, IndexedSeq<Routee> routees, FiniteDuration within, FiniteDuration interval, ExecutionContext ec) {
        this.scheduler = scheduler;
        this.routees = routees;
        this.within = within;
        this.interval = interval;
        this.ec = ec;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TailChoppingRoutees)) return false;
        TailChoppingRoutees tailChoppingRoutees = (TailChoppingRoutees)object;
        Scheduler scheduler = this.scheduler();
        Scheduler scheduler2 = tailChoppingRoutees.scheduler();
        if (scheduler == null) {
            if (scheduler2 != null) {
                return false;
            }
        } else if (!scheduler.equals(scheduler2)) return false;
        IndexedSeq<Routee> indexedSeq = this.routees();
        IndexedSeq<Routee> indexedSeq2 = tailChoppingRoutees.routees();
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        FiniteDuration finiteDuration = this.within();
        FiniteDuration finiteDuration2 = tailChoppingRoutees.within();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!finiteDuration.equals(finiteDuration2)) return false;
        FiniteDuration finiteDuration3 = this.interval();
        FiniteDuration finiteDuration4 = tailChoppingRoutees.interval();
        if (finiteDuration3 == null) {
            if (finiteDuration4 == null) return true;
            return false;
        } else {
            if (!finiteDuration3.equals(finiteDuration4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TailChoppingRoutees;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "TailChoppingRoutees";
    }

    public Object productElement(int n) {
        FiniteDuration finiteDuration;
        int n2 = n;
        switch (n2) {
            case 0: {
                finiteDuration = this._1();
                break;
            }
            case 1: {
                finiteDuration = this._2();
                break;
            }
            case 2: {
                finiteDuration = this._3();
                break;
            }
            case 3: {
                finiteDuration = this._4();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return finiteDuration;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "scheduler";
                break;
            }
            case 1: {
                string = "routees";
                break;
            }
            case 2: {
                string = "within";
                break;
            }
            case 3: {
                string = "interval";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public IndexedSeq<Routee> routees() {
        return this.routees;
    }

    public FiniteDuration within() {
        return this.within;
    }

    public FiniteDuration interval() {
        return this.interval;
    }

    @Override
    public void send(Object message, ActorRef sender) {
        Timeout timeout = Timeout$.MODULE$.apply(this.within());
        Promise promise = Promise$.MODULE$.apply();
        IndexedSeq shuffled = (IndexedSeq)Random$.MODULE$.shuffle(this.routees(), BuildFrom$.MODULE$.buildFromIterableOps());
        AtomicInteger aIdx = new AtomicInteger();
        int size = shuffled.length();
        Cancellable tryWithNext = this.scheduler().scheduleWithFixedDelay(Duration$.MODULE$.Zero(), this.interval(), () -> {
            block0: {
                ActorSelection actorSelection;
                Routee routee;
                block1: {
                    ActorRef actorRef;
                    int idx = aIdx.getAndIncrement();
                    if (idx >= size) break block0;
                    routee = (Routee)shuffled.apply(idx);
                    if (!(routee instanceof ActorRefRoutee)) break block1;
                    ActorRefRoutee actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee);
                    ActorRef ref = actorRef = actorRefRoutee._1();
                    ActorRef actorRef2 = package$.MODULE$.ask(ref);
                    promise.completeWith(AskableActorRef$.MODULE$.ask$extension(actorRef2, message, timeout, AskableActorRef$.MODULE$.ask$default$3$extension(actorRef2, message)));
                    break block0;
                }
                if (!(routee instanceof ActorSelectionRoutee)) break block0;
                ActorSelectionRoutee actorSelectionRoutee = ActorSelectionRoutee$.MODULE$.unapply((ActorSelectionRoutee)routee);
                ActorSelection sel = actorSelection = actorSelectionRoutee._1();
                ActorSelection actorSelection2 = package$.MODULE$.ask(sel);
                promise.completeWith(AskableActorSelection$.MODULE$.ask$extension(actorSelection2, message, timeout, AskableActorSelection$.MODULE$.ask$default$3$extension(actorSelection2, message)));
            }
        }, this.ec);
        Cancellable sendTimeout = this.scheduler().scheduleOnce(this.within(), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$2(sender, promise)), this.ec);
        Future f = promise.future();
        f.onComplete((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            tryWithNext.cancel();
            return sendTimeout.cancel();
        }, this.ec);
        PipeToSupport.PipeableFuture pipeableFuture = package$.MODULE$.pipe(f, this.ec);
        pipeableFuture.pipeTo(sender, pipeableFuture.pipeTo$default$2(sender));
    }

    public TailChoppingRoutees copy(Scheduler scheduler, IndexedSeq<Routee> routees, FiniteDuration within, FiniteDuration interval, ExecutionContext ec) {
        return new TailChoppingRoutees(scheduler, routees, within, interval, ec);
    }

    public Scheduler copy$default$1() {
        return this.scheduler();
    }

    public IndexedSeq<Routee> copy$default$2() {
        return this.routees();
    }

    public FiniteDuration copy$default$3() {
        return this.within();
    }

    public FiniteDuration copy$default$4() {
        return this.interval();
    }

    public Scheduler _1() {
        return this.scheduler();
    }

    public IndexedSeq<Routee> _2() {
        return this.routees();
    }

    public FiniteDuration _3() {
        return this.within();
    }

    public FiniteDuration _4() {
        return this.interval();
    }

    private final void $anonfun$2(ActorRef sender$1, Promise promise$2) {
        promise$2.tryFailure((Throwable)new AskTimeoutException(new StringBuilder(41).append("Ask timed out on [").append(sender$1).append("] after [").append(this.within()).append(".toMillis} ms]").toString()));
    }
}

