/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.serialization.BaseSerializer$;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.Serializer;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import scala.Option;

@InternalApi
public final class ByteStringSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final int identifier;

    public ByteStringSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-bytestring", system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        ByteString bs = (ByteString)o;
        if (bs.copyToBuffer(buf) < bs.length()) {
            throw new BufferOverflowException();
        }
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        return ByteString$.MODULE$.fromByteBuffer(buf);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBinary(Object o) {
        void var3_3;
        ByteString bs = (ByteString)o;
        byte[] result = new byte[bs.length()];
        bs.copyToArray(result, 0, bs.length());
        return var3_3;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return ByteString$.MODULE$.apply(bytes);
    }
}

