/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.serialization.BaseSerializer$;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.Serializer;
import java.nio.ByteBuffer;
import scala.Option;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class LongSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final int identifier;

    public LongSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-long", system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        buf.putLong(BoxesRunTime.unboxToLong((Object)o));
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        return BoxesRunTime.boxToLong((long)buf.getLong());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBinary(Object o) {
        void var2_2;
        byte[] result = new byte[8];
        int i = 0;
        for (long j = BoxesRunTime.unboxToLong((Object)o); j != 0L; j >>>= 8) {
            result[i] = (byte)(j & 0xFFL);
            ++i;
        }
        return var2_2;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        long result = 0L;
        for (int i = 7; i >= 0; --i) {
            result <<= 8;
            result |= (long)bytes[i] & 0xFFL;
        }
        return BoxesRunTime.boxToLong((long)result);
    }
}

