/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.NoSerializationVerificationNeeded;
import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.JavaSerializer;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.Serialization$Information$;
import akka.serialization.SerializationSetup;
import akka.serialization.Serializer;
import akka.serialization.SerializerDetails;
import akka.serialization.SerializerDetails$;
import akka.serialization.SerializerWithStringManifest;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.DynamicVariable;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final Map<String, Serializer> serializers;
    private final Seq bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static DynamicVariable<Information> currentTransportInformation() {
        return Serialization$.MODULE$.currentTransportInformation();
    }

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public Serialization(ExtendedActorSystem system) {
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            SerializationSetup setting = (SerializationSetup)((Some)option).value();
            vector = (Seq)setting.createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        Seq serializerDetails = (Seq)vector.collect((PartialFunction)new Serializable(this){
            private final Serialization $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(SerializerDetails x) {
                boolean bl;
                SerializerDetails det;
                SerializerDetails serializerDetails = x;
                if (serializerDetails != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((det = serializerDetails).serializer())) {
                    bl = true;
                } else {
                    SerializerDetails det2 = serializerDetails;
                    bl = true;
                }
                return bl;
            }

            public final Object applyOrElse(SerializerDetails x, Function1 function1) {
                SerializerDetails serializerDetails;
                SerializerDetails det;
                SerializerDetails serializerDetails2 = x;
                if (serializerDetails2 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((det = serializerDetails2).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
                    serializerDetails = SerializerDetails$.MODULE$.apply(det.alias(), new DisabledJavaSerializer(this.$outer.system()), det.useFor());
                } else {
                    SerializerDetails det2;
                    serializerDetails = det2 = serializerDetails2;
                }
                return serializerDetails;
            }
        });
        Map fromConfig = (Map)this.settings().Serializers().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) return false;
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            if (string == null) return false;
            String k = string;
            if (string2 == null) return false;
            String v = string2;
            return true;
        }).map((Function1 & Serializable)x$1 -> {
            String k;
            String string;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$1;
                    if (tuple2 == null) break block2;
                    String string2 = (String)tuple2._1();
                    string = (String)tuple2._2();
                    if (string2 == null) break block2;
                    k = string2;
                    if (string != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String v = string;
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, this.serializerOf(k, v).get());
        });
        Map result = (Map)fromConfig.$plus$plus((IterableOnce)serializerDetails.map((Function1 & Serializable)d -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)d.alias());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)d.serializer());
        }));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result.iterator().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer ser = (Serializer)tuple2._2();
            return ser;
        }));
        this.serializers = result;
        Map fromConfig2 = (Map)this.settings().SerializationBindings().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) return false;
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            if (string == null) return false;
            String className = string;
            if (string2 == null) return false;
            String alias = string2;
            return true;
        }).withFilter((Function1 & Serializable)x$1 -> {
            String alias;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            if (string == null) throw new MatchError((Object)tuple2);
            String className = string;
            if (string2 == null) throw new MatchError((Object)tuple2);
            String string3 = alias = string2;
            String string4 = "none";
            if (string3 == null) {
                if (string4 == null) return false;
            } else if (string3.equals(string4)) return false;
            if (!this.checkGoogleProtobuf(className)) return false;
            if (!this.checkAkkaProtobuf(className)) return false;
            return true;
        }).map((Function1 & Serializable)x$1 -> {
            String className;
            String string;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$1;
                    if (tuple2 == null) break block2;
                    String string2 = (String)tuple2._1();
                    string = (String)tuple2._2();
                    if (string2 == null) break block2;
                    className = string2;
                    if (string != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String alias = string;
            return Tuple2$.MODULE$.apply(system.dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).get(), this.serializers.apply((Object)alias));
        });
        Seq fromSettings = (Seq)serializerDetails.flatMap((Function1 & Serializable)detail -> (IterableOnce)detail.useFor().map((Function1 & Serializable)clazz -> {
            Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(clazz);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)detail.serializer());
        }));
        Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig2.$plus$plus((IterableOnce)fromSettings));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result2.iterator().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer ser = (Serializer)tuple2._2();
            return ser;
        }));
        result2.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Class clazz = (Class)tuple2._1();
            Serializer ser = (Serializer)tuple2._2();
            return this.warnUnexpectedNonAkkaSerializer(clazz, ser);
        });
        this.bindings = result2;
        this.serializerMap = (ConcurrentHashMap)this.bindings().foldLeft(new ConcurrentHashMap(), (Function2 & Serializable)(x$1, x$2) -> {
            ConcurrentHashMap map;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._2();
                    map = (ConcurrentHashMap)tuple22._1();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Class c = (Class)tuple2._1();
            Serializer s = (Serializer)tuple2._2();
            map.put(c, s);
            return map;
        });
        Object[] objectArray = new Tuple2[1];
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier()));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)NullSerializer$.MODULE$);
        Map zero = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.serializerByIdentity = (Map)this.serializers.foldLeft((Object)zero, (Function2 & Serializable)(x$1, x$2) -> {
            Serializer existing;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            Map acc = (Map)tuple2._1();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            Serializer ser = (Serializer)tuple22._2();
            int id = ser.identifier();
            Option option = acc.get((Object)BoxesRunTime.boxToInteger((int)id));
            if (!(option instanceof Some)) return (Map)acc.updated((Object)BoxesRunTime.boxToInteger((int)id), (Object)ser);
            Serializer serializer = existing = (Serializer)((Some)option).value();
            Serializer serializer2 = ser;
            if (!(serializer == null ? serializer2 != null : !serializer.equals(serializer2))) return (Map)acc.updated((Object)BoxesRunTime.boxToInteger((int)id), (Object)ser);
            throw new IllegalArgumentException(new StringBuilder(31).append("Serializer identifier [").append(id).append("] of [").append(ser.getClass().getName()).append("] ").append(new StringBuilder(37).append("is not unique. It is also used by [").append(acc.apply((Object)BoxesRunTime.boxToInteger((int)id)).getClass().getName()).append("].").toString()).toString());
        });
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int id = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Serializer ser = (Serializer)tuple2._2();
                if (0 <= id && id < size) {
                    table$1[id] = ser;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("akka.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("akka.actor.warn-on-no-serialization-verification");
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        Object object;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return (T)object;
    }

    public Try<byte[]> serialize(Object o) {
        return (Try)this.withTransportInformation((Function0 & Serializable)() -> Try$.MODULE$.apply(() -> this.serialize$$anonfun$1$$anonfun$1(o)));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply(() -> this.deserialize$$anonfun$1(bytes, serializerId, clazz));
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply(() -> this.deserialize$$anonfun$2(bytes, serializerId, manifest));
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        return this.withTransportInformation((Function0 & Serializable)() -> {
            Object object;
            Serializer serializer = serializer;
            if (serializer instanceof SerializerWithStringManifest) {
                SerializerWithStringManifest s2 = (SerializerWithStringManifest)serializer;
                object = s2.fromBinary(bytes, manifest);
                return object;
            } else {
                Serializer s1 = serializer;
                String string = manifest;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    object = s1.fromBinary(bytes, (Option<Class<?>>)None$.MODULE$);
                    return object;
                } else {
                    Map<String, Option<Class<?>>> cache = this.manifestCache.get();
                    Option option = cache.get((Object)manifest);
                    if (option instanceof Some) {
                        Option cachedClassManifest = (Option)((Some)option).value();
                        object = s1.fromBinary(bytes, cachedClassManifest);
                        return object;
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                        Try try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.apply(Object.class));
                        if (try_ instanceof Success) {
                            Class classManifest = (Class)((Success)try_).value();
                            Some classManifestOption = Some$.MODULE$.apply((Object)classManifest);
                            this.updateCache$1(cache, manifest, (Option)classManifestOption);
                            object = s1.fromBinary(bytes, (Option<Class<?>>)classManifestOption);
                            return object;
                        } else {
                            if (!(try_ instanceof Failure)) throw new MatchError(try_);
                            throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest).append("] for serializer with id [").append(serializer.identifier()).append("].").toString());
                        }
                    }
                }
            }
        });
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(169).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            Serializer serializer3;
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            if ((serializer3 = serializer2) instanceof ByteBufferSerializer) {
                ByteBufferSerializer ser = (ByteBufferSerializer)((Object)serializer3);
                object = ser.fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object = this.deserializeByteArray(bytes, serializer2, manifest);
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return (Try)this.withTransportInformation((Function0 & Serializable)() -> Try$.MODULE$.apply(() -> this.deserialize$$anonfun$3$$anonfun$1(bytes, clazz)));
    }

    public Serializer findSerializerFor(Object o) {
        return o == null ? NullSerializer$.MODULE$ : this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap.get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            SeqOps seqOps;
            Seq seq = (Seq)this.bindings().filter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Class c = (Class)tuple2._1();
                return c.isAssignableFrom(clazz);
            });
            if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)seq), 0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            Seq possibilities = seq;
            if (Serialization.unique$1(possibilities)) {
                serializer3 = (Serializer)((Tuple2)possibilities.head())._2();
            } else {
                Seq possibilitiesWithoutJavaSerializer = (Seq)possibilities.filter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) return true;
                    Serializer serializer = (Serializer)tuple2._2();
                    if (serializer instanceof JavaSerializer) {
                        return false;
                    }
                    if (!(serializer instanceof DisabledJavaSerializer)) return true;
                    return false;
                });
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((IterableOnceOps)possibilitiesWithoutJavaSerializer.map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Serializer s = (Serializer)tuple2._2();
                        return s.getClass().getName();
                    })).mkString(", "));
                }
                serializer3 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer3;
            Serializer serializer4 = this.serializerMap.putIfAbsent(clazz, ser);
            if (serializer4 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'akka.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                if (!this.warnUnexpectedNonAkkaSerializer(clazz, ser)) {
                    this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                }
                serializer = ser;
            } else {
                Serializer some;
                serializer = some = serializer4;
            }
        } else {
            Serializer ser;
            serializer = ser = serializer2;
        }
        return serializer;
    }

    public Try<Serializer> serializerOf(String serializerFQN) {
        return this.serializerOf("", serializerFQN);
    }

    /*
     * Unable to fully structure code
     */
    private Try<Serializer> serializerOf(String bindingName, String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var4_3 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        v2 = new Tuple2[1];
        var5_5 = (Class)Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class);
        v2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var5_5, (Object)this.system());
        return this.system().dynamicAccess().createInstanceFor(fqn, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(v2)), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(bindingName, fqn, this){
            public final String akka$serialization$Serialization$$anon$2$$bindingName$1;
            public final String akka$serialization$Serialization$$anon$2$$fqn$1;
            private final Serialization $outer;
            {
                this.akka$serialization$Serialization$$anon$2$$bindingName$1 = bindingName$2;
                this.akka$serialization$Serialization$$anon$2$$fqn$1 = fqn$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchMethodException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return throwable instanceof NoSuchMethodException ? this.$outer.system().dynamicAccess().createInstanceFor(this.akka$serialization$Serialization$$anon$2$$fqn$1, (Seq<Tuple2<Class<?>, Object>>)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(this){
                    private final $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        boolean bl;
                        Throwable throwable = x;
                        if (throwable instanceof NoSuchMethodException) {
                            NoSuchMethodException e = (NoSuchMethodException)throwable;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Try<T> try_;
                        Throwable throwable = x;
                        if (throwable instanceof NoSuchMethodException) {
                            NoSuchMethodException e = (NoSuchMethodException)throwable;
                            String string = this.$outer.akka$serialization$Serialization$$anon$2$$bindingName$1;
                            String string2 = "";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                throw e;
                            }
                            Object[] objectArray = new Tuple2[2];
                            Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class);
                            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.$outer.akka$serialization$Serialization$_$$anon$$$outer().system());
                            Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(String.class);
                            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)this.$outer.akka$serialization$Serialization$$anon$2$$bindingName$1);
                            try_ = this.$outer.akka$serialization$Serialization$_$$anon$$$outer().system().dynamicAccess().createInstanceFor(this.$outer.akka$serialization$Serialization$$anon$2$$fqn$1, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), ClassTag$.MODULE$.apply(Serializer.class));
                        } else {
                            try_ = function1.apply((Object)x);
                        }
                        return try_;
                    }
                }) : function1.apply((Object)x);
            }

            public final Serialization akka$serialization$Serialization$_$$anon$$$outer() {
                return this.$outer;
            }
        });
    }

    public Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        if (!this.system().settings().AllowJavaSerialization()) {
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable)_$3 -> !this.akka$serialization$Serialization$$isDisallowedJavaSerializer((Serializer)_$3)), Serialization::ensureOnlyAllowedSerializers$$anonfun$2);
        }
    }

    private boolean warnUnexpectedNonAkkaSerializer(Class<?> clazz, Serializer ser) {
        boolean bl;
        if (clazz.getName().startsWith("akka.") && !ser.getClass().getName().startsWith("akka.")) {
            this.log().warning("Using serializer [{}] for message [{}]. Note that this serializer is not implemented by Akka. It's not recommended to replace serializers for messages provided by Akka.", ser.getClass().getName(), clazz.getName());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean checkGoogleProtobuf(String className) {
        return this.checkClass("com.google.protobuf", className);
    }

    private boolean checkAkkaProtobuf(String className) {
        return this.checkClass("akka.protobuf", className);
    }

    private boolean checkClass(String prefix, String className) {
        return !className.startsWith(prefix) || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return (Seq)((IterableOnceOps)in.foldLeft((Object)new ArrayBuffer(in.size()), (Function2 & Serializable)(buf, ca) -> {
            Buffer buffer;
            int n = buf.indexWhere((Function1 & Serializable)_$4 -> ((Class)_$4._1()).isAssignableFrom((Class)ca._1()));
            if (-1 == n) {
                buffer = buf.append(ca);
            } else {
                int x = n;
                buf.insert(x, ca);
                buffer = BoxedUnit.UNIT;
            }
            return buf;
        })).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        Serializer serializer;
        if (0 <= id && id < this.quickSerializerByIdentity.length) {
            Serializer ser;
            Serializer serializer2 = this.quickSerializerByIdentity[id];
            if (serializer2 == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            serializer = ser = serializer2;
        } else {
            serializer = (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
        }
        return serializer;
    }

    public boolean akka$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("akka.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final byte[] serialize$$anonfun$1$$anonfun$1(Object o$2) {
        return this.findSerializerFor(o$2).toBinary(o$2);
    }

    private static final String liftedTree1$1$$anonfun$2() {
        return "";
    }

    private final Serializer liftedTree1$1(int serializerId$2, Option clazz$2) {
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId$2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(154).append("Cannot find serializer with id [").append(serializerId$2).append("]").append(clazz$2.map((Function1 & Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse(Serialization::liftedTree1$1$$anonfun$2)).append(". ").append("The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in sync between the two systems.").toString());
        }
        return serializer;
    }

    private final Object deserialize$$anonfun$1(byte[] bytes$1, int serializerId$1, Option clazz$1) {
        Serializer serializer = this.liftedTree1$1(serializerId$1, clazz$1);
        return this.withTransportInformation((Function0 & Serializable)() -> serializer.fromBinary(bytes$1, clazz$1));
    }

    private final Serializer liftedTree2$1(int serializerId$4, String manifest$2) {
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId$4);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(168).append("Cannot find serializer with id [").append(serializerId$4).append("] (manifest [").append(manifest$2).append("]). The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in sync between the two systems.").toString());
        }
        return serializer;
    }

    private final Object deserialize$$anonfun$2(byte[] bytes$3, int serializerId$3, String manifest$1) {
        Serializer serializer = this.liftedTree2$1(serializerId$3, manifest$1);
        return this.deserializeByteArray(bytes$3, serializer, manifest$1);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        Map<String, Option<Class<?>>> map = cache;
        while (!this.manifestCache.compareAndSet(map, (Map<String, Option<Class<?>>>)map.updated((Object)key, (Object)value))) {
            map = this.manifestCache.get();
        }
        return true;
    }

    private final Object deserialize$$anonfun$3$$anonfun$1(byte[] bytes$6, Class clazz$5) {
        return this.serializerFor(clazz$5).fromBinary(bytes$6, (Option<Class<?>>)Some$.MODULE$.apply((Object)clazz$5));
    }

    private static final boolean unique$1(Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1 & Serializable)_$1 -> ((Class)_$1._1()).isAssignableFrom((Class)((Tuple2)possibilities.apply(0))._1())) || possibilities.forall((Function1 & Serializable)_$2 -> BoxesRunTime.equals((Object)_$2._2(), (Object)((Tuple2)possibilities.apply(0))._2()));
    }

    private static final String ensureOnlyAllowedSerializers$$anonfun$2() {
        return "Disallowed JavaSerializer binding.";
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public static final class Information
    implements Product,
    Serializable {
        private final Address address;
        private final ActorSystem system;

        public static Information apply(Address address, ActorSystem actorSystem) {
            return Serialization$Information$.MODULE$.apply(address, actorSystem);
        }

        public static Information fromProduct(Product product) {
            return Serialization$Information$.MODULE$.fromProduct(product);
        }

        public static Information unapply(Information information) {
            return Serialization$Information$.MODULE$.unapply(information);
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Information)) return false;
            Information information = (Information)object;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Information;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Information";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "address";
            } else if (1 == n2) {
                string = "system";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public Address _1() {
            return this.address();
        }

        public ActorSystem _2() {
            return this.system();
        }
    }

    public static class Settings {
        private final Config config;
        private final Map Serializers;
        private final Map SerializationBindings;

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            Config bindings = config.getConfig("akka.actor.serialization-bindings");
            this.SerializationBindings = this.configToMap(bindings);
        }

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return (Map)package$JavaConverters$.MODULE$.MapHasAsScala(cfg.root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v.toString());
            });
        }
    }
}

