/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.serialization.BaseSerializer$;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.Serializer;
import java.nio.ByteBuffer;
import scala.Option;

@InternalApi
public final class StringSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final int identifier;

    public StringSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-string", system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        buf.put(this.toBinary(o));
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        byte[] bytes = new byte[buf.remaining()];
        buf.get(bytes);
        return new String(bytes, "UTF-8");
    }

    @Override
    public byte[] toBinary(Object o) {
        return ((String)o).getBytes("UTF-8");
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return new String(bytes, "UTF-8");
    }
}

