/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.annotation.InternalApi;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class DoubleLinkedList<Node> {
    private final Function1<Node, Object> getPrevious;
    private final Function1<Node, Object> getNext;
    private final Function2<Node, Object, BoxedUnit> setPrevious;
    private final Function2<Node, Object, BoxedUnit> setNext;
    private Object first;
    private Object last;

    public DoubleLinkedList(Function1<Node, Object> getPrevious, Function1<Node, Object> getNext, Function2<Node, Object, BoxedUnit> setPrevious, Function2<Node, Object, BoxedUnit> setNext) {
        this.getPrevious = getPrevious;
        this.getNext = getNext;
        this.setPrevious = setPrevious;
        this.setNext = setNext;
        this.first = OptionVal$.MODULE$.none();
        this.last = OptionVal$.MODULE$.none();
    }

    public boolean isEmpty() {
        Object object = this.first;
        return OptionVal$.MODULE$.isEmpty$extension(object);
    }

    public Object getFirst() {
        return this.first;
    }

    public Object getLast() {
        return this.last;
    }

    public Node prepend(Node node) {
        return this.insertBefore(node, this.first);
    }

    public Node append(Node node) {
        return this.insertAfter(this.last, node);
    }

    public void remove(Node node) {
        this.unlink(node);
        this.setNext.apply(node, new OptionVal<Object>(OptionVal$.MODULE$.none()));
        this.setPrevious.apply(node, new OptionVal<Object>(OptionVal$.MODULE$.none()));
    }

    public Node moveToFront(Node node) {
        Node Node2;
        Object object = this.first;
        if (OptionVal$.MODULE$.contains$extension(object, node)) {
            Node2 = node;
        } else {
            this.unlink(node);
            Node2 = this.prepend(node);
        }
        return Node2;
    }

    public Node moveToBack(Node node) {
        Node Node2;
        Object object = this.last;
        if (OptionVal$.MODULE$.contains$extension(object, node)) {
            Node2 = node;
        } else {
            this.unlink(node);
            Node2 = this.append(node);
        }
        return Node2;
    }

    public Node getFirstOrElsePrepend(Function1<Node, Object> check, Function0<Node> newNode) {
        Object a;
        Object first;
        Object object = this.first;
        Object object2 = OptionVal$Some$.MODULE$.unapply(object);
        return (Node)(!OptionVal$.MODULE$.isEmpty$extension(object2) && BoxesRunTime.unboxToBoolean((Object)check.apply(first = (a = OptionVal$.MODULE$.get$extension(object2)))) ? first : this.prepend(newNode.apply()));
    }

    public Node getLastOrElseAppend(Function1<Node, Object> check, Function0<Node> newNode) {
        Object a;
        Object last;
        Object object = this.last;
        Object object2 = OptionVal$Some$.MODULE$.unapply(object);
        return (Node)(!OptionVal$.MODULE$.isEmpty$extension(object2) && BoxesRunTime.unboxToBoolean((Object)check.apply(last = (a = OptionVal$.MODULE$.get$extension(object2)))) ? last : this.append(newNode.apply()));
    }

    public Node getNextOrElseInsert(Node node, Function1<Node, Object> check, Function0<Node> newNode) {
        Object a;
        Object next;
        Object object = this.getNext.apply(node);
        Object var4_5 = object == null ? null : ((OptionVal)object).x();
        Object object2 = OptionVal$Some$.MODULE$.unapply(var4_5);
        return (Node)(!OptionVal$.MODULE$.isEmpty$extension(object2) && BoxesRunTime.unboxToBoolean((Object)check.apply(next = (a = OptionVal$.MODULE$.get$extension(object2)))) ? next : this.insertAfter(OptionVal$Some$.MODULE$.apply(node), newNode.apply()));
    }

    public Node getPreviousOrElseInsert(Node node, Function1<Node, Object> check, Function0<Node> newNode) {
        Object a;
        Object previous;
        Object object = this.getPrevious.apply(node);
        Object var4_5 = object == null ? null : ((OptionVal)object).x();
        Object object2 = OptionVal$Some$.MODULE$.unapply(var4_5);
        return (Node)(!OptionVal$.MODULE$.isEmpty$extension(object2) && BoxesRunTime.unboxToBoolean((Object)check.apply(previous = (a = OptionVal$.MODULE$.get$extension(object2)))) ? previous : this.insertBefore(newNode.apply(), OptionVal$Some$.MODULE$.apply(node)));
    }

    public Node findNextOrElseInsert(Node node, Function1<Node, Object> isBefore, Function1<Node, Object> check, Function0<Node> newNode) {
        return this.getNextOrElseInsert(this.shiftWhile(node, this.getNext, isBefore), check, newNode);
    }

    public Node findPreviousOrElseInsert(Node node, Function1<Node, Object> isAfter, Function1<Node, Object> check, Function0<Node> newNode) {
        return this.getPreviousOrElseInsert(this.shiftWhile(node, this.getPrevious, isAfter), check, newNode);
    }

    public Iterator<Node> forwardIterator() {
        return this.iteratorFrom(this.first, this.getNext);
    }

    public Iterator<Node> backwardIterator() {
        return this.iteratorFrom(this.last, this.getPrevious);
    }

    private Node insertBefore(Node node, Object next) {
        Object object;
        Object previous = OptionVal$.MODULE$.isDefined$extension(next) ? ((object = this.getPrevious.apply(OptionVal$.MODULE$.get$extension(next))) == null ? null : ((OptionVal)object).x()) : OptionVal$.MODULE$.none();
        this.link(previous, node, next);
        return node;
    }

    private Node insertAfter(Object previous, Node node) {
        Object object;
        Object next = OptionVal$.MODULE$.isDefined$extension(previous) ? ((object = this.getNext.apply(OptionVal$.MODULE$.get$extension(previous))) == null ? null : ((OptionVal)object).x()) : OptionVal$.MODULE$.none();
        this.link(previous, node, next);
        return node;
    }

    private void link(Object previous, Node node, Object next) {
        this.setPrevious.apply(node, new OptionVal<Object>(previous));
        this.setNext.apply(node, new OptionVal<Object>(next));
        if (OptionVal$.MODULE$.isEmpty$extension(previous)) {
            this.first = OptionVal$Some$.MODULE$.apply(node);
        } else {
            this.setNext.apply(OptionVal$.MODULE$.get$extension(previous), new OptionVal<Object>(OptionVal$Some$.MODULE$.apply(node)));
        }
        if (OptionVal$.MODULE$.isEmpty$extension(next)) {
            this.last = OptionVal$Some$.MODULE$.apply(node);
        } else {
            this.setPrevious.apply(OptionVal$.MODULE$.get$extension(next), new OptionVal<Object>(OptionVal$Some$.MODULE$.apply(node)));
        }
    }

    private void unlink(Node node) {
        Object next;
        Object object = this.getPrevious.apply(node);
        Object previous = object == null ? null : (Object)((OptionVal)object).x();
        Object object2 = this.getNext.apply(node);
        Object a = next = object2 == null ? null : (Object)((OptionVal)object2).x();
        if (OptionVal$.MODULE$.isEmpty$extension(previous)) {
            this.first = next;
        } else {
            this.setNext.apply(OptionVal$.MODULE$.get$extension(previous), new OptionVal<Object>(next));
        }
        if (OptionVal$.MODULE$.isEmpty$extension(next)) {
            this.last = previous;
        } else {
            this.setPrevious.apply(OptionVal$.MODULE$.get$extension(next), new OptionVal<Object>(previous));
        }
    }

    private Node shiftWhile(Node start, Function1<Node, Object> shift, Function1<Node, Object> check) {
        Object var8_8;
        Object var7_7;
        Object peek;
        Object current = start;
        Object object = shift.apply(current);
        Object v0 = peek = object == null ? null : ((OptionVal)object).x();
        while (OptionVal$.MODULE$.isDefined$extension(var7_7 = peek) && BoxesRunTime.unboxToBoolean((Object)check.apply(OptionVal$.MODULE$.get$extension(var8_8 = peek)))) {
            Object var9_9 = peek;
            current = OptionVal$.MODULE$.get$extension(var9_9);
            Object object2 = shift.apply(current);
            peek = object2 == null ? null : ((OptionVal)object2).x();
        }
        return current;
    }

    private Iterator<Node> iteratorFrom(Object start, Function1<Node, Object> shift) {
        return new AbstractIterator<Node>(start, shift){
            private final Function1 shift$2;
            private Object cursor;
            {
                this.shift$2 = shift$1;
                this.cursor = start$1;
            }

            public boolean hasNext() {
                Object object = this.cursor;
                return OptionVal$.MODULE$.isDefined$extension(object);
            }

            public Object next() {
                Object node = this.cursor;
                Object object = this.cursor;
                Object object2 = this.shift$2.apply(OptionVal$.MODULE$.get$extension(object));
                this.cursor = object2 == null ? null : ((OptionVal)object2).x();
                return OptionVal$.MODULE$.get$extension(node);
            }
        };
    }
}

