/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.util.ManifestInfo$;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ObjectRef;

public final class ManifestInfo
implements Extension {
    private final ExtendedActorSystem system;
    private final Map versions;

    public static Extension apply(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.apply(classicActorSystemProvider);
    }

    public static ManifestInfo createExtension(ExtendedActorSystem extendedActorSystem) {
        return ManifestInfo$.MODULE$.createExtension(extendedActorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.get(actorSystem);
    }

    public static ManifestInfo get(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.get(classicActorSystemProvider);
    }

    public static ManifestInfo get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.get(classicActorSystemProvider);
    }

    public static ManifestInfo$ lookup() {
        return ManifestInfo$.MODULE$.lookup();
    }

    public ManifestInfo(ExtendedActorSystem system) {
        this.system = system;
        ObjectRef manifests = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ManifestInfo.liftedTree1$1(system, manifests);
        this.versions = (Map)manifests.elem;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Map<String, Version> versions() {
        return this.versions;
    }

    public boolean checkSameVersion(String productName, Seq<String> dependencies, boolean logWarning) {
        return this.checkSameVersion(productName, dependencies, logWarning, this.system().settings().FailMixedVersions());
    }

    public boolean checkSameVersion(String productName, Seq<String> dependencies, boolean logWarning, boolean throwException) {
        boolean bl;
        Option<String> option = ManifestInfo$.MODULE$.checkSameVersion(productName, dependencies, this.versions());
        if (option instanceof Some) {
            String message = (String)((Some)option).value();
            if (logWarning) {
                Logging$.MODULE$.apply(this.system(), ManifestInfo.class, LogSource$.MODULE$.fromAnyClass()).warning(message);
            }
            if (throwException) {
                throw new IllegalStateException(message);
            }
            bl = false;
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    private static final void liftedTree1$1(ExtendedActorSystem system$1, ObjectRef manifests$1) {
        try {
            Enumeration<URL> resources = system$1.dynamicAccess().classLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try (InputStream ios = resources.nextElement().openStream();){
                    String v;
                    String vendor;
                    String v2;
                    String t;
                    Manifest manifest = new Manifest(ios);
                    Attributes attributes = manifest.getMainAttributes();
                    String string = attributes.getValue(new Attributes.Name(ManifestInfo$.akka$util$ManifestInfo$$$ImplTitle));
                    String title = string == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.akka$util$ManifestInfo$$$BundleName)) : (t = string);
                    String string2 = attributes.getValue(new Attributes.Name(ManifestInfo$.akka$util$ManifestInfo$$$ImplVersion));
                    String version = string2 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.akka$util$ManifestInfo$$$BundleVersion)) : (v2 = string2);
                    String string3 = attributes.getValue(new Attributes.Name(ManifestInfo$.akka$util$ManifestInfo$$$ImplVendor));
                    String string4 = vendor = string3 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.akka$util$ManifestInfo$$$BundleVendor)) : (v = string3);
                    if (title == null || version == null || vendor == null || !ManifestInfo$.akka$util$ManifestInfo$$$knownVendors.apply((Object)vendor)) continue;
                    Map map = (Map)((Map)manifests$1.elem).updated((Object)title, (Object)new Version(version));
                    manifests$1.elem = map;
                }
            }
        }
        catch (IOException ioe) {
            Logging$.MODULE$.apply(system$1, ManifestInfo.class, LogSource$.MODULE$.fromAnyClass()).warning("Could not read manifest information. {}", ioe);
        }
    }

    public static final class Version
    implements Comparable<Version> {
        private final String version;
        private final akka.util.Version impl;

        public Version(String version) {
            this.version = version;
            this.impl = new akka.util.Version(version);
        }

        public String version() {
            return this.version;
        }

        private akka.util.Version impl() {
            return this.impl;
        }

        @Override
        public int compareTo(Version other) {
            return this.impl().compareTo(other.impl());
        }

        public boolean equals(Object o) {
            boolean bl;
            Object object = o;
            if (object instanceof Version) {
                Version v = (Version)object;
                bl = this.impl().equals(v.impl());
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.impl().hashCode();
        }

        public String toString() {
            return this.impl().toString();
        }
    }
}

