/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.annotation.InternalApi;
import akka.util.DoubleLinkedList;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import akka.util.RecencyList;
import akka.util.SegmentedRecencyList$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.IndexedSeq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

@InternalApi
public final class SegmentedRecencyList<A> {
    private final RecencyList.Clock clock;
    private scala.collection.immutable.IndexedSeq<Object> limits;
    private int totalLimit;
    private final int lowest;
    private final int highest;
    private final scala.collection.immutable.IndexedSeq<DoubleLinkedList<Node<A>>> segments;
    private final IndexedSeq<Object> sizes;
    private final DoubleLinkedList<Node<A>> overallRecency;
    private final Map<A, Node<A>> lookupNode;

    public static <A> SegmentedRecencyList<A> empty(Seq<Object> seq) {
        return SegmentedRecencyList$.MODULE$.empty(seq);
    }

    public SegmentedRecencyList(Seq<Object> initialLimits, RecencyList.Clock clock) {
        this.clock = clock;
        this.limits = initialLimits.toIndexedSeq();
        this.totalLimit = BoxesRunTime.unboxToInt((Object)this.limits.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int levels = this.limits.size();
        this.lowest = 0;
        this.highest = levels - 1;
        this.segments = (scala.collection.immutable.IndexedSeq)package$.MODULE$.IndexedSeq().fill(levels, SegmentedRecencyList::$init$$$anonfun$1);
        this.sizes = (IndexedSeq)IndexedSeq$.MODULE$.fill(levels, SegmentedRecencyList::$init$$$anonfun$2);
        this.overallRecency = new DoubleLinkedList((Function1 & Serializable)_$3 -> new OptionVal<Node>(_$3.overallLessRecent()), (Function1 & Serializable)_$4 -> new OptionVal<Node>(_$4.overallMoreRecent()), (Function2 & Serializable)(v1, v2) -> {
            ((Node)v1).overallLessRecent_$eq(v2 == null ? null : ((OptionVal)v2).x());
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable)(v1, v2) -> {
            ((Node)v1).overallMoreRecent_$eq(v2 == null ? null : ((OptionVal)v2).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = (Map)Map$.MODULE$.empty();
    }

    public int size() {
        return this.lookupNode.size();
    }

    public int sizeOf(int level) {
        return BoxesRunTime.unboxToInt((Object)this.sizes.apply(level));
    }

    public SegmentedRecencyList<A> update(A value) {
        if (this.lookupNode.contains(value)) {
            this.promote((Node)this.lookupNode.apply(value));
        } else {
            this.insert(new Node<A>(value));
        }
        return this;
    }

    public SegmentedRecencyList<A> remove(A value) {
        if (this.lookupNode.contains(value)) {
            this.removeNode((Node)this.lookupNode.apply(value));
        }
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode.contains(value);
    }

    public Iterator<A> leastToMostRecentOf(int level) {
        return ((DoubleLinkedList)this.segments.apply(level)).forwardIterator().map((Function1 & Serializable)_$5 -> _$5.value());
    }

    public Seq<A> removeLeastRecentOverLimit() {
        List list;
        if (this.size() > this.totalLimit) {
            this.adjustProtectedLevels();
            int excess = this.size() - this.totalLimit;
            list = excess == 1 ? this.removeLeastRecent() : ((DoubleLinkedList)this.segments.apply(this.lowest)).forwardIterator().take(excess).map((Function1 & Serializable)node -> this.removeNode((Node<A>)node)).toList();
        } else {
            list = package$.MODULE$.Nil();
        }
        return list;
    }

    public Seq<A> removeLeastRecent() {
        Nil$ nil$;
        Node node = (Node)((DoubleLinkedList)this.segments.apply(this.lowest)).getFirst();
        Node node2 = (Node)OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node node3;
            Node first = node3 = (Node)OptionVal$.MODULE$.get$extension(node2);
            nil$ = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.removeNode(first)}));
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    public Seq<A> removeOverallLeastRecentOutside(FiniteDuration duration) {
        if (OptionVal$.MODULE$.isEmpty$extension(this.clock)) {
            throw new UnsupportedOperationException("Overall recency is not enabled");
        }
        long min = ((RecencyList.Clock)OptionVal$.MODULE$.get$extension(this.clock)).earlierTime(duration);
        return this.overallRecency.forwardIterator().takeWhile((Function1 & Serializable)_$6 -> _$6.timestamp() < min).map((Function1 & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public void updateLimits(Seq<Object> newLimits) {
        this.limits = newLimits.toIndexedSeq();
        this.totalLimit = BoxesRunTime.unboxToInt((Object)this.limits.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private void adjustProtectedLevels() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.highest), this.lowest).by(-1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)level -> this.adjust(level));
    }

    private void adjust(int level) {
        int excess = BoxesRunTime.unboxToInt((Object)this.sizes.apply(level)) - BoxesRunTime.unboxToInt((Object)this.limits.apply(level));
        if (excess > 0) {
            ((DoubleLinkedList)this.segments.apply(level)).forwardIterator().take(excess).foreach((Function1)(JProcedure1 & Serializable)node -> this.demote((Node<A>)node));
        }
    }

    private void insert(Node<A> node) {
        this.appendTo(this.lowest, node);
        Object object = Predef$.MODULE$.ArrowAssoc(node.value());
        this.lookupNode.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, node));
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            node.timestamp_$eq(((RecencyList.Clock)OptionVal$.MODULE$.get$extension(this.clock)).currentTime());
            this.overallRecency.append(node);
        }
    }

    private void promote(Node<A> node) {
        BoxedUnit boxedUnit;
        if (node.level() == this.highest) {
            boxedUnit = ((DoubleLinkedList)this.segments.apply(node.level())).moveToBack(node);
        } else {
            int newLevel = node.level() + 1;
            this.removeFromCurrentLevel(node);
            this.appendTo(newLevel, node);
            this.adjust(newLevel);
            boxedUnit = BoxedUnit.UNIT;
        }
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            node.timestamp_$eq(((RecencyList.Clock)OptionVal$.MODULE$.get$extension(this.clock)).currentTime());
            this.overallRecency.moveToBack(node);
        }
    }

    private void demote(Node<A> node) {
        this.removeFromCurrentLevel(node);
        this.appendTo(node.level() - 1, node);
    }

    private void appendTo(int level, Node<A> node) {
        node.level_$eq(level);
        ((DoubleLinkedList)this.segments.apply(level)).append(node);
        this.sizes.update(level, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.sizes.apply(level)) + 1)));
    }

    private void removeFromCurrentLevel(Node<A> node) {
        ((DoubleLinkedList)this.segments.apply(node.level())).remove(node);
        int n = node.level();
        this.sizes.update(n, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.sizes.apply(n)) - 1)));
    }

    /*
     * WARNING - void declaration
     */
    private A removeNode(Node<A> node) {
        void var2_2;
        A value = node.value();
        this.removeFromCurrentLevel(node);
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            this.overallRecency.remove(node);
        }
        this.lookupNode.$minus$eq(value);
        return var2_2;
    }

    private static final DoubleLinkedList $init$$$anonfun$1() {
        return new DoubleLinkedList((Function1 & Serializable)_$1 -> new OptionVal<Node>(_$1.lessRecent()), (Function1 & Serializable)_$2 -> new OptionVal<Node>(_$2.moreRecent()), (Function2 & Serializable)(v1, v2) -> {
            ((Node)v1).lessRecent_$eq(v2 == null ? null : ((OptionVal)v2).x());
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable)(v1, v2) -> {
            ((Node)v1).moreRecent_$eq(v2 == null ? null : ((OptionVal)v2).x());
            return BoxedUnit.UNIT;
        });
    }

    private static final int $init$$$anonfun$2() {
        return 0;
    }

    private static final class Node<A> {
        private final Object value;
        private int level;
        private long timestamp;
        private Node lessRecent;
        private Node moreRecent;
        private Node overallLessRecent;
        private Node overallMoreRecent;

        public Node(A value) {
            this.value = value;
            this.level = 0;
            this.timestamp = 0L;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            OptionVal$.MODULE$.None();
            this.overallLessRecent = null;
            OptionVal$.MODULE$.None();
            this.overallMoreRecent = null;
        }

        public A value() {
            return (A)this.value;
        }

        public int level() {
            return this.level;
        }

        public void level_$eq(int x$1) {
            this.level = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public Node lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node x$1) {
            this.lessRecent = x$1;
        }

        public Node moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node x$1) {
            this.moreRecent = x$1;
        }

        public Node overallLessRecent() {
            return this.overallLessRecent;
        }

        public void overallLessRecent_$eq(Node x$1) {
            this.overallLessRecent = x$1;
        }

        public Node overallMoreRecent() {
            return this.overallMoreRecent;
        }

        public void overallMoreRecent_$eq(Node x$1) {
            this.overallMoreRecent = x$1;
        }
    }
}

