/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import scala.Predef$;
import scala.math.package$;

public abstract class TokenBucket {
    private final long capacity;
    private final long nanosBetweenTokens;
    private long availableTokens;
    private long lastUpdate;

    public TokenBucket(long capacity, long nanosBetweenTokens) {
        this.capacity = capacity;
        this.nanosBetweenTokens = nanosBetweenTokens;
        Predef$.MODULE$.require(capacity >= 0L, TokenBucket::$init$$$anonfun$1);
        Predef$.MODULE$.require(nanosBetweenTokens > 0L, TokenBucket::$init$$$anonfun$2);
    }

    public void init() {
        this.availableTokens = this.capacity;
        this.lastUpdate = this.currentTime();
    }

    public abstract long currentTime();

    public long offer(long cost) {
        long l;
        long l2;
        if (cost < 0L) {
            throw new IllegalArgumentException("Cost must be non-negative");
        }
        long now = this.currentTime();
        long timeElapsed = now - this.lastUpdate;
        if (timeElapsed >= this.nanosBetweenTokens) {
            if (timeElapsed < this.nanosBetweenTokens * 2L) {
                this.lastUpdate += this.nanosBetweenTokens;
                l2 = 1L;
            } else {
                long tokensArrived = timeElapsed / this.nanosBetweenTokens;
                this.lastUpdate += tokensArrived * this.nanosBetweenTokens;
                l2 = tokensArrived;
            }
        } else {
            l2 = 0L;
        }
        long tokensArrived = l2;
        this.availableTokens = package$.MODULE$.min(this.availableTokens + tokensArrived, this.capacity);
        if (cost <= this.availableTokens) {
            this.availableTokens -= cost;
            l = 0L;
        } else {
            long remainingCost = cost - this.availableTokens;
            long timeSinceTokenArrival = now - this.lastUpdate;
            long delay = remainingCost * this.nanosBetweenTokens - timeSinceTokenArrival;
            this.availableTokens = 0L;
            this.lastUpdate = now + delay;
            l = delay;
        }
        return l;
    }

    private static final String $init$$$anonfun$1() {
        return "Capacity must be non-negative.";
    }

    private static final String $init$$$anonfun$2() {
        return "Time between tokens must be larger than zero nanoseconds.";
    }
}

