package o1.robots.gui

import scala.swing.event.Key
import scala.swing.*
import o1.robots.*
import o1.util.*
import o1.robots.tribal.*
import javax.imageio.ImageIO
import scala.language.adhocExtensions // enable extension of Swing classes

////////////////// NOTE TO STUDENTS //////////////////////////
// For the purposes of our course, it’s not necessary
// that you understand or even look at the code in this file.
//////////////////////////////////////////////////////////////

/** The class `RobotWindow` represents GUI windows that serve as the main
  * window of a tribe-enabled Robots application.
  *
  * **NOTE TO STUDENTS: In this course, you don’t need to understand how this class works or can be used.** */
open class TribalRobotWindow extends RobotWindow:
  window =>

  private object next99TurnsButton extends Button:
    action = Action("99 turns")( worldView.advanceTurns(99) )
    preferredSize = nextRobotTurnButton.preferredSize

  override protected def makeButtonRowComponents =
    Seq(tribeCounter, Swing.HStrut(10)) ++ super.makeButtonRowComponents :+ next99TurnsButton

  override protected def updateButtons(nextRobot: Option[RobotBody]) =
    super.updateButtons(nextRobot)
    this.next99TurnsButton.enabled = nextRobot.isDefined
    tribeCounter.update()

  override protected def createView(world: RobotWorld) = TribalDisplay(window, world)

  override protected val randomizer = o1.robots.tribal.Random

  private object tribeCounter extends Label:

    private var countForTribe = Map[Tribe, Int]()

    private def countBots(): Map[Tribe, Int] =
      window.worldView.robots.collect:
        case b: TribalBot => b.tribe
      .frequencies

    def update(): Unit =
      this.countForTribe = this.countBots()
      val fighters = this.countForTribe.keys.filter( tribe => !tribe.isPacifist )
      def describe(tribe: Tribe) = tribe.name.capitalize + ": " + this.countForTribe(tribe)
      this.text = if fighters.isEmpty then " " else fighters.map(describe).mkString(", ")

  end tribeCounter

  protected class TribalDisplay(parent: TribalRobotWindow, world: RobotWorld)
            extends RobotsDisplay(parent, world):

    override val popup = new SquarePopup:

      val tribeListMenu = new Menu("Add a tribal bot"):
        for (file, tribe) <- TribeLoader.All do
          contents += AddTribalBotItem(file.fileName.takeWhile( _ != '.' ), tribe)
      this.contents.prepend(tribeListMenu)

      class AddTribalBotItem(val tribeName: String, val tribe: Option[Tribe]) extends AbstractAddRobotItem(tribeName):
        val isAvailable = this.tribe.isDefined
        def requestBrain(body: RobotBody) =
          this.tribe.map( TribalBot(body, _) )

    end popup

    override def robotPic(robot: RobotBody) = robot.brain match
      case Some(tribal: TribalBot) => this.tribePics(tribal.tribe)
      case nonTribalBot            => super.robotPic(robot)

    val tribePics = TribeLoader.All.values.flatten.mapTo(this.tribePic)

    private def tribePic(tribe: Tribe) =
      val picURL = findReadable(TribeLoader.tribesDirName + tribe.name + ".png").map( _.toUri.toURL )
      val image = picURL.map( file => this.scalePic(ImageIO.read(file), fullSize = false) )
      image orElse this.getPic("unknown", false) orElse None

  end TribalDisplay

end TribalRobotWindow


/** The trait `TribalScenarios` can be mixed into a `TribalRobotWindow`
  * to provide a selection of ready-made scenarios in a GUI menu.
  *
  * **NOTE TO STUDENTS: In this course, you don’t need to understand how this trait works or can be used.** */
private[gui] trait TribalScenarios extends RobotScenarios:
  self: TribalRobotWindow =>

  private final val tribalScenarioMenu = new ScenarioMenu("Tribal"):
    mnemonic = Key.T
    this ++= scenario.Tribal.All.map( ScenarioItem(_) )

  this.menuBar.contents += tribalScenarioMenu

  override def scenarioMenus = super.scenarioMenus ++ Seq(tribalScenarioMenu)

end TribalScenarios

